%{
#include <string.h>
#define LINE_LENGTH 60
#define MAX_ITEM_ENV 32
#define MARGIN_INCREMENT 3
#define ITEMDECREMENT 2

char *ptr,*ptr1,*line_buffer,*outputfile,itemmode[MAX_ITEM_ENV],print_newline;
int leng,line_length,line_length1,line=1,leftmargin,rightmargin,tmpmargin,itemindex,
   itemcount[MAX_ITEM_ENV],last_itemize[MAX_ITEM_ENV],last_enumerate[MAX_ITEM_ENV],
   i_index,e_index;

int die(char *cmd,int mode);
void print_line(int mode);
void chk_len(char *ytext,int yleng);
void margin(int left,int right,int reset);
%}

%x TABLE VERBATIM

%option 8bit never-interactive noyywrap outfile="a_format.c"

SP    [ \t]+
SPO   [ \t]*
WS    [ \t\n]
WSO   [ \t\n]*
WORD  \\?[^ \-\\\t\n]+

ITEMIZE     ^"<@itemize1>"{SPO}\n
ENUMERATE1  ^"<@enumerate1>"{SPO}\n
ITEMIZE1    ^"<@itemize1"{SP}\([1aA*+-o]")>"{SPO}\n
ENUMERATE2  ^"<@enumerate2>"{SPO}\n
ITEMIZE2    ^"<@itemize2>"{SPO}\n

%%

<INITIAL,TABLE,VERBATIM>(\n{SPO}){2,} { /* multiple \n with optional spaces inserted */
      leng=line_length;
      print_line(0);
      for(ptr=yytext;*ptr++!='\n';);   /* remove the first \n (was printed in print_line) */
      while(*ptr){
         if(*ptr++=='\n')fputc('\n',yyout);
         line++;
      }
   }

^\\\- |
\\\-{WS}    yyless(2); chk_len(yytext,2);
{WS}\\\-    *(line_buffer+leng)=' '; leng++; *(line_buffer+leng)=0; chk_len("\\-",2);
\\\-        /* hyphenation using; ignore  \- */

^{SP}    /* ignore spaces at line begin */
{SP}$    /* ignore spaces at end of line */
\n    if(print_newline)ECHO; else{*(line_buffer+leng++)=' '; *(line_buffer+leng)=0;}
{SP}  *(line_buffer+leng++)=' '; *(line_buffer+leng)=0;

^"<@l_margin+1>"{SPO}\n   margin(1,0,0);
^"<@l_margin+>"{SPO}\n    margin(MARGIN_INCREMENT,0,0);
^"<@l_margin->"{SPO}\n    margin(-MARGIN_INCREMENT,0,0);
^"<@l_margin0>"{SPO}\n    margin(MARGIN_INCREMENT,0,1);
^"<@r_margin+>"{SPO}\n    margin(0,MARGIN_INCREMENT,0);
^"<@r_margin->"{SPO}\n    margin(0,-MARGIN_INCREMENT,0);
^"<@r_margin0>"{SPO}\n    margin(0,MARGIN_INCREMENT,1);
^"<@margin+>"{SPO}\n      margin(MARGIN_INCREMENT,MARGIN_INCREMENT,0);
^"<@margin->"{SPO}\n      margin(-MARGIN_INCREMENT,-MARGIN_INCREMENT,0);
^"<@margin0>"{SPO}\n      margin(MARGIN_INCREMENT,MARGIN_INCREMENT,1);

{ITEMIZE} {
      switch(last_itemize[i_index]){
         case '*':
            last_itemize[++i_index]=itemmode[++itemindex]='+';
            break;
         case '+':
            last_itemize[++i_index]=itemmode[++itemindex]='-';
            break;
         case '-':
            last_itemize[++i_index]=itemmode[++itemindex]='o';
            break;
         case 'o':
         default:
            last_itemize[++i_index]=itemmode[++itemindex]='*';
            break;
      }
      itemcount[itemindex]=1;
      margin(MARGIN_INCREMENT,0,0);
      print_newline=0;
      leng=0;
   }

{ENUMERATE1} {
      switch(last_enumerate[e_index]){
         case '1':
            last_enumerate[++e_index]=itemmode[++itemindex]='a';
            break;
         case 'a':
            last_enumerate[++e_index]=itemmode[++itemindex]='A';
            break;
         case 'A':
         default:
            last_enumerate[++e_index]=itemmode[++itemindex]='1';
            break;
      }
      itemcount[itemindex]=1;
      margin(MARGIN_INCREMENT,0,0);
      print_newline=0;
      leng=0;
   }

{ITEMIZE1}  {
      for(ptr=yytext;*ptr++!='1';);
      while(*ptr==' ' || *ptr=='\t')ptr++;
      itemmode[++itemindex]= *++ptr;
      if(*ptr=='1' || *ptr=='a' || *ptr=='A')
         last_enumerate[++e_index]= *ptr;
      else
         last_itemize[++i_index]= *ptr;
      itemcount[itemindex]=1;
      margin(MARGIN_INCREMENT,0,0);
      print_newline=0;
      leng=0;
   }

{ENUMERATE2} |
{ITEMIZE2} {
      if(itemindex>0){
         if(itemmode[itemindex]=='1' || itemmode[itemindex]=='a' || itemmode[itemindex]=='A')
            last_enumerate[e_index--]=0;
         else
            last_itemize[i_index--]=0;
         itemmode[itemindex--]=0;
         margin(-MARGIN_INCREMENT,0,0);
         print_newline=1;
      }
      else
         fprintf(stderr,"additional <@itemize2> in line %d of %s; skip it\n",line,outputfile);
   }
\\item{SPO}\n {
      if(leng){
         leng=line_length;
         print_line(0);
      }
      switch(itemmode[itemindex]){
         case '1': 
            sprintf(line_buffer,"%d.~",itemcount[itemindex]);
            break;
         case 'A':
         case 'a':
            if(itemcount[itemindex]<=26)
               sprintf(line_buffer,"%c)~",itemcount[itemindex]+itemmode[itemindex]-1);
            else if(itemcount[itemindex]<=26*26)
               sprintf(line_buffer,"%c%c)~",itemcount[itemindex]/26+itemmode[itemindex]-1,
                  itemcount[itemindex]+itemmode[itemindex]-1);
            else
               sprintf(line_buffer,"%c%c%c)~",itemcount[itemindex]/26/26+itemmode[itemindex]-1,
                  itemcount[itemindex]/26+itemmode[itemindex]-1,itemcount[itemindex]+itemmode[itemindex]-1);
            break;
         case '*':
         case '+':
         case '-':
         case 'o':
            sprintf(line_buffer,"%c~",itemmode[itemindex]);
            break;
         default:
            break;
      }
      tmpmargin=ITEMDECREMENT;
      leng=strlen(line_buffer);
      itemcount[itemindex]++;
   }
^"<@table1>"{SPO}\n |
^"<@verbatim1>"{SPO}\n {
      if(leng){
         leng=line_length;
         print_line(0);
      }
      print_newline=0;
      for(ptr=yytext;*ptr=='\n';ptr++)fputc(*ptr,yyout);
      if(*(ptr+2)=='v')
         BEGIN(VERBATIM);
      else
         BEGIN(TABLE);
}

<TABLE>^"<@table2>"{SPO}\n |
<VERBATIM>^"<@verbatim2>"{SPO}\n BEGIN(INITIAL); print_newline=1;

<TABLE,VERBATIM>{
 \n      line++; ECHO;
 [ \t<]  |
 [^ \t\n<]+ ECHO;
}

{WORD}  chk_len(yytext,yyleng); print_newline=0;

[^ \t\n]  chk_len(yytext,1); print_newline=0;

%%

void margin(int left,int right,int reset)
{
   int cnt= -1;

   print_newline=0;
   for(ptr=yytext;*ptr;)if(*ptr++=='\n')cnt++;
   if(leng){
      leng=line_length;
      cnt--;
      print_line(0);
   }
   if(reset){
      if(left){
         leftmargin=0;
         line_length=line_length1-rightmargin;
      }
      if(right){
         rightmargin=0;
         line_length=line_length1-leftmargin;
      }
   }
   else{
      if(left  && (leftmargin+=left)<0)leftmargin=0; else line_length-=left;
      if(right && (rightmargin+=right)<0)rightmargin=0; else line_length-=right;
   }
   if(cnt>0)while(cnt--)fputc('\n',yyout);
   BEGIN(INITIAL);
}

void chk_len(char *ytext,int yleng)
{
   if(leng+yleng>line_length){
      if(*(ptr=line_buffer+leng-1)==' ' || *ptr=='\t'){
         *ptr=0;
         leng--;
      }
      print_line(1);
   }
   if(leng<0)
      line=0;
   else{
      strcat(line_buffer,yytext);
      leng+=yleng;
   }
}

void print_line(int mode)
{
   int spc,cnt,num,i;

   for(ptr=line_buffer,spc=0;*ptr;)if(*ptr++==' ')spc++; /* count number of spaces */
   if(!spc)spc=1;
   cnt=(line_length+tmpmargin-leng)%spc;
   num=(line_length+tmpmargin-leng)/spc+2;
   if(num>3){
      if(mode && leng+yyleng-line_length<=num){  /* append the next word to the line */
         leng= -1;
         fprintf(stderr,"warning: overfull line %d of %s\n",line,outputfile);
      }
      else
         fprintf(stderr,"warning: underfull line %d of %s\n",line,outputfile);
   }
   for(i=0;i<leftmargin-tmpmargin;i++)fputc(' ',yyout);
   for(ptr=line_buffer;*ptr;ptr++)
      if(*ptr==' '){
         if(leng==-1)
            fputc(' ',yyout);
         else{
            if(cnt==0)num--;
            cnt--;
            for(i=0;i<num;i++)fputc(' ',yyout);
         }
      }
      else if(*ptr=='~')
         fputc(' ',yyout);
      else
         fputc(*ptr,yyout);
   if(leng==-1)fprintf(yyout," %s\n",yytext); else{
   fputc('\n',yyout);leng=0;}
   line++;
   tmpmargin=0;
   *line_buffer=0;
}

int main(int argc,char **argv)
{
   if(argc<3){
      printf("No input/outputfile given; exit\n");
      exit(2);
   }
   *(line_buffer=malloc(1024))=0;
   line_length1=line_length=(argc>3) ? atoi(argv[3]) : LINE_LENGTH;
   (yyin=fopen(argv[1],"r")) || die(argv[1],1);
   (yyout=fopen(outputfile=argv[2],"w")) || die(argv[2],2);
#ifdef FLEX_DEBUG
   (freopen("a_format.dbg","w",stderr)) || die("a_format.dbg",2);
#endif
   yylex();
   if(leng){
      leng=line_length;
      print_line(0);
   }
#if VMS
   return 1;
#else
   return 0;
#endif
}

int die(char *cmd,int mode)
{
   switch(mode){
      case 1:
         fprintf(stderr,"Can't open %s for read; exit\n",cmd);
         exit(4);
      case 2:
         fprintf(stderr,"Can't open %s for write; exit\n",cmd);
         exit(4);
      case 3:
         fprintf(stderr,"%s\n",cmd);
         exit(4);
      default:
         return 0;
   }
}
