#include <stdlib.h>;
#include <stdio.h>;
#include <stdarg.h>
#include <alloc.h>;
#include <dos.h>;
#include "mcgalib.h";
#include "animlib.h";

#define MCGA 19
#define TEXT 3

char *BLOCKSAVE;             /* Pointer on buffer for screen block */

#define SHIP_SERIES 1
#define SCENERY_SERIES 3

void main()
{
 int sprite;
 int last_sprite;
 int x, y, yold;
 int SPRMAX;
 int flip;

/* First, allocation of memory buffer */

  BLOCKSAVE = (char *) malloc(6406);
  if(sprite_alloc() == 0)
   {
     puts("Alloc error...");
     exit(0);
   }

/* Loading sprites  */

 printf("Loading %s... ", "invaders.dat");
 SPRMAX = sprites_load("invaders.dat", 65512U);
 if(!SPRMAX)
  {
   printf("file no found %s", "invader.dat");
   exit(0);
  }

/* Setting VGA 256 colors screen */

 selectscreen(MCGA);

/* Setting a full screen window */

 window19(0, 0, 319, 199);

/* Drawing the scenery */

 for(y = 0; y < 2; y++)
  for(x = 0; x < 4; x++)
   csprite256c(x * 80, y * 80 + 20, GETSPADR(get_first(SCENERY_SERIES)));

/* Now, setting window's limits left, top, right, bottom */

 window19(40, 20, 280, 179);

/* Animation example */

 x = 140;
 y = 5;
 yold = y;
 getblock(x, yold, x + 31, y + 49, BLOCKSAVE);    /* Saving background */
 flip = 0;

 /* Starting at the first image in the ship animation */
 /* On dmarre avec la premire image de l'animation de vaisseau */

 sprite = get_first(SHIP_SERIES);

 /* The last sprite is number of the first + number of frames - 1 */
 /* Le dernier sprite est le numro du premier + nombre de frames - 1 */

 last_sprite = sprite + get_frame_number(SHIP_SERIES) - 1;

 while(y < 180)
 {
  synchro();

  putblock(x, yold, BLOCKSAVE);              /* Restoring background */
  getblock(x, y, x + 31, y + 49, BLOCKSAVE); /* Saving new area */
  sprite256c(x, y, GETSPADR(sprite));        /* Sprite display */

  if(kbhit()) goto finish;

  flip ^= 1;             /* Slow cycling / Ralentit cyclage */
  if(flip)
  if(++sprite > last_sprite)
    sprite = get_first(SHIP_SERIES);         /* Last sprite reached, restart */

  delay(150);         /* Slow down and set all computers same speed */
  yold = y;
  y++;
}

finish:
 selectscreen(TEXT);    /* Restores DOS text screen */
 exit(0);               /* Exit program */
}
