; Macros for utilizing the RDTSC instruction on the Pentium

%macro TSCCalculateOverhead 0

; Idea: Calculate the overhead dynamically by timing nothing (and finding
;       the number of cycles needed to measure 0 actual cycles

  pushad                       ; Cache EFLAGS (necessary for consistency)
  popad
  pushad                       ; We don't want to disturb anything
  mov eax, [cs:TSCOverhead]    ; Cache EAX and TSCOverhead
  imul dword [cs:TSCOverhead]  ; Stall the pipeline so RDTSC executes in
                               ;   the right pipe
  rdtsc                        ; Read the initial value of the counter
  mov [cs:TSCOverhead], eax    ; Store it for later reference
  popad                        ; Restore to previous state

                               ; Do nothing

  pushad                       ; Store status
  imul edx                     ; Stall the pipeline
  rdtsc                        ; Read the final value
  cs sub eax, [TSCOverhead]    ; Subtract the initial value
  inc ax                       ; Fudge factor (yes, it's necessary)
  inc ax
  cs mov [TSCOverhead], eax    ; Store the overhead time

  popad                        ; Return to previous state
%endmacro

%macro TSCBegin 0
  pushad                       ; Cache EFLAGS
  popad
  pushad                       ; Save the register values
  mov eax, [cs:TSC]            ; Cache EAX and TSC
  imul dword [cs:TSC]          ; Stall the pipeline
  rdtsc                        ; Read the current value
  cs mov [TSC], eax            ; Store it
  popad                        ; Restore the register values
%endmacro

%macro TSCEnd 0
  pushad                       ; With time, EFLAGS will not be cached,
                               ;   so cycles reported will be a little off
  imul edx                     ; Stall the pipeline
  rdtsc                        ; Guess
  sub eax, [cs:TSCOverhead]    ; Subtract overhead cycles
  sub eax, [cs:TSC]            ; Subtract the initial time
  mov [cs:TSC], eax            ; Store the final value
  popad                        ; Restore the register values
%endmacro

%macro TSCReport 0
  push cs                      ; Use at the end of program so all that is
  pop ds                       ;   left is termination
  mov dx, sTheAnswerWas        ; Write 'The answer was: '
  mov ah, 9
  int 21h

  mov eax, [TSC]               ; Value to convert to decimal
  mov ebp, -10                 ; Number of digits
%%a:
  mov ebx, [TSCTableEnd + ebp*4]    ; Load EBX with next divisor
  xor edx, edx                      ; Clear EDX for division
  div ebx                      ; Digit in EAX, next dividend in EDX
  xchg eax, edx                ; Dividend in EAX, digit in EDX
  push eax
  push edx
  add dl, '0'                  ; Convert to ASCII
  mov ah, 6                    ; Output character in DL
  int 21h
  pop edx
  pop eax
  inc ebp                      ; Move to next divisor
  jnz %%a
%endmacro

%macro TSCVariables 0
  TSCOverhead resd 1
  TSC         resd 1
%endmacro

%macro TSCConstants 0
  sTheAnswerWas db 'The answer was: $'

  dd 1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1
TSCTableEnd:

%endmacro
