\ NUMPATH - 1997 by Andy Kurnia <akur@iname.com>
\
\ Game name:
\     Numbered Path.
\
\ Default EQUate values and their (hopefully) allowable ranges:
\     0 <= (BA =  30H) <=   0FFH
\     1 <= (NP =   9 ) <=    7FH
\     1 <= (NX =  30 ) <=    38
\     1 <= (NY =  20 ) <=    23
\     1 <= (TL = 300 ) <= 0FFFFH
\
\ Object:
\     Move from left to right thru a numbered path (NX x NY).
\
\ Rules:
\ 1.  You may move only one space up, down, left or right (no diagonals).
\ 2.  The number from which you move and the number to which you move should
\     be equal or have a difference of exactly one, eg. from 3 you can move
\     to 2, 3 or 4 if this is allowed by rule 1.
\ 3.  You may not move back, ie. you must always move to new places.
\ 4.  The process must be done in TL seconds or less.
\
\ You win if:
\     You can reach the right edge of the path safely.
\
\ You lose if:
\ 1.  You fail to reach the right edge of the path within the TL seconds
\     time limit.
\ 2.  You make an illegal move according to rules 2 or 3.
\ 3.  You surrender. This is done by pressing Esc.
\
\ Program Usage:
\ 1.  Make sure Num Lock is off.
\ 2.  Execute to display a randomly generated path.
\ 3.  The time begins from TL seconds.
\ 4.  Use the up, down, left and right arrows on the keypad to navigate.
\ 5.  You will be told when you win or lose.
\
\ Notes:
\ 1.  This program was designed to be small and simple as it is entered to
\     the Programming Tips & Tricks Issue 4 16K-Game Competition. This free
\     low-level programming magazine is edited by Tenie Remmel and can be
\     obtained from:
\         http://www.simtel.net/pub/simtelnet/msdos/pgmtips/ptt004.zip
\         ftp://ftp.simtel.net/pub/simtelnet/msdos/pgmtips/ptt004.zip
\     Similar filenames can be used to get other issues. Back issues are
\     available as well.
\ 2.  As such, many things that were considered have been excluded. For
\     instance, pressing Ctrl+Break will force the program to end. However,
\     pressing Esc at anytime will tell the program to end and declare you
\     lose. This also restores the hidden cursor.
\ 3.  Your score is the time left.
\ 4.  This source code is FREE! Many, many thanks to me.
\ 5.  It is more commented than most of my programs.
\ 6.  You need NEGA 3.22 or later, TASM 3.2 or later and TLINK 5.1 or later
\     to make this a COM file:
\         NEGA NUMPATH
\         TASM /m9 NUMPATH
\         TLINK /t/x NUMPATH
\ 7.  A 386+ PC is required, preferably FASTER. Also, a color monitor is
\     required (VGA preferred, but CGA should work).
\ 8.  The EQUates at the beginning of the file may be changed provided the
\     new values are still acceptable (see above for range and defaults).
\     Please allow enough time for the players! The characters used are
\     BA+1..BA+NP (note that BA itself is not used). BA=40H, NP=26 to make
\     the game use uppercase letters; BA=60H, NP=26 for lowercase. Of course
\     this change would change the game name to "Letter Path", but who cares?
\ 9.  Enjoy!
\
\ Send comments, suggestions, bug reports etc. to:
\     Andy Kurnia <akur@iname.com>

O EQU OFFSET;                           \ A shorthand (Offset).
B EQU 1 PTR;                            \ Another shorthand (Byte ptr).
E EQU ((12-(NY SHR 1)) SHL 8)+41-NX;    \ Yet another shorthand (Equation).
BA EQU 30H;                             \ Base. 40H=UPPERCASE, 60H=lowercase.
NP EQU 9;                               \ Number of Possibilities: 26=A..Z.
NX EQU 30;                              \ Number of X.
NY EQU 20;                              \ Number of Y.
TL EQU 300;                             \ Time Limit in seconds.
.MODEL TINY;                            \ A .COM program.
.386;                                   \ Using 386 instructions.
.CODE;                                  \ With the following code.
ORG 100H;                               \ Starting after its PSP.
MAIN:                                   \ Main program.
  DI=O(FIELD); CX=(NY*NX); =CX =DI;     \ Push field area (NY*NX) and @FIELD.
  &AX; <>*=;                            \ Zero-fill field.
  =.RAND; AAM NY; *; CURY=SI=AX; DX==AX;\ SI=DX=0..NY-1 (row, CX,DX=resume).
  &BX;                                  \ BX=CX=0 (column, BX,SI=current).
  =.RAND; AAM NP; AX+;                  \ AL=1..NP (starting number).
  =.CALC; *=;                           \ Put it.
  { { =.CALC; BP=DI; =.RAND; AAM 7;     \ BP=current address.
      AL>1; *;                          \ AX=direction.
      { =={ SI-; ++1; SI+; };           \ 0,1=up (SI-), provided SI >= 0.
        AX-; =={ BX-; ++1; BX+; .};     \ 2,3=left (BX-), provided BX >= 0.
        AX-; =={ SI+; SI-NY? <1; SI-;.};\ 4,5=down (SI+), provided SI < NY.
        AX-; BX+; BX-NX? <; BX-; };     \ 6=right (BX+), provided BX < NX.
      =.CALC; [DI]-AL? ==;              \ If new position is still 0, exit.
      BX=CX; SI=DX; }.;                 \ Otherwise jump to resume address.
    BX-CX? >{ CX=BX; DX=SI; };          \ Resume from rightmost position.
    =.RAND; AAM 3; AX-;                 \ AL=-1..1.
    AL+[BP];                            \ Adjust last number.
    <={ AX+; };                         \ If < 1, increase again.
    AL-NP? >{ AX-; };                   \ If > NP, decrease again.
    *=;                                 \ Store the new number.
    BX-(NX-1)? }<;                      \ Repeat up to the right edge.
  CX= SI=;                              \ Fill the unfilled zeroes.
  { =*; AL? =={ =.RAND; AAM NP; AX+;    \ With a random 1..NP.
      [SI-1]=AL; }; }-.;                \ The address is now [SI-1].
  ES=CX;                                \ Set ES to 0.
  FS=ES:[46CH];                         \ Initialize counter.
  AX=3; !10H;                           \ Set text mode.
  AH=1; CH=20H; !10H; &BP;              \ Hide cursor and zero time-counter.
  { =.DISP;                             \ Display.
    AX=FS; { AX-ES:[46CH]? }==; AX+;    \ Wait for current tick to change.
    FS=AX;                              \ Save new tick.
    BP+; BP-18? >>={ &BP; TLFT-;        \ There are 18.2 ticks per second.
      <=};                              \ Exit if time out.
    AH=1; !16H;                         \ Check for key.
    <>{ SI=CURY; BX=CURX; =.CALC; CX=DI;\ If there is a key, CX=position.
      &AH; !16H;                        \ Get key.
      AL-27? ==1;                       \ Esc to quit.
      AL? <>;                           \ Ignore if not arrow keys.
      { AH-'H'? =={ SI-; ++};           \ Up.
        AH-'K'? =={ BX-; ++};           \ Left.
        AH-'P'? =={ SI+; SI-NY? <};     \ Down.
        AH-'M'? =={ BX+; BX-NX? <}; .}; \ Right. Ignore other extended keys.
      CURY=SI; CURX=BX; =.CALC;         \ Recalculate.
      SI=CX; AL=[SI]-[DI];              \ Calculate difference.
      B([SI])|80H;                      \ Mark as visited.
      *; AX-; ==; AX+; ==; AX+; <>};    \ If not allowed, exit.
    CURX-(NX-1)? }<;                    \ Have you won?
  =.DISP;                               \ Redisplay.
  AH=2; DL=10; !10H;                    \ Move cursor beside score.
  DX=O(LOSE);                           \ Did you lose?
  CURX-(NX-1)? >={ DX=O(WIN); };        \ Or did you win?
  AH=9; !21H;                           \ Either way, report the result.
  AH=2; DX=(E+(NY SHL 8)); !10H;        \ Move to the last line of field.
  AH=1; CX=607H; !10H;                  \ Restore cursor.
  .=;                                   \ Return to DOS.
DISP:                                   \ Display.
  &BX; SI=O(FIELD); CX=NY;              \ Y-loop to write lines.
  { =CX; CL=NX;                         \ Push Y. X-loop to write characters.
    { DI=; =DI =CX;                     \ DI=Y, then re-push Y and X.
      -CX; -DI; CX+NX; DI+NY;           \ Reverse those values and calculate.
      DX=DI<7+CX<1+E;                   \ A very long equation.
      AH=2; !10H;                       \ Move cursor according to DX above.
      =*; AAM 80H; BL=AH; BX+; BX*7;    \ Color 7=normal, 14=visited.
      CX-CURX? =={ DI-CURY?             \ Check for current position.
        <>; BL=15; };                   \ The current position uses color 15.
      AH=9; AL+BA; CL=1; !10H;          \ Display the number in color!
      CX=; }-.;                         \ Continue X-loop.
    CX=; }-.;                           \ Continue Y-loop.
  DX=4;                                 \ Four hex nibbles to display.
  BL=10; TLFT-(TL/5)? <={ BL=12; };     \ Color 12 if 4TL/5 elapsed, else 10.
  { AH=2; !10H;                         \ Adjust cursor position, backwards.
    AL=B(TLFT)&0FH-0AH? AL--69H; DAS;   \ The time left in hexadecimal!
    AH=9; CL=1; !10H;                   \ Show it.
    TLFT>>4; DX-; }<>;                  \ Get next nibble.
  .=;                                   \ Return.
CALC:                                   \ Calculate offset.
  DI,SI*NX; DI===[BX+DI+O(FIELD)]; .=;  \ Calculate DI=SI*NX+BX+@FIELD.
RAND:                                   \ Random number generator.
  AX,[RNUM]*9421+; [RNUM]=AX; .=;       \ In: DS=CS, Out: AX=random word.
LOSE DB 'You lose.$';                   \ Lose string.
WIN  DB 'You WIN!$';                    \ Win string.
TLFT DW TL;                             \ Automatically initialized.
CURX DW 0;                              \ So is this.
CURY DW ?;                              \ This can be anything.
RNUM DW ?;                              \ Last random number.
FIELD DB (NY*NX) DUP (?);               \ Playing field.
END MAIN;                               \ May the program begin.
