#include <stdio.h>

main(int argc, char *argv[])
{
    FILE *in, *out;
    int i, j, c, s;
    unsigned buf;

    if(argc < 3) {
        printf("syntax: encode <in> <out>\n");
        return 1;
    }
    if((in = fopen(argv[1], "rb")) == NULL) {
        printf("error opening input file\n");
        return 1;
    }
    if((out = fopen(argv[2], "wb")) == NULL) {
        fclose(in);
        printf("error opening output file\n");
        return 1;
    }
    buf = j = 0; s = 8;
    while((c = getc(in)) != EOF) {
        buf |= (c << s);
        s -= 8;
        while(s <= 3) {
            i = (buf >> 11) & 0x1F;
            buf <<= 5;
            s += 5;
            if(i < 10)
                 putc(i+0x30, out);
            else putc(i+0x37, out);
            if(++j == 64) {
                j = 0;
                putc(0x0D, out);
                putc(0x0A, out);
            }
        }
    }
    if(s < 8) {
        i = (buf >> 11) & 0x1F;
        if(i < 10)
             putc(i+0x30, out);
        else putc(i+0x37, out);
    }
    if(++j == 64) {
        putc(0x0D, out);
        putc(0x0A, out);
    }
    putc('Z', out);
    putc(0x0D, out);
    putc(0x0A, out);
    fclose(in);
    fclose(out);
    return 0;
}
