org 100h            ; First decoder - 26 bytes

; It is probably possible to do this in 4 less bytes with the undocumented
; AAM or AAD varieties, but I wanted it to be compatible with the 8086

    mov si,0204h    ; Offset of second decoder
    mov di,0FB41h   ; Destination offset (arbitrary, but
    push di         ; must be relatively high in memory)
    mov cx,3904h    ; Length of second decoder in CH
decloop:            ; Shift value (4) in CL
    lodsw           ; Load two bytes of encoded data
    sub ax,4141h    ; Subtract out the letter 'A' from each
    jc decloop      ; If less (i.e., a CR/LF) then ignore
    shl al,cl       ; Combine these two 4-bit numbers into
    or al,ah        ; a single byte (in AL)
    stosb           ; Store the byte in memory
    dec ch          ; Loop back for CH iterations
    jnl decloop
    ret             ; Jumps to second decoder (offset was
                    ; pushed at the beginning of this one)
