program TVterm;

(*********************************************)
(*                                           *)
(*          TVTERM.PAS      July 1993        *)
(*                                           *)
(*  TVTERM is provided as a simple terminal  *)
(*  program which is provided as an example  *)
(*  of how to use PCL4P with Turbo Vision.   *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*                                           *)
(*********************************************)

uses Objects, Drivers, App, PCL4P;

type
  PTVtermApp = ^TTVtermApp;
  TTVtermApp = object(TApplication)
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
  end;

(* global comm variables *)

var
   RetCode : Integer;
   BufPtr  : Pointer;
   BufSeg  : Integer;

procedure TTVtermApp.Idle;
begin
  (* copy any received serial input to the screen *)
  RetCode := SioGetc(COM1,0);
  if RetCode>-1 then write( char(RetCode) )
end;

{ TTVtermApp }

procedure TTVtermApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  (* process the event *)
  case Event.What of
      evKeyDown:
        begin
          (* transmit any keyboard input *)
          RetCode := SioPutc(COM1,Event.CharCode);
        end;
  else ClearEvent(Event);
  end
end;

var
  TVtermWorld: TTVtermApp;

begin
  (* initialize the comm *)
  GetMem(BufPtr,1024+16);
  BufSeg := Seg(BufPtr^) + ((Ofs(BufPtr^)+15) SHR 4);
  RetCode := SioRxBuf(COM1, BufSeg, Size1024);
  if SioInfo('I') > 0 then
    begin
      GetMem(BufPtr,128+16);
      BufSeg := Seg(BufPtr^) + ((Ofs(BufPtr^)+15) SHR 4);
      RetCode := SioTxBuf(COM1, BufSeg, Size128);
    end;
  RetCode := SioReset(COM1,Baud2400);
  (* run Turbo Vision *)
  TVtermWorld.Init;
  TVtermWorld.Run;
  TVtermWorld.Done;
  (* shut down the comm *)
  RetCode := SioDone(COM1);
end.

                                                                                                                 