/*--------------------------------------------------------------------
   Alged:  Algebra Editor    henckel@vnet.ibm.com

   Copyright (c) 1994 John Henckel
   Permission to use, copy, modify, distribute and sell this software
   and its documentation for any purpose is hereby granted without fee,
   provided that the above copyright notice appear in all copies.
*/
#include "alged.h"
/*-----------------------------------------------------------------
   memory allocation
*/
void checknull(void *p) {
  if (!p) {
    printf(msg[20]);  /* heap memory is all used up! */
    delay(2000);
    exit(1);
  }
}

node *newnode(void) {
  node *p;
  p = malloc(sizeof *p); checknull(p);
  p->tag = 12345;
  p->nump = 0;
  p->msg = NULL;
  p->kind = VAR;
  strcpy(p->name,"??");
  return p;
}

node *newnum(double val) {
  node *p;
  p = malloc(sizeof *p); checknull(p);
  p->tag = 12345;
  p->nump = 0;
  p->msg = NULL;
  p->kind = NUM;
  p->value = val;
  return p;
}

node *newvar(char *s) {
  node *p;
  p = newnode();
  strcpy(p->name,s);
  return p;
}

node *newoper(int kind) {
  node *p;
  p = malloc(sizeof *p); checknull(p);
  p->tag = 12345;
  p->nump = 2;
  p->msg = NULL;
  p->kind = kind;
  p->lf = p->rt = NULL;
  strcpy(p->name,kname[kind]);
  return p;
}

void freenode(node *p) {
  if (!p || p->tag != 12345) {
    printf(msg[21]);
    pause; return;
  }
  p->tag = 0;
  p->nump = 0;
/*  if (p->msg) free(p->msg);  */
  p->msg = NULL;
  p->kind = VAR;
  strcpy(p->name,msg[23]);
  free(p);
}

void freetree(node *p) {
  int i,n;
  if (!p || p->tag != 12345) {
    printf(msg[22]);
    pause; return;
  }
  n = p->nump;
  p->tag = 0;
  p->nump = 0;
/*  if (p->msg) free(p->msg);      */
  p->msg = NULL;
  p->kind = VAR;
  strcpy(p->name,msg[23]); /* FREE */
  for (i=0; i<n; ++i)
    freetree(p->parm[i]);
  free(p);
}

/*-----------------------------------------------------------------
   nodecpy, use this to copy one node over another.  The only
   thing is that "next" is preserved to not disrupt the main
   node linked list.
*/
void nodecpy(node *a, node *b) {
  node *nx;
  nx = a->next;
  memcpy(a,b,sizeof(*a));
  a->next = nx;
}

/*-----------------------------------------------------------------
   set a=b,
   frees a, then copies b into it and frees b.
*/
void movenode(node *a, node *b) {
  int i;
  for (i=0; i<a->nump; ++i)
    freetree(a->parm[i]);        /* free children */
  nodecpy(a,b);
  freenode(b);
}

/*-----------------------------------------------------------------
   cons  -- create a new node with left,opr,right or if left is
        null, just return right.
*/
node *cons(node *left,int opr,node *right) {
  node *a;
  if (!left) return right;       /* empty list */
  a = newoper(opr);
  a->lf = left;
  a->rt = right;
  return a;
}
/*-----------------------------------------------------------------
   deepcopy a node
*/
node *deepcopy(node *p) {
  int j;
  node *t;
  t = newnode();
  nodecpy(t,p);
  for (j=0; j<p->nump; ++j)
    t->parm[j] = deepcopy(p->parm[j]);
  return t;
}
/*-----------------------------------------------------------------
   lastnode
*/
node *lastnode(node *p) {
  while (p && p->next) p=p->next;
  return p;
}

/*-----------------------------------------------------------------
   prevnode
*/
node *prevnode(node *p) {
  node *t;
  for (t=firf; t && t->next!=p; ) t=t->next;
  return t;
}

/*-----------------------------------------------------------------
   reverse the node list
*/
node *reverse(node *b) {
  node *a,*c;
  a = NULL;
  while (b) {
    c = b->next;
    b->next = a;
    a = b;
    b = c;
  }
  return a;
}

