/* lotag.c
 * ANSI C kludge to convert HTML tags to lower case
 * preserving the contents of quoted things
 *
 * To reverse it, change tolower(C) (line 45) to toupper(C)
 * and name as uptag.c
 *
 * Use: LOTAG < inputfile [>outputfile]
 *
 * NOTES: 1. Characters higher than 127d will not be converted
 *        2. Comments will be converted
 *        3. You're on your own about this code, and so am I.
 *
 * Joao C de Magalhaes, 1997
 * jcm@individual.EUnet.pt
 */

#include <stdio.h>
#include <ctype.h>

int main(void)
   {
   int C, InBracket, Convert;

   C = InBracket = Convert = 0;

   while((C=getchar()) != EOF)
      {
      if (C == '<')
	 {
	 InBracket = 1;
	 Convert = 1;
	 }
      if (C == '>')
	 {
	 InBracket = 0;
	 Convert = 0;
	 }
      if (InBracket)
	 {
	 if (C == '\"')
	    if (Convert) Convert = 0;
	    else Convert =1;
	 }
      if (Convert) putchar(tolower(C));
      else putchar(C);
      }


   return 0;
   }
