#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "include\vesa.h"
#include "include\vflat.h"

void main()
{
  VBE_CRTCInfo VBECrtcInfo;
  vfStatus stat;
  int res = VBE_init();
  VBE_vbeInfo VBEInfo;
  if (!VBE_getVBEInfo(&VBEInfo)) {
     printf("Could not initiate VBE");
     return;
  }
  printf("VBE initiated: ");
  if (res) printf("OK\n"); else printf("ERROR\n");
  printf("VBE version:    %d.%d\n"
         "VBE Oem    :    %s\n"
         "Total memory:   %d MB\n",
         VBEInfo.VbeVersion>>8,
         VBEInfo.VbeVersion & 0xF,
         VBEInfo.OemStringPtr,
         VBEInfo.TotalMemory*64);

  if (VBEInfo.VbeVersion>=0x200) {
      printf("VBE Software revision: %d\n"
             "VBE Oem Vendor:        %s\n"
             "VBE Product name:      %s\n"
             "VBE Product Revision:  %s\n",
             VBEInfo.OemSoftwareRev,
             VBEInfo.OemVendorNamePtr,
             VBEInfo.OemProductNamePtr,
             VBEInfo.OemProductRevPtr);
  }

  printf("\nSelect method to initiate VFlat:\n"
         "  1 - Autodetect\n"
         "  2 - Force Software emulation\n"
         "  3 - Force Hardware detection\n\n");
  char ch;
  while (ch!='1' && ch!='2' && ch!='3') ch = getch();
  switch (ch) {
     case '1': res=vfInit(); break;
     case '2': res=vfInit(vfSoftware); break;
     case '3': res=vfInit(vfHardware);
  }
  /* vfInit() can return vferrNoVBE or vferrEmulationFailed error code */
  /* In debug mode notify message about error will appear.             */
  if (res==vferrOK) printf("\nVFlat initiated successfully. Press any key to continue.\n");
  else exit(1);

  getch();
  int a;
  if ((a=vfSetMode(0x4101))!=vferrOK) {
     printf("error setting mode 640x480x8 = %x with LFB",a);
     vfDone(); /* don't forget to deinitiate VFlat before exiting! */
     exit(1);
  }
  vfReturnStatus(&stat); /* read mode information */

  /* fill screen with random pixels */
  for (int j=0; j<500000; j++)
      stat.linbase[((unsigned)rand()%RAND_MAX)*10 + (unsigned)rand()%10] = rand()%255;

  getch();

  vfCloseMode();
  printf("Structure returned by vfReturnStatus():\n"
         "mode    :    %x\n"
         "physbase:    %x\n"
         "linbase :    %x\n"
         "maptype :    %s\n"
         "vendor id:   %x\n"
         "device id:   %x\n\n"
         "Note: with Software emulation vendor_id, device_id and physbase fields\n"
         "         will be undefined.\n"
         "      with VBE support vendor_id and device_id fileds will be undefined.\n",
         stat.mode,
         stat.physbase,
         stat.linbase,
         (stat.maptype==1 ? "software": (stat.maptype==2 ? "hardware":"VBE map")),
         stat.vendor_id,
         stat.device_id);
  vfDone();
}
