#include <ctype.h>
#include <dos.h>
#include <dpmi.h>
#include <go32.h>
#include <new.h>
#include <pc.h>
#include <std.h>
#include <stdio.h>
#include <sys/farptr.h>
#include <sys/movedata.h>
#include <time.h>
/*-----*/
#define reg register
#define uns unsigned
typedef uns char byte;
typedef uns long ul;
typedef uns short us;
inline double sq(double x){return x*x;}
#define pk __attribute__((packed))
/*----- calling interrupts */
#define SEL _go32_info_block.selector_for_linear_memory
typedef struct{long di,si,bp,res,bx,dx,cx,ax pk;
    short flags,es,ds,fs,gs,ip,cs,sp,ss pk;} Regs;
Regs R;
inline void Int(int intno){__dpmi_int(intno,(__dpmi_regs *)&R);};
#define Rzeroflag (R.flags&0x40)
#define Rcarry (R.flags&1)
#define TBaddr _go32_info_block.linear_address_of_transfer_buffer
#define segoff(x,y,z) ((x)=(z)>>4,(y)=(z)&15)
/*-----*/
int beep(){R.ax=0x0200; R.dx=7; Int(0x21); return 0;}
/*-----*/
byte get_key(){R.ax=0x700; Int(0x21); return R.ax&255;}
/*----- = current screen mode */
char VESA;
/*-----*/
char testforVESA(){R.ax=0x4f03; Int(0x10); return VESA=(R.ax&0xff)==0x4f;}
/*-----*/
int vesa_mode(void) {R.ax=0x4f03; Int(0x10); return R.bx&0xfff;}
/*-----*/
int gp_mode(void) {
    if(VESA) return vesa_mode();
    R.ax=0xf00; Int(0x10); return R.ax&255;}
/*----- screen mode := m */
int vesa_mode(int m) {R.ax=0x4f02; R.bx=m; Int(0x10); return vesa_mode();}
/*-----*/
int gp_mode(int m) {
if(VESA) return vesa_mode(m);
if(m<0x100) {R.ax=m&255; Int(0x10);} return gp_mode();}
/*-----*//* conventional memory, in CONVMEM.CC :- */
class c_mem {public: _go32_dpmi_seginfo x;
    inline c_mem(int nbytes){
        x.size=nbytes; _go32_dpmi_allocate_dos_memory(&x);};
    inline void segof(short&s,long&o){s=x.rm_segment; o=x.rm_offset;};
    inline ~c_mem(){_go32_dpmi_free_dos_memory(&x);};};
/* typedef struct {uns long size, pm_offset;
      uns short pm_selector, rm_offset, rm_segment;} _go32_dpmi_seginfo; */;
/*-----*/
class c_b_addr; class c_s_addr;
/*-----*/
class c_b {public: uns int addr;
inline c_b_addr&adr();
inline char operator=(char c){_farpokeb(SEL,addr,c); return c;};
inline operator char(){return _farpeekb(SEL,addr);};
inline val(){return _farpeekb(SEL,addr);};};
/*-----*/
class c_b_addr {public: uns int addr;
inline c_b operator[](int i){c_b x; x.addr=addr+i; return x;};
inline c_b_addr operator+(int i){c_b_addr x; x.addr=addr+i; return x;};
inline c_b_addr(c_mem&m){addr=m.x.rm_segment*16+m.x.rm_offset;};
inline c_b_addr(uns int Addr=0){addr=Addr;};
inline c_b_addr(uns short Seg,uns short Offset){addr=Seg*16+Offset;};
inline c_b operator*(){return*(c_b*)this;};};
/*-----*/
inline c_b_addr&c_b::adr(){return*(c_b_addr*)this;}
/*-----*/
class c_b_array:public c_b_addr{public: c_mem m;
inline c_b_array(int n): m(n){addr=m.x.rm_segment*16+m.x.rm_offset;};
inline ~c_b_array(){_go32_dpmi_free_dos_memory(&m.x);};};
/*-----*/
int gp_mode(void); int vesa_mode(void); /* current screen mode */
int gp_mode(int m); int vesa_mode(int m); /* screen mode := m */
/*-----*//* information about screen modes */
typedef struct modeinfo {uns short modeattr pk; byte waattr,wbattr pk;
    uns short wgran,wsize,waseg,wbseg pk; long farwposfn pk;
    uns short bytesperline,wide,high pk; byte cwide,chigh,nplanes,bitsperpixel,
    nbanks,memmod,banksize,npages,res1,redsize,redpos,greensize,greenpos,
    bluesize,bluepos,ressize,respos,dircolor pk;
    int getinfo(int mode);
    void modeinfo::pr(FILE*F,int n);
  inline int Size(){return (wide<<16)+high;};
  inline int Type(){return (memmod<<16)+((bitsperpixel/nplanes)<<8)+nplanes;};};
char*modetitle="mode          wA wB gran wsize  wAbeg   wBbeg  byt wide high\
  char mem bit/ nb mem bank img red red grn grn blu blu res res dir\n\
              attr                             /ln           wd hi pls pixl\
 nk mdl size pgs msk pos msk pos msk pos msk pns col\n";
char*MT[8]={"txt","cga","vga","16c","ppg","256","drc","YUV"};
void modeinfo::pr(FILE*F,int n){fprintf(F,
"0x%03x %s %s%2d%2d %4dK %4dK 0x%04x0 0x%04x0 %4d %4d %4d %2d %2d %3d  %2d %3d\
 %s%5d %3d%4d%4d%4d%4d%4d%4d%4d%4d%4d\n",
  n,(modeattr&8)?"col":"mon",(modeattr&16)?"gra":"txt",waattr,wbattr,wgran,
  wsize,waseg,wbseg,bytesperline,wide,high,cwide,chigh,nplanes,bitsperpixel,
  nbanks,MT[memmod&7],banksize,npages,redsize,redpos,greensize,greenpos,
  bluesize,bluepos,ressize,respos,dircolor);}
modeinfo M;
char*MTF[9]={"text","CGA graphics","VGA (Hercules) graphics","1 bit per pixel",
  "each pixel is represented by a palette number",
  "`sequ 256' (non-chain 4) graphics",
  "direct colour (red & green & blue brightness levels)",
  "YUV (luminance-chrominance, also called YIQ)","unknown"};
char typeOK[16]={0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0};
enum {_txt,_cga,_vga,_16c,_ppg,_256,_drc,_YUV};
/* For some silly reason AX=0x4f01,INT 0x10 doesn't return anything for modes */
/* < 0x14, so I must provide those replies myself */
modeinfo M01={0x0f,7,0,0,0,0xb800,0,0, 80, 40, 25,8,16,1,4,1,_txt,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M03={0x0f,7,0,0,0,0xb800,0,0,160, 80, 25,8,16,1,4,1,_txt,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M05={0x1f,7,0,0,0,0xb800,0,0, 80,320,200,8, 8,1,2,1,_ppg,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M06={0x17,7,0,0,0,0xb800,0,0, 80,640,200,8, 8,1,1,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M07={0x07,7,0,0,0,0xb000,0,0,160, 80, 25,8,16,1,4,1,_txt,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M0d={0x1f,7,0,0,0,0xa000,0,0, 80,320,200,8, 8,4,4,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M0e={0x1f,7,0,0,0,0xa000,0,0,160,640,200,8, 8,4,4,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
//modeinfo M0f={0x17,7,0,0,0,0xa000,0,0, 80,640,350,8,14,2,2,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M0f={0x1f,7,0,0,0,0xa000,0,0, 80,320,200,8, 8,1,2,1,_ppg,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M10={0x1f,7,0,0,0,0xa000,0,0, 80,640,350,8,14,4,4,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M11={0x17,7,0,0,0,0xa000,0,0, 80,640,480,8,16,1,1,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M12={0x1f,7,0,0,0,0xa000,0,0, 80,640,480,8,16,4,4,1,_16c,0,0,1,0,0,0,0,0,0,0,0,0};
modeinfo M13={0x1f,7,0,0,0,0xa000,0,0,320,320,200,8, 8,1,8,1,_ppg,0,0,1,0,0,0,0,0,0,0,0,0};
/*----- set up a matrix of shorts with pointers to its rows */
uns short**newarray2(int X,int Y){
int i;
if(X<=0?:Y<=0) return 0;
X=(X+1)&0xfe;
uns short**c=(uns short**)malloc((X*2+4)*Y+16);
for(i=0;i<Y;i++) c[i]=(uns short*)(c+Y+i*(2*X)/4);
return c;}
/*-----*/
main(){
int i,j,k,w,max=0x13,MD=gp_mode();
int alias[0x1000],aliasch[0x1000],size[256],nsizes,type[256],ntypes;
c_b_array C(256);
modeinfo*MI[0x1000];
char BAR=179,D[128],color;
gp_mode(MD);
/* get information for all the modes up to 0x1ff */
for(i=0;i<0x200;i++) {
    R.ax=0x4f01; R.cx=i; segoff(R.es,R.di,C.addr); Int(0x10);
    dosmemget(C.addr,sizeof(modeinfo),&M);
    if(R.ax&0xff00) M.modeattr=0;
    alias[i]=aliasch[i]=-1;
    if(M.modeattr&1) *(MI[max=i]=new modeinfo)=M; else MI[i]=0;}
/* provide the information for modes 0 to 0x13 */
MI[1]=&M01;
MI[3]=&M03;
MI[7]=&M07;
MI[0x0d]=&M0d;
MI[0x12]=&M12;
MI[0x13]=&M13;
MI[0]=MI[1]=&M01;
MI[2]=MI[3]=&M03;
MI[4]=MI[5]=&M05;
MI[6]=&M06;
MI[7]=&M07;
MI[0x0d]=&M0d;
MI[0x0e]=&M0e;
MI[0x0f]=&M0f;
MI[0x10]=&M10;
MI[0x11]=&M11;
MI[0x12]=&M12;
MI[0x13]=&M13;
/* if(R.ax&0xff00) continue; */
/* if((R.ax&255)==0x4f) function supported */
for(i=0;i<=max;i++) if(MI[i]) if(aliasch[i]==-1)
    for(k=i,j=i+1;j<=max;j++)
     if(MI[j])
       if(!memcmp(MI[i],MI[j],sizeof(modeinfo))) {
         alias[k]=j;
         aliasch[k=j]=i;} /* find and chain identical modes */
for(nsizes=k=0;k<=max;k++) if(MI[k]) if(MI[k]->memmod) {
    modeinfo&M=*MI[k];
    if(!typeOK[M.memmod<?15]) continue;
    w=M.Size();
/* list the sizes */
    for(j=0;j<nsizes;j++) if(size[j]==w) goto X1;
    size[nsizes++]=w;
    X1:;}
for(w=k=nsizes;k>0;k--) while(w) for(w=0,j=1;j<k;j++) if(size[j-1]>size[j]) {
    w=size[j-1]; size[j-1]=size[j]; size[j]=w; w=1;} /* sort the sizes */
for(ntypes=k=0;k<=max;k++) if(MI[k]) if(MI[k]->memmod) {
    modeinfo&M=*MI[k];
    if(!typeOK[M.memmod<?15]) continue;
    w=M.Type();
    /* list the types */
    for(i=0;i<ntypes;i++) if(type[i]==w) goto X2;
    type[ntypes++]=w;
    X2:;}
for(w=k=ntypes;k>0;k--) while(w) for(w=0,i=1;i<k;i++) if(type[i-1]>type[i]) {
    w=type[i-1]; type[i-1]=type[i]; type[i]=w; w=1;} /* sort the types */
uns short**Mode=newarray2(ntypes,nsizes);
for(i=0;i<ntypes;i++) for(j=0;j<nsizes;j++) Mode[j][i]=0;
for(i=0;i<=max;i++) if(MI[i]) MI[i]->res1=1;
/* res1 stays 1 if unclassified */
for(k=0;k<=max;k++) if(MI[k]) {
    modeinfo&M=*MI[k];
    /* classify graphic modes */
    w=M.Type();
    for(i=0;i<ntypes;i++) if(type[i]==w) break;
    w=M.Size();
    for(j=0;j<nsizes;j++) if(size[j]==w) break;
    if(i<ntypes) if(j<nsizes) {Mode[j][i]=k; M.res1=0;}}
PR: gp_mode(MD);
/* list the unclassified (= text and oddsort) modes :- */
printf("This PC has these screen modes. Mode numbers are hexadecimal.\n");
for(i=0;i<=max;i++)
  if(MI[i]) if(!typeOK[w=MI[i]->memmod]) if(aliasch[i]==-1) {
    printf("%s mode %3d*%3d: 0x%03x",MTF[w<?15],MI[i]->wide,MI[i]->high,j=i);
    while((j=alias[j])!=-1) printf(" = 0x%03x",j);
    printf("\n");}
printf("         ");
for(i=0;i<ntypes;i++) switch(type[i]>>16) { /* title */
    case _16c: printf("%c1 bit/",BAR); break;
    case _ppg: printf("%c%2d-bit",BAR,(type[i]>>8)&255); break;
    case _drc: printf("%c%2d-bit",BAR,(type[i]>>8)&255); break;}
printf("\n         ");
for(i=0;i<ntypes;i++) switch(type[i]>>16) {
    case _16c: printf("%cpixl,%1d",BAR,type[i]&255); break;
    case _ppg: printf("%cpalett",BAR); break;
    case _drc: printf("%cdirect",BAR); break;}
printf("\n         ");
for(i=0;i<ntypes;i++) switch(type[i]>>16) {
    case _16c: printf("%cplanes",BAR); break;
    case _ppg: printf("%cnumbrs",BAR); break;
    case _drc: printf("%ccolour",BAR); break;}
printf("\n");
for(j=0;j<nsizes;j++) {
    printf("%4d*%4d",size[j]>>16,size[j]&0xffff); /* table */
    for(i=0;i<ntypes;i++)
      if((w=Mode[j][i])) printf("%c 0x%03x",BAR,w);
      else printf("%c      ",BAR);
    printf("\n");}
do printf("mode to print details of? (hex, without `0x') (ffff=exit)");
while(gets(D),!sscanf(D,"%x",&k)); /* ask for & read a hex number */
if(k==0xffff) goto END;
if(k>max?:!MI[k]) {beep(); goto PR;}
{modeinfo&M=*MI[k];
gp_mode(MD);
printf("SCREEN MODE 0x%03X :-",k);
/* printf(M.modeattr&2?"has the optional information":""); */
printf("\n%s",(color=M.modeattr&8)?"colour":"monochrome");
printf((i=M.modeattr&16)?" graphic":" text");
if(M.memmod) {
    printf("\nmemory type = ");
    if(M.memmod<8) printf(MTF[M.memmod]);
    else printf("unknown (%1d)",M.memmod);}
if(M.memmod) if(M.bitsperpixel) printf("\n%1d bits per pixel",M.bitsperpixel);
if(M.ressize)
  printf("\nbytes %2d to %2d are reserved",M.respos  +M.ressize  -1,M.respos);
if(M.redsize)
  printf("\nbytes %2d to %2d are red"     ,M.redpos  +M.redsize  -1,M.redpos);
if(M.greensize)
  printf("\nbytes %2d to %2d are green"   ,M.greenpos+M.greensize-1,M.greenpos);
if(M.bluesize)
  printf("\nbytes %2d to %2d are blue"    ,M.bluepos +M.bluesize -1,M.bluepos);
if(M.nplanes)
  if(M.memmod==_16c) printf(" with %1d memory planes",M.nplanes);
  else if(M.nplanes!=1) printf("\n%1d memory planes",M.nplanes);
switch(M.memmod) {
case _txt: printf(color?"\n16 colours; can be flashing":
   "\nblack & grey & white; characters can be flashing &/or underlined"); break;
case _16c: printf("\n%1d possible colours",1<<M.nplanes); break;
case _ppg: printf("\nany %1d colours out of 256K",1<<M.bitsperpixel); break;
case _drc: printf("\n%1dK possible colours", 1<<((M.bitsperpixel<?24)-10));
    break;}
if(M.bytesperline) printf("\n%d bytes per line",M.bytesperline);
if(M.wide) {
    printf("\n%1d*%1d %s",M.wide,M.high,i?"pixels":"characters");
    if(i) if(M.cwide)
      printf(" = %1d*%1d characters",M.wide/M.cwide,M.high/M.chigh);
    i=(M.wide*M.high*(M.memmod?M.bitsperpixel:16))/8;
    printf("\na complete screen image would need %1d = %gK bytes",
      i,i/1024.0);}
if(M.cwide) printf("\ncharacters are %1d*%1d pixels",M.cwide,M.chigh);
if(M.wgran) {
    printf("\nwindow granularity = %1dK bytes",M.wgran);
    if(M.wsize)
      printf("\nwindow size = %1dK bytes = %1d granularity units",
        M.wsize,M.wsize/M.wgran);}
if(M.waattr&1) {
    printf("\nwindow A starts at 0x%07x0",(uns short)M.waseg);
    if(M.waattr&2) printf(", is readable");
    if(M.waattr&4) printf(", is writable");}
if(M.wbattr&1) {
    printf("\nwindow B starts at 0x%07x0",(uns short)M.wbseg);
    if(M.wbattr&2) printf(", is readable");
    if(M.wbattr&4) printf(", is writable");}
if(M.dircolor) printf("\ndirect colour info = 0x%02x",M.dircolor);
if(M.nbanks) if(M.nbanks!=1) {
    printf("\n%1d banks",M.nbanks);
    if(M.banksize) printf("\nbank size = 0x%1x",M.banksize);}
if(M.npages) printf("\n%1d image pages",M.npages);
i=aliasch[k];
j=i==-1?k:i;
if(alias[j]>0) {
    printf("\naliases: 0x%03x",j);
    while((j=alias[j])!=-1) printf(" = 0x%03x",j);}
printf("\n");
beep();
get_key()?:get_key();} goto PR;
END: char L[128]; FILE*F;
puts("Name of file for me to list all modes on? (RET by itself = no list)");
L1: gets(L); F=fopen(L,"r");
if(F) {puts("This file already exists."); fclose(F); goto L1;}
F=fopen(L,"w"); if(!F) exit(0);
fprintf(F,"%s",modetitle);
for(i=0;i<=max;i++) if(MI[i]) MI[i]->pr(F,i);
fclose(F);}
