/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Vector and matrix manipulation routines.
 *
 *      See readme.txt for copyright information.
 */

#include <errno.h>
#include <math.h>
#include <stdarg.h>

#include <fastgl.h>

class The3Dview;


typedef struct VTX
{
   float x, y, z;
} VTX;

typedef struct OBJECT3D
{
	VTX *vertex;
	int num_vertex;
	int color;
	OBJECT3D *next;
} OBJECT3D;

#define M_PI                        3.14159265358979323846

void polygon3d_f(The3Dview *bmp, int type, int vc, VTX *vtx[]);
void triangle3d_f(The3Dview *bmp, int type, VTX *v1, VTX *v2, VTX *v3);
void quad3d_f(The3Dview *bmp, int type, VTX *v1, VTX *v2, VTX *v3, VTX *v4);
void wire3d_f(The3Dview *bmp, int x1, int y1, int x2, int y2, int col);

typedef struct MATRIX_f          /* transformation matrix (floating point) */
{
   float v[3][3];                /* scaling and rotation */
   float t[3];                   /* translation */
} MATRIX_f;


extern MATRIX_f identity_matrix_f;


void get_translation_matrix_f(MATRIX_f *m, float x, float y, float z);

void get_scaling_matrix_f(MATRIX_f *m, float x, float y, float z);

void get_x_rotate_matrix_f(MATRIX_f *m, float r);

void get_y_rotate_matrix_f(MATRIX_f *m, float r);

void get_z_rotate_matrix_f(MATRIX_f *m, float r);

void get_rotation_matrix_f(MATRIX_f *m, float x, float y, float z);

void get_align_matrix_f(MATRIX_f *m, float xfront, float yfront, float zfront, float xup, float yup, float zup);

void get_vector_rotation_matrix_f(MATRIX_f *m, float x, float y, float z, float a);

void get_transformation_matrix_f(MATRIX_f *m, float scale, float xrot, float yrot, float zrot, float x, float y, float z);

void get_camera_matrix_f(MATRIX_f *m, float x, float y, float z, float xfront, float yfront, float zfront, float xup, float yup, float zup, float fov, float aspect);

void qtranslate_matrix_f(MATRIX_f *m, float x, float y, float z);

void qscale_matrix_f(MATRIX_f *m, float scale);

void matrix_mul_f(MATRIX_f *m1, MATRIX_f *m2, MATRIX_f *out);

float vector_length_f(float x, float y, float z);

void normalize_vector_f(float *x, float *y, float *z);

void cross_product_f(float x1, float y1, float z1, float x2, float y2, float z2, float *xout, float *yout, float *zout);

float polygon_z_normal_f(VTX *v1, VTX *v2, VTX *v3);

float dot_product_f(float x1, float y1, float z1, float x2, float y2, float z2);
void apply_matrix_f(MATRIX_f *m, float x, float y, float z, float *xout, float *yout, float *zout);

extern float _persp_xscale_f, _persp_yscale_f, _persp_xoffset_f, _persp_yoffset_f;

void set_projection_viewport(int x, int y, int w, int h);

void persp_project_f(float x, float y, float z, float *xout, float *yout);

#define floatcos(x)     cos((x) * M_PI / 128.0)
#define floatsin(x)     sin((x) * M_PI / 128.0)
#define floattan(x)     tan((x) * M_PI / 128.0)

extern MATRIX_f identity_matrix_f;

class The3Dview : public Window
{
		OBJECT3D *world, *end;
	public:
		OBJECT3D * AddToWorld(int num, VTX first[]);
		OBJECT3D * AddToWorld(int num, VTX first, ...);
		void DeleteWorld(void);
		The3Dview(int x, int y, int w, int h);
		~The3Dview() { free(image); DeleteWorld(); }
		void redraw(void) { put_block(GetX(), GetY(), GetW(), GetH(), image); }
		void clear(int c) { memset(image, c, GetH()*GetW()); }
};


