(***************************************************************
 ******     (NC) No Copyright 1997   Bengt Svensson      *******
 ***************************************************************
 ******      The original file is an intro to a gait-    *******
 ******        analysis program which I made in          *******
 ******                       940725                     *******
 ***************************************************************
 *  This code is for those of you who want to code your own 3D *
 *  vector stuff but don't know how. This Pascal sourcecode is *
 *  written in Borland TurboPascal 6.0 (tm).  It's however easy*
 *  to convert to other languages and computer systems.        *
 *-------------------------------------------------------------*
 *  Feel free to modify to your own liking, but don't alter    *
 *  this text, on the contrary, you're encouraged to add       *
 *  text and explain what you've altered/added!                *
 *=============================================================*
 *                                                             *
 *                            Enjoy!                           *
 *                                                             *
 ***************************************************************
 *       Should be compiled with:                              *
 *                        80x87 calls                          *
 *                        286 instructions,                    *
 *                        no stack checking,                   *
 *                        no I/O checking,                     *
 *                        preferably no  debug-information     *
 *                                                             *
 *        This is Borland TurboPascal 6.0 (tm) code            *
 *    Place EGAVGA.BGI in the same directory as the EXE-file   *
 *It's also recommended to place TRIP.CHR in the same directory*
 *=============================================================*
 *                                                             *
 * Please leave this text untouched.  Anyone is however free   *
 * to make changes in the sourcecode, if you decide to do so: 
 * please add some text to this remark and explain what you did*
 *=============================================================*
 *                   3DExampl is Freeware                      *
 ***************************************************************)
PROGRAM vector3D;

uses crt,graph;

VAR a,b,c,zo,azo,bz,a2,b2,c2:double;
    n,nb,nc,m,mb,mc,qw,t,i,j,x1,y1,y2,x2,y3,x3,w,graPHDRIVER,GRAPHMODE:Integer;
    x,y,z:ARRAY[1..60] OF Integer;
    pcoord:ARRAY[1..62] OF Integer;
    qcoord:ARRAY[1..62] OF Integer;
    x3d,y3d:ARRAY[1..60] OF double;

    texten: array[1..40] of string[200];

FUNCTION xpos(x,y,z:Integer):double;
BEGIN
  xpos:=(cos(b)*cos(c)+sin(a)*sin(b)*sin(c))*x+(-sin(c)*cos(b)+sin(a)
  *sin(b)*cos(c))*y+(sin(b)*cos(a))*z;
END;

FUNCTION ypos(x,y,z:Integer):double;
BEGIN
  ypos:=(cos(a)*sin(c))*x+(cos(a)*cos(c))*y-(sin(a))*z;
END;


FUNCTION xpos2(x,y,z:Integer):double;
BEGIN
  xpos2:=(cos(b2)*cos(c2)+sin(a2)*sin(b2)*sin(c2))*x+(-sin(c2)*cos(b2)+sin(a2)
  *sin(b2)*cos(c2))*y+(sin(b2)*cos(a2))*z;
END;

FUNCTION ypos2(x,y,z:Integer):double;
BEGIN
  ypos2:=(cos(a2)*sin(c2))*x+(cos(a2)*cos(c2))*y-(sin(a2))*z;
END;

BEGIN

texten[1]:='    Bimstep 2 is the complete gaitlab system';
texten[2]:=' This improved version of Bimstep is featuring... ';
texten[3]:='           Force display and analysis';
texten[4]:='           Angle analysis and display';
texten[5]:='            EMG display (rms-signal) ';
texten[6]:='   Digital Signal Processing capability, such as...';
texten[7]:='   Digital Filtering and Fast Fourier Transform';
texten[8]:='            (C) Copyright 1993-1994 ';
texten[9]:='           Department of Biomechanics';
texten[10]:='    University college of health sciences, Jkpg';
texten[11]:='               Coding by : BSv';
texten[12]:='           Additional coding by : JSj ';
texten[13]:='  ';
texten[14]:='  ';
texten[15]:='  ';
texten[16]:='  ';
texten[17]:='  ';
texten[18]:='  ';
m:=12;      (*   12 is the last line of text to display *)


(********   BIMSTEP 2 coordinates   ***********)
  x[1]:=-70;y[1]:=10;z[1]:=0;
  x[2]:=-70;y[2]:=45;z[2]:=0;
  x[3]:=-70;y[3]:=70;z[3]:=0;
  x[4]:=-50;y[4]:=70;z[4]:=0;
  x[5]:=-50;y[5]:=47;z[5]:=0;
  x[6]:=-50;y[6]:=42;z[6]:=0;
  x[7]:=-50;y[7]:=10;z[7]:=0;
  x[8]:=-50;y[8]:=10;z[8]:=0;


  x[9]:=-40;y[9]:=50;z[9]:=0;
  x[10]:=-40;y[10]:=10;z[10]:=0;
  x[11]:=-43;y[11]:=50;z[11]:=0;
  x[12]:=-37;y[12]:=50;z[12]:=0;
  x[13]:=-43;y[13]:=10;z[13]:=0;
  x[14]:=-37;y[14]:=10;z[14]:=0;

  x[15]:=-30;y[15]:=10;z[15]:=0;
  x[16]:=-30;y[16]:=50;z[16]:=0;
  x[17]:=-20;y[17]:=30;z[17]:=0;
  x[18]:=-10;y[18]:=50;z[18]:=0;
  x[19]:=-10;y[19]:=10;z[19]:=0;

  x[20]:=0;y[20]:=10;z[20]:=5;
  x[21]:=10;y[21]:=10;z[21]:=5;
  x[22]:=10;y[22]:=30;z[22]:=5;
  x[23]:=0;y[23]:=30;z[23]:=5;
  x[24]:=0;y[24]:=50;z[24]:=5;
  x[25]:=10;y[25]:=50;z[25]:=5;

  x[26]:=30;y[26]:=10;z[26]:=10;
  x[27]:=30;y[27]:=50;z[27]:=10;
  x[28]:=20;y[28]:=50;z[28]:=10;
  x[29]:=40;y[29]:=50;z[29]:=10;

  x[30]:=50;y[30]:=10;z[30]:=15;
  x[31]:=50;y[31]:=30;z[31]:=15;
  x[32]:=50;y[32]:=50;z[32]:=15;
  x[33]:=60;y[33]:=10;z[33]:=15;
  x[34]:=60;y[34]:=30;z[34]:=15;
  x[35]:=60;y[35]:=50;z[35]:=15;

  x[36]:=70;y[36]:=10;z[36]:=20;
  x[37]:=70;y[37]:=50;z[37]:=20;
  x[38]:=80;y[38]:=50;z[38]:=20;
  x[39]:=80;y[39]:=30;z[39]:=20;
  x[40]:=70;y[40]:=30;z[40]:=20;

  x[41]:=110;y[41]:=10;z[41]:=20;
  x[42]:=130;y[42]:=10;z[42]:=20;
  x[43]:=130;y[43]:=35;z[43]:=20;
  x[44]:=110;y[44]:=35;z[44]:=20;
  x[45]:=110;y[45]:=60;z[45]:=20;
  x[46]:=130;y[46]:=60;z[46]:=20;
  nb:=46;

(******  Cube-coordinates  ******)
  x[47]:=-20;y[47]:=20;z[47]:=20;
  x[48]:=20;y[48]:=20;z[48]:=20;
  x[50]:=-20;y[49]:=-20;z[49]:=20;
  x[49]:=20;y[50]:=-20;z[50]:=20;
  x[51]:=-20;y[51]:=20;z[51]:=-20;
  x[52]:=20;y[52]:=20;z[52]:=-20;
  x[54]:=-20;y[53]:=-20;z[53]:=-20;
  x[53]:=20;y[54]:=-20;z[54]:=-20;


(*******  BIMSTEP 2  lines between the respective coordinates  *********)
  pcoord[1]:=1;qcoord[1]:=3;
  pcoord[2]:=3;qcoord[2]:=4;
  pcoord[3]:=4;qcoord[3]:=5;
  pcoord[4]:=5;qcoord[4]:=2;
  pcoord[5]:=2;qcoord[5]:=6;
  pcoord[6]:=6;qcoord[6]:=7;
  pcoord[7]:=7;qcoord[7]:=1;

  pcoord[8]:=9;qcoord[8]:=10;
  pcoord[9]:=11;qcoord[9]:=12;
  pcoord[10]:=13;qcoord[10]:=14;

  pcoord[11]:=15;qcoord[11]:=16;
  pcoord[12]:=16;qcoord[12]:=17;
  pcoord[13]:=17;qcoord[13]:=18;
  pcoord[14]:=18;qcoord[14]:=19;

  pcoord[15]:=20;qcoord[15]:=21;
  pcoord[16]:=21;qcoord[16]:=22;
  pcoord[17]:=22;qcoord[17]:=23;
  pcoord[18]:=23;qcoord[18]:=24;
  pcoord[19]:=24;qcoord[19]:=25;

  pcoord[20]:=26;qcoord[20]:=27;
  pcoord[21]:=28;qcoord[21]:=29;

  pcoord[22]:=30;qcoord[22]:=32;
  pcoord[23]:=32;qcoord[23]:=35;
  pcoord[24]:=31;qcoord[24]:=34;
  pcoord[25]:=30;qcoord[25]:=33;

  pcoord[26]:=36;qcoord[26]:=37;
  pcoord[27]:=37;qcoord[27]:=38;
  pcoord[28]:=38;qcoord[28]:=39;
  pcoord[29]:=39;qcoord[29]:=40;

  pcoord[30]:=42;qcoord[30]:=41;
  pcoord[31]:=41;qcoord[31]:=44;
  pcoord[32]:=43;qcoord[32]:=44;
  pcoord[33]:=43;qcoord[33]:=46;
  pcoord[34]:=46;qcoord[34]:=45;

  nc:=34;

  (**  cube-coordinates  **)
  pcoord[35]:=47;qcoord[35]:=48;
  pcoord[36]:=48;qcoord[36]:=49;
  pcoord[37]:=49;qcoord[37]:=50;
  pcoord[38]:=50;qcoord[38]:=47;
  pcoord[39]:=47;qcoord[39]:=51;
  pcoord[40]:=48;qcoord[40]:=52;
  pcoord[41]:=49;qcoord[41]:=53;
  pcoord[42]:=50;qcoord[42]:=54;
  pcoord[43]:=51;qcoord[43]:=52;
  pcoord[44]:=52;qcoord[44]:=53;
  pcoord[45]:=53;qcoord[45]:=54;
  pcoord[46]:=54;qcoord[46]:=51;


  directvideo:=false;
  azo:=0.4;zo:=0;
  x3:=900;y3:=455;x2:=51;y2:=70;x1:=0;y1:=y2;
  graphdriver:=detect;
  Initgraph(graphdriver,graphmode,'\tp\bgi\');
  settextstyle(defaultfont,horizdir,1);
  setfillstyle(solidfill,1);
  a:=0/180*pi;         (* defines the starting angles  *)
  b:=0/180*pi;
  c:=0/180*pi;
  a2:=0/180*pi;
  b2:=0/180*pi;
  c2:=0/180*pi;
  setviewport(0,0,640,480,clipon);
  setcolor(4);
  repeat
      b2:=b2+2/180*pi;             (* Slowly increase the cube rotations first viewing angle *)
      a2:=a2+2/180*pi;             (* Slowly increase the cube roations second viewing angle *)
      if b2>=2*pi then b2:=0;    (* Reset the cube angles if they're beyond 2*pi  *)
      if a2>=2*pi then a2:=0;    (* Same as above  *)
      if x3>=300 then x3:=x3-4;    (* Slowly move BIMSTEP 2 to the left  until it reaches 300 *)
      if (x3<=300) and (azo<1.7) then azo:=azo+0.020;  (*  Start enlarge BIMSTEP 2 by increasing azo and move it
                                                        slightly upwards *)
      if (azo>=1.3) and (a<=70/180*pi) then a:=a+1/180*pi;  (* when azo reaches 1.3: rotate BIMSTEP 2 *)
      if (azo>=1.4) and (c<=22/180*pi) then c:=c+0.5/180*pi; (* when azo reaches 1.4: rotate BIMSTEP 2 in
                                                                     two dimensions*)
      if (a>=70/180*pi) and (c>=22/180*pi) and (zo>=-1.8) then zo:=zo-0.05;  (* When thru rotating, increase
                                                                                zo, so that BIMSTEP 2 looks
                                                                                like a stair. *)
      if (zo<=-1.8) and (x1<=30) then x1:=x1+1;                 (* Move it to the side a little bit *)
      if (zo<=-1.8) and (y3>=290) and (x2>=30) then y3:=y3-3;  (* Move the modified BIMSTEP 2 up *)

      for t:=1 to nb do
      BEGIN
        x3D[t]:=xpos(x[t],y[t],trunc(zo*z[t]));  (* Recalculate the 3D image to its' X coordinates *)
        y3D[t]:=ypos(x[t],y[t],trunc(zo*z[t]));  (* Recalculate the 3D image to its' Y coordinates *)
      ENd;
      for t:=47 to 54 do
      BEGIN
        x3D[t]:=xpos2(x[t],y[t],z[t]);    (* Do the same for the cubes *)
        y3D[t]:=ypos2(x[t],y[t],z[t]);
      ENd;
      cleardevice;  (* clearscreen *)
      setcolor(4);
      for t:=1 to nc do
          line (x3+trunc(azo*x3d[pcoord[t]]),y3-trunc(azo*y3d[pcoord[t]]),
                x3+trunc(azo*x3d[qcoord[t]]),y3-trunc(azo*y3d[qcoord[t]])); (* Draw BIMSTEP 2 *)
      setcolor(2);
      for t:=35 to 46 do begin  (* Draw the cubes (their movement are in the SIN-formulas) *)
          line (320+trunc(280*sin(a2))+trunc(x3d[pcoord[t]]),400-trunc(50*sin(2*a2))-trunc(y3d[pcoord[t]]),
                320+trunc(280*sin(a2))+trunc(x3d[qcoord[t]]),400-trunc(50*sin(2*a2))-trunc(y3d[qcoord[t]]));
          line (320+trunc(280*sin(-a2))+trunc(x3d[pcoord[t]]),400-trunc(50*sin(-2*a2))-trunc(y3d[pcoord[t]]),
                320+trunc(280*sin(-a2))+trunc(x3d[qcoord[t]]),400-trunc(50*sin(-2*a2))-trunc(y3d[qcoord[t]]));  
        end;
 until (y3<=290) or (keypressed);
  x1:=0;j:=1;i:=70;w:=90;
  setcolor(4);
  (* Now we're gonna rotate the whole enchilada 360 degrees around *)
  repeat
      b2:=b2+2/180*pi;
      a2:=a2+2/180*pi;
      if b2>=2*pi then b2:=0;
      if a2>=2*pi then a2:=0;
      for t:=1 to nb do
      BEGIN
        x3D[t]:=xpos(x[t],y[t],trunc(zo*z[t]));
        y3D[t]:=ypos(x[t],y[t],trunc(zo*z[t]));
      ENd;
      for t:=47 to 54 do
      BEGIN
        x3D[t]:=xpos2(x[t],y[t],z[t]);
        y3D[t]:=ypos2(x[t],y[t],z[t]);
      ENd;
       cleardevice;
     setcolor(4);
     for t:=1 to nc do
          line (x3+trunc(azo*x3d[pcoord[t]]),y3-trunc(azo*y3d[pcoord[t]]),
                x3+trunc(azo*x3d[qcoord[t]]),y3-trunc(azo*y3d[qcoord[t]]));
     setcolor(2);
      if (i<360+65) then
      for t:=35 to 46 do begin  (*  We're still moving the cubes *)
          line (320+trunc(280*sin(a2))+trunc(x3d[pcoord[t]]),400-trunc(50*sin(2*a2))-trunc(y3d[pcoord[t]]),
                320+trunc(280*sin(a2))+trunc(x3d[qcoord[t]]),400-trunc(50*sin(2*a2))-trunc(y3d[qcoord[t]]));
          line (320+trunc(280*sin(-a2))+trunc(x3d[pcoord[t]]),400-trunc(50*sin(-2*a2))-trunc(y3d[pcoord[t]]),
                320+trunc(280*sin(-a2))+trunc(x3d[qcoord[t]]),400-trunc(50*sin(-2*a2))-trunc(y3d[qcoord[t]]));
      end;
    if (i<=360+69) then i:=i+2;
    a:=i/180*pi;
    until((i>=360+69) or (keypressed));
 (*  Finished moving the 3D objects, now to the commercial... *)
    j:=0;y2:=370;settextstyle(TriplexFont,horizdir,1);setusercharsize(5,6,3,2);
    y2:=40;
    if (not (keypressed)) then begin
     setlinestyle(0,1,3);  (* Use a fat line and draw BIMSTEP 2 (no cubes now) *)
     setcolor(4);
     for t:=1 to nc do
          line (x3+trunc(azo*x3d[pcoord[t]]),y3-trunc(azo*y3d[pcoord[t]]),
                x3+trunc(azo*x3d[qcoord[t]]),y3-trunc(azo*y3d[qcoord[t]]));
  setcolor(15);
  repeat
    j:=j+1;
    bar(0,y2,640,y2+textheight(texten[j])+25);
    outtextxy(0,y2,texten[j]);
    a:=0;
    repeat a:=a+0.001; until (a>=140) or (keypressed);  (* 140 can be increased to fit the speed of your machine *)
  until (keypressed) or (j>=m);     end;
  CLOSEGRAPH;
 end.