;File finder for PMS, a rework of the shortest one we found.
;Some comments are for future inclusion in PMS...
;It uses old-fashioned FCB functions, so it is very fast but cannot take a
; subdir - it spits out every matching file on the drive.
;Rumor has it DOS 4.0 could not use FCB calls on hard disks over 32 Megs
; without SHARE.EXE loaded.

cr	EQU	0Dh
lf	EQU	0Ah
esc_	EQU	01Bh

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

FCB	EQU	$+005Ch

	ORG	0100h

Start:	PUSH	AX			;save drive specified on cmd line
	MOV	AH,19h			;get current drive
	INT	21h
	MOV	OrigDriveNo,AL
	POP	AX
	CMP	AL,0FFh			;Who knew DOS does this ??  It works.
	MOV	DX,OFFSET BadDrvMsg	;But, not needed in PMS
	JZ	ToErr2
	MOV	SI,80h			;location of command line params in PSP
	CMP	BYTE PTR [SI],0		;  (use data window in PMS)
	MOV	DX,OFFSET NoFnameMsg
	JNZ	MemSet
ToErr2:	JMP	Err2Exit	;in PMS, beep & keep name box - ex. routine

MemSet:	MOV	BX,150	;DECIMAL para's to allocate, incl PSP, =2400 bytes
	MOV	AH,4Ah			;modify allocated memory block
	INT	21h			;(ES already = CS = block to modify)
	JNC	GetSearchSpec		;in PMS, use EditBufSeg
	MOV	DX,OFFSET NoMem
	JMP	Err2exit

NoMem	db	cr,lf,'Insufficient memory - program aborted',cr,lf,'$'

GetSearchSpec:
	MOV	DI,65h			;the EXT in default FCB in PSP
	MOV	CX,3
	MOV	AL,'?'
	REP	STOSB
;now squeeze out any '\'s or \paths in the command line (leave just optional d:
; and fname.ext) and point SI at the beginning
	MOV	SI,80h
	MOV	CL,BYTE PTR [SI]	;length of command line params
	XOR	CH,CH
	ADD	SI,CX			;point to end of params
	STD				;go BACKWARDS
BkLoop:	CMP	SI,80h
	JZ	FirstValidChar
	LODSB
	CMP	AL,'\'
	JZ	FindStart
	CMP	AL,':'
	JZ	FirstValidChar		;SI now points to byte before the colon
	JMP	SHORT BkLoop

FindStart:
	PUSH	SI			;SI points to the byte before the '\'
StartLoop:
	CMP	SI,80h
	JC	MoveUp
	LODSB
	CMP	AL,':'
	JNZ	StartLoop	
IncAndMoveUp:
	INC	SI
MoveUp:	INC	SI
	MOV	DI,SI			;dest is byte past the ':', or 1st byte
	POP	SI
	INC	SI
	INC	SI			;to point to the byte after the '\'
	CLD				;must go FORWARD to avoid overwriting
MoveLoop:
	LODSB
	CMP	AL,cr			;stop at the cr DOS puts after params
	JZ	FirstValidChar
	STOSB
	JMP	SHORT MoveLoop

FirstValidChar:
	CLD
	MOV	SI,81h
FirstLoop:
	LODSB
	CMP	AL,' '
	JNA	FirstLoop
	DEC	SI			;point to 1st valid character
	MOV	DI,OFFSET FCB	;dest in PSP
	MOV	AH,29h		;parse file name at SI, \paths not allowed
	MOV	AL,00001001b	;no blank .ext, ignore leading separators
	INT	21h		;Filters out path, leaving d:filename.ext
	JC	Exit		;with Errorlevel 9
	MOV	SI,OFFSET FCB
	LODSB
	OR	AL,AL
	JZ	SameDriv
;can we search another drive in PMS ?
	SUB	AL,1
	MOV	DL,AL
	MOV	SearchDriveNo,AL
	MOV	AH,0Eh			;change drive
	INT	21h
	JMP	SHORT DriveSet

SameDriv:
	MOV	AL,OrigDriveNo
	MOV	SearchDriveNo,AL
DriveSet:
	MOV	DI,OFFSET ParsedName
NextByte:
	CMP	SI,65h			;9th byte of FCB, start of the EXT
	JNC	Extension
	LODSB
	CMP	AL,' '
	JZ	NextByte
	STOSB
	JMP	SHORT NextByte

Extension:
	MOV	AL,'.'
	STOSB
NextExtByte:
	CMP	SI,68h
	JNC	MarkNameEnd
	LODSB
	CMP	AL,' '
	JZ	NextExtByte
	STOSB
	JMP	SHORT NextExtByte

MarkNameEnd:
	XOR	AL,AL
	STOSB
	MOV	DI,OFFSET FindString
	CMP	ParsedName+1,0
	JZ	Err0exit
	CLD
	MOV	CX,40h			;64d bytes
	REPNZ	SCASB			;AL is already 0
	MOV	BX,DI
	DEC	BX			;BX points terminator byte in FindString
	MOV	DX,0			;signal start path to display after code
	CALL	FindAndDisplay
Err0exit:
	XOR	AL,AL
ErrExit:MOV	DL,OrigDriveNo
	MOV	AH,0Eh			;select drive
	INT	21h
Exit:	MOV	AH,4Ch			;exit with Errorlevel per AL
	INT	21h

Err2exit:
	Call	ShoMsg
	MOV	AL,2
	JMP	SHORT ErrExit

;
;BX points to terminator byte in FindString, the Find First/Next string
;DX points in buffer after code, the path to display
FindAndDisplay:
	PUSH	SI
	PUSH	DX
	PUSH	SI
	MOV	SI,OFFSET ParsedName
	CALL	MoveToBXtillZero
	POP	SI
	CALL	FindFirst		;find matching files AND dir's,
	JC	HasPath			; string to find is at FindString
	CALL	ShowTheLine		;< These are the only calls -
DirLoop:				;  The line is displayed if there is
	CALL	FindNext		;  no \path\, or after the \path\ is
	JC	HasPath			;  built (this routine has called
	CALL	ShowTheLine		;< BuildPath and it has called this).
	JMP	SHORT DirLoop

HasPath:
	POP	DX
	PUSH	DX
	CALL	MovStarDotStar		;to [BX]
	CALL	FindFirst
	JC	PathExit
	MOV	SI,DX
	TEST	BYTE PTR [SI+15h],10h	;from Func 4Eh, file attrib
	JNZ	IsDir
NotDir:	CALL	FindNext
	JC	PathExit
	TEST	BYTE PTR [SI+15h],10h
	JZ	NotDir
IsDir:	CMP	BYTE PTR [SI+1Eh],'.'	;parent dir indicator
	JZ	NotDir
	CALL	BuildPath		;only call - reentrant
	PUSH	AX
	MOV	AH,1Ah			;set DTA to DX
	INT	21h
	POP	AX
	JMP	SHORT NotDir

PathExit:
	POP	DX
	POP	SI
	RET
;
BuildPath:
	PUSH	DI
	PUSH	SI
	PUSH	AX
	PUSH	BX
	CLD
	MOV	SI,DX
	ADD	SI,1Eh			;point to name found
	MOV	DI,BX
NameLoop:
	LODSB
	STOSB
	OR	AL,AL
	JNZ	NameLoop
	MOV	BX,DI
	STD				;go BACKWARDS
	STOSB				;store another 0
	MOV	AL,'\'
	STOSB				;make the 1st 0 (last byte) a '\'
	CALL	FindAndDisplay		;reentrant
	POP	BX
	MOV	BYTE PTR [BX],0
	POP	AX
	POP	SI
	POP	DI
	RET
;
ShowTheLine:				;in PMS, change xPath & PaintMainScreen
	PUSH	AX
	PUSH	DX
	MOV	DL,SearchDriveNo
	ADD	DL,41h			;make ASCII
	MOV	AH,2			;display char in DL
	INT	21h
	MOV	DL,':'
	INT	21h			;display the colon after drive letter
	MOV	CharCount,3
	MOV	DX,OFFSET FindString	;this is the xPath
	MOV	AL,BYTE PTR [BX]
	MOV	BYTE PTR [BX],0
	CALL	DisplayAndCountBlanks
	MOV	BYTE PTR [BX],AL
	POP	DX
	PUSH	DX
	ADD	DX,1Eh
	CALL	DisplayAndCountBlanks
	MOV	DX,OFFSET DollarSign
	MOV	AL,MaxChars
	CMP	AL,CharCount
	JNA	NextLine
	SUB	AL,CharCount
	XOR	AH,AH
	SUB	DX,AX
	MOV	AH,9			;display string [DX]
	INT	21h
	MOV	AL,MaxChars
	MOV	CharCount,AL
	POP	DX
	PUSH	DX
	CALL	ShowFileData		;only call
NextLine:
	CALL	ShowCrLf
	INC	LineCount
	MOV	AL,LinesOnScrn
	CMP	AL,LineCount
	JNZ	KeepFinding
;reached end of screen, show 'More?' in last line
	MOV	LineCount,0
	MOV	DX,OFFSET MoreStr
	MOV	AH,9
	INT	21h
	MOV	AX,0C07h		;read KBD, obsolete, same as Func 7
	INT	21h
	MOV	AH,AL
	XOR	AL,AL
	CMP	AH,'N'
	JNZ	Chk_n
	JMP	ErrExit

Chk_n:	CMP	AH,'n'
	JNZ	ChkEsc
	JMP	ErrExit

ChkEsc:	CMP	AH,esc_
	JNZ	KeepFinding	;anything but N or n or ESC means continue
	JMP	ErrExit

KeepFinding:
	POP	DX
	POP	AX
	RET
;
MovStarDotStar:
	PUSH	SI
	MOV	SI,OFFSET StarDotStar
	CALL	MoveToBXtillZero
	POP	SI
	RET
;
MoveToBXtillZero:
	PUSH	AX
	PUSH	DI
	MOV	DI,BX
	CLD
H0031B:	LODSB
	STOSB
	OR	AL,AL
	JNZ	H0031B
	POP	DI
	POP	AX
	RET
;
FindFirst:
	PUSH	CX
	OR	DX,DX
	JA	AlreadySet
	MOV	DX,OFFSET DollarSign-42	;DTA to set, starts after code
AlreadySet:				;Find data block is 43d bytes long
	ADD	DX,43			;DECIMAL - points after end of code
	MOV	CX,17h			;for func 4Eh, find dirs and all files
	MOV	AH,1Ah			;set DTA to DS:DX
	INT	21h
	PUSH	DX
	MOV	DX,OFFSET FindString
	MOV	AH,4Eh			;find first file/dir
	INT	21h
	POP	DX
	POP	CX
	RET
;
FindNext:
	PUSH	CX
	PUSH	DX
	MOV	DX,OFFSET FindString
	MOV	CX,17h			;find dir's and any kind of files
	MOV	AH,4Fh			;find next file/dir
	INT	21h
	POP	DX
	POP	CX
	RET
;
ShowCrLf:
	PUSH	AX
	PUSH	DX
	MOV	AH,2			;display char in DL
	MOV	DL,lf
	INT	21h
	MOV	DL,cr
	INT	21h
	POP	DX
	POP	AX
	RET
;
DisplayAndCountBlanks:
	PUSH	AX
	PUSH	DX
	PUSH	SI
	CLD
	MOV	SI,DX
	MOV	AH,2			;display char in DL
	LODSB
DisplayLoop:
	MOV	DL,AL
	INT	21h
	INC	CharCount
	LODSB
	OR	AL,AL
	JNZ	DisplayLoop
	POP	SI
	POP	DX
	POP	AX
	RET
;
ShoMsg:	MOV	AH,9
	INT	21h
	RET
;
ShowFileData:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	DX
	MOV	DX,OFFSET TwoBlanks
	MOV	AH,9
	INT	21h
	POP	DX
	PUSH	DX
	ADD	DX,15h
	MOV	SI,DX
	PUSH	WORD PTR CharCount
	TEST	BYTE PTR [SI],10h	;is the 'dir' bit set ?
	JZ	ShowSize
	MOV	DX,OFFSET DirStr	;only ref
	CALL	DisplayAndCountBlanks
	JMP	SHORT SizeDone

ShowSize:
	POP	AX
	POP	DX
	PUSH	DX
	PUSH	AX
	ADD	DX,1Ah
	MOV	SI,DX
	MOV	DI,WORD PTR 2[SI]	;file size to DI:SI
	MOV	SI,WORD PTR [SI]
	CALL	RegToASCII32bit		;only call
	MOV	DX,OFFSET FileSize
	CALL	DisplayAndCountBlanks
SizeDone:
	POP	WORD PTR CharCount	;was AX
	MOV	DX,OFFSET TwoBlanks
	MOV	AH,9
	INT	21h			;show 2 blanks
	POP	DX
	PUSH	DX
	ADD	DX,18h
	MOV	SI,DX
	MOV	AX,WORD PTR [SI]
	CALL	ShowDate		;only Call
	MOV	AL,MaxChars
	ADD	AL,3
	CMP	AL,CharCount
	JC	Finished
	MOV	DX,OFFSET TwoBlanks
	MOV	AH,9
	INT	21h			;show 2 blanks
	POP	DX
	PUSH	DX
	ADD	DX,16h
	MOV	SI,DX
	MOV	AX,WORD PTR [SI]
	CALL	ShowTime		;only call
Finished:
	POP	DX
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	RET
;
RegToASCII32bit:
	XOR	AX,AX
	MOV	SizeBytePointer,AX
	MOV	BX,AX
	MOV	BP,AX
	MOV	CX,20h			;loop 32d times
BitLoop:
	SHL	SI,1
	RCL	DI,1
	XCHG	AX,BP
	CALL	H004D0
	XCHG	AX,BP
	XCHG	AX,BX
	CALL	H004D0
	XCHG	AX,BX
	ADC	AL,0
	LOOP	BitLoop
;Double re-entrant code:
	MOV	CX,1710h
	MOV	AX,BX
	CALL	H0049A			;just below.  1st time, AX=BX
	MOV	AX,BP			;2nd time, AX=BP
H0049A:	PUSH	AX
	MOV	DL,AH
	CALL	H004A1			;just below.  1st time, DL=AH
	POP	DX			;2nd time, DL=AL
H004A1:	MOV	DH,DL
	SHR	DL,1
	SHR	DL,1
	SHR	DL,1
	SHR	DL,1
	CALL	H004B0			;just below.  1st time, DL=DL
	MOV	DL,DH			;2nd time, DL=DH
H004B0:	AND	DL,00001111b
	JZ	H004B7
	MOV	CL,0
H004B7:	DEC	CH
	AND	CL,CH
	OR	DL,00110000b
	SUB	DL,CL
	PUSH	DI
	MOV	DI,OFFSET FileSize
	ADD	DI,SizeBytePointer
	INC	SizeBytePointer
	MOV	BYTE PTR [DI],DL
	POP	DI
	RET

H004D0:	ADC	AL,AL
	DAA
	XCHG	AL,AH
	ADC	AL,AL
	DAA
	XCHG	AL,AH
	RET
;
ShowDate:
	OR	AX,AX
	JNZ	DateExists
	MOV	DX,OFFSET EightBlanks
	MOV	AH,9
	INT	21h
	RET

DateExists:
	PUSH	AX
	AND	AX,01E0h
	MOV	CL,5
	SHR	AX,CL
	CALL	ShowAXasASCII
	MOV	DL,'-'
	MOV	AH,2			;display char in DL
	INT	21h
	POP	AX
	PUSH	AX
	AND	AX,1Fh
	CALL	ShowAXasASCII
	MOV	DL,'-'
	MOV	AH,2			;display char in DL
	INT	21h
	POP	AX
	AND	AX,0FE00h
	MOV	CL,9
	SHR	AX,CL
	ADD	AX,50h
ShowAXasASCII:
	AAM
	OR	AX,3030h		;convert to ASCII
	PUSH	AX
	MOV	DL,AH
	MOV	AH,2			;display char in DL
	INT	21h
	POP	AX
	MOV	DL,AL
	MOV	AH,2			;display char in DL
	INT	21h
	RET

ShowTime:
	OR	AX,AX
	JNZ	TimeExists
	MOV	DX,OFFSET FiveBlanks
	MOV	AH,9
	INT	21h
	RET

TimeExists:
	PUSH	AX
	AND	AX,0F800h		;11111000 00000000b
	MOV	CL,0Bh
	SHR	AX,CL			;hi 5 bits of AH to AL
	CALL	ShowAXasASCII
	MOV	DL,':'
	MOV	AH,2			;display char in DL
	INT	21h
	POP	AX
	PUSH	AX
	AND	AX,07E0h
	MOV	CL,5
	SHR	AX,CL
	CALL	ShowAXasASCII
	MOV	AL,MaxChars
	CMP	AL,CharCount
	JC	H0056F
	MOV	DL,':'
	MOV	AH,2			;display char in DL
	INT	21h
	POP	AX
	PUSH	AX
	AND	AX,1Fh
	SHL	AX,1
	CALL	ShowAXasASCII
H0056F:	POP	AX
	RET

BadDrvMsg	DB	'Bad drive specified',cr,lf,'$'
NoFnameMsg	DB	'No filename specified',cr,lf,'$'
HeaderLine	DB	31h DUP ('-'),'  --Size--  --Date--  --Time--'
OrigDriveNo	DB	0
SearchDriveNo	DB	0
CharCount	DB	0
LineCount	DB	0
MaxChars	DB	50			;DECIMAL
LinesOnScrn	DB	22			;DECIMAL
MoreStr		DB	' More ?',cr,lf,'$'
StarDotStar	DB	'*.*',0
FindString	DB	'\',51h DUP (0)
ParsedName	DB	13 DUP (0)		;13 DECIMAL bytes NAME.EXT,0
SizeBytePointer	DW	0
FileSize	DB	'        ',0
DirStr		DB	'<DIR>   ',0
		DB	22h DUP (' ')		;ShowFileData uses these
EightBlanks	DB	'   '
FiveBlanks	DB	'   '
TwoBlanks	DB	'  '
DollarSign	DB	'$'

;area following code is multiple DTA buffer for found paths...
;Pgm had 1Fh dup (0), 200h dup (1Ah)

CSEG	ends
	END	Start
