#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>

extern void normal(void);
extern void read(char filename[]);
void run1(void);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);


extern void reicher(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
   gotoxy(15,2);
  cprintf("REICHER MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {

   case '1': run1();break;
   case '2': readdata(".rei");break;
   case '3': read("Reicher.cat");break;
   case '4': read("REIDets.txt");break;
   case '5': read("REIrefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}





 /*RUN1 (): Runs the experiment */
 void run1(void)
 {
  clock_t start, end;
  char *strng;
  float value,temp;
  int dec, sign;
  int ndig = 1;
  int b,correct,finish=1,disqual;
  int cond[300],posit[300];
  int set1, set2, size,count,a,i,sexno, x, y, comp,coord;
  int rnumber, rnum[300],let;
  int RT,rn;
  int WRT1,WRT2,WRT3,WRT4;
  int wcond1,wcond2,wcond3,wcond4;
  int nwcond1,nwcond2,nwcond3,nwcond4;
  int LRT1,LRT2,LRT3,LRT4;
  int lcond1,lcond2,lcond3,lcond4;
  int nlcond1,nlcond2,nlcond3,nlcond4;
  int WMRT1,WMRT2,WMRT3,WMRT4;
  int LMRT1,LMRT2,LMRT3,LMRT4;
  float WPC1,WPC2,WPC3,WPC4;
  float LPC1,LPC2,LPC3,LPC4;
  char init[5], sex,aword[10];
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20],word[300][20];
  char ch_ins, quit, cha, resp,let1,let2;
  char ch, string[80];
  char letter[300], setstr[80];
  FILE *fpword,*fpins,*fpmaster,*fp,*fpset;
  struct find_t ffblk;

  normal();
  if((fpset=fopen("reisys.txt","r"))==NULL) {
   printf("Cannot open reicher system file: reisys.txt file");
   exit(1);
  }
  for(i=0;;i++) {
   ch=fgetc(fpset);
   if(isdigit(ch)) setstr[i]=ch;
   if(ch=='\n') {
    setstr[i]=0;
    set1=atoi(setstr);
    break;
   }
  }
  for(i=0;;i++) {
   ch=fgetc(fpset);
   if(isdigit(ch)) setstr[i]=ch;
   else {
    setstr[i]=0;
    set2=atoi(setstr);
    fclose(fpset);
    break;
   }
  }



  /* record personal data */
   textcolor(WHITE);
   for(;;) {

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');
    sexstr[0]=sex;
    sexstr[1]=0;



    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".REI");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fp=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fp,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fp);
   clrscr();


    /* instructions */

   readinst("reiins.txt");
   textcolor(WHITE);
   clrscr();
   printf("\a");
   delay(1000);
   textcolor(WHITE);

  /* PRACTICE TRIALS*/


   if((fpword=fopen("reiword.txt","r"))==NULL) {
    printf("Cannot open reiword.txt file");
    exit(1);
   }

    /*get words, letters, positions, and conditions and put them to an array*/

    finish=1;
    for(a=0;finish&&a<=400;a=a+2) {
     let=0;
     for(b=0;finish;b++) {
      if(!feof(fpword)) {
       ch=fgetc(fpword);
       if(isalpha(ch)||isspace(ch)) if(!let) word[a][b]=ch;
       if(isdigit(ch)) {
	if(!let) {
	 posit[a]=ch-48;
	 posit[a+1]=ch-48;
	 word[a][b]=0;
	 word[a+1][0]=word[a][posit[a]-1];
	 word[a+1][1]=word[a][4];
	 word[a+1][2]=0;
	 size=a+1;
	 let=1;

	}
	if(let) {
	 cond[a]=ch-48;
	 cond[a+1]=ch-48;
	}
       }

       if(ch=='\n') {
	if(!strlen(word[rnum[a]])) finish=0;
	break;
       }
      }
      else finish=0;
     }
    }

    fclose(fpword);



   if(size+1!=2*(set1+set2)) {
    printf("ERROR: Discrepancy between the actual number of stimuli and the number of \nstimuli in the 'reicher.sys' file was dedtected!\n");
    printf("To solve the problem either change the sys file or the 'reiword.txt' file.\n");
    exit(0);
   }


   /*present Practice trials*/
   _setcursortype(_NOCURSOR);

    /* create random numbers */
   randomize();
   for(a=0;a<2*set1;) {
    comp=0;
    rnumber=random(2*set1);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }


   for(count=0;count<2*set1;count++) {
    correct=0;
    if(strlen(word[rnum[count]])==2){
     for(a=0;a<4;a++) {
      if(posit[rnum[count]]-1==a) aword[a]=word[rnum[count]][0];
      else aword[a]=' ';
     }
     let1=word[rnum[count]][0];
     let2=word[rnum[count]][1];
    }
    else if(strlen(word[rnum[count]])==5) {
     for(a=0;a<4;a++) aword[a]=word[rnum[count]][a];
     let1=word[rnum[count]][posit[rnum[count]]-1];
     let2=word[rnum[count]][4];
    }
    aword[a]=0;

    coord=34+posit[rnum[count]];
    x=20*(cond[rnum[count]]);
     /* present fixation field*/
    gotoxy(34,9);
    cprintf("*      *");
    gotoxy(34,11);
    cprintf("*      *");
    delay(500);
    clrscr();

     /*present a word*/
    gotoxy(35,10);
    printf("%s",aword);
    delay(75);
    clrscr();



    /* present a mask*/
    gotoxy(35,10);
    printf("XXXX");
    delay(x);

    randomize();
    rn=random(100);
      /*present letters*/
    if(rn%2) {
     gotoxy(coord,9);
     putchar(let1);
     gotoxy(coord,11);
     putchar(let2);
     correct=1;
    }
    else {
     gotoxy(coord,9);
     putchar(let2);
     gotoxy(coord,11);
     putchar(let1);
    }

    /* get reaction */

    while(kbhit()) getch();
    do {
     ch=getch();
    } while(tolower(ch)!='q'&&tolower(ch)!='a'&&tolower(ch)!='p'&&tolower(ch)!='l');


    sound(500);
    delay(20);
    nosound();
    clrscr();

    /*sound if wrong*/
    if(correct) {
     if(ch=='a'||ch=='l') {
      sound(50);
      delay(200);
      nosound();
     }
    }
    if(!correct) {
     if(ch=='q'||ch=='p') {
      sound(50);
      delay(200);
      nosound();
     }
    }

    delay(400);
   }




     /* Pause between sessions*/
   gotoxy(1,25);
   cprintf("Press any key to go on to experimental trials...");
   window(1,1,80,24);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   clrscr();
   if((fpins=fopen("reiins2.txt","r"))==NULL) {
    printf("Cannot open 'REIINS2.TXT' file!");
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   window(1,1,80,25);
   textcolor(WHITE);
   textbackground(BLACK);
   clrscr();
   printf("\a");
   delay(1000);




     /* EXPERIMENTAL TRIALS*/


  /* create random numbers */

   randomize();
   for(a=0;a<2*set2;) {
    comp=0;
    rnumber=random(2*set2);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }
   for(a=0;a<2*set2;a++) rnum[a]=rnum[a]+(2*set1);


   /*presentations*/

   wcond1=0;
   wcond2=0;
   wcond3=0;
   wcond4=0;

   nwcond1=0;
   nwcond2=0;
   nwcond3=0;
   nwcond4=0;

   WRT1=0;
   WRT2=0;
   WRT3=0;
   WRT4=0;

   lcond1=0;
   lcond2=0;
   lcond3=0;
   lcond4=0;

   nlcond1=0;
   nlcond2=0;
   nlcond3=0;
   nlcond4=0;

   LRT1=0;
   LRT2=0;
   LRT3=0;
   LRT4=0;


   for(count=0;count<2*set2;count++) {
    correct=0;
    if(strlen(word[rnum[count]])==2){
     for(a=0;a<4;a++) {
      if(posit[rnum[count]]-1==a) aword[a]=word[rnum[count]][0];
      else aword[a]=' ';
     }
     let1=word[rnum[count]][0];
     let2=word[rnum[count]][1];
    }
    else if(strlen(word[rnum[count]])==5) {
     for(a=0;a<4;a++) aword[a]=word[rnum[count]][a];
     let1=word[rnum[count]][posit[rnum[count]]-1];
     let2=word[rnum[count]][4];
    }
    aword[a]=0;
    coord=34+posit[rnum[count]];
    x=20*(cond[rnum[count]]);

     /* present fixation field*/
    gotoxy(34,9);
    cprintf("*      *");
    gotoxy(34,11);
    cprintf("*      *");
    delay(500);
    clrscr();

     /*present a word*/
    gotoxy(35,10);
    printf("%s",aword);
    delay(75);
    clrscr();

     /* present a mask*/
    gotoxy(35,10);
    printf("XXXX");
    delay(x);
    randomize();
    rn=random(100);

    /*present letters*/
    if(rn%2) {
     gotoxy(coord,9);
     putchar(let1);
     gotoxy(coord,11);
     putchar(let2);
     correct=1;
    }
    else {
     gotoxy(coord,9);
     putchar(let2);
     gotoxy(coord,11);
     putchar(let1);
    }
    while(kbhit()) getch();

    start = clock();
    do {
    ch=getch();
    } while(tolower(ch)!='q'&&tolower(ch)!='a'&&tolower(ch)!='p'&&tolower(ch)!='l');
    end = clock();
    RT=(end-start)/CLK_TCK*1000;

    sound(500);
    delay(20);
    nosound();
    clrscr();


    if(correct)
     if(ch=='a'||ch=='l')  RT=0;
    else if(!correct)
     if(ch=='q'||ch=='p')  RT=0;

    if (RT>2000) RT=2000;

    if(RT) {
     if(rnum[count]%2) switch(cond[rnum[count]]) {
      case 1: lcond1++;LRT1=LRT1+RT;break;
      case 2: lcond2++;LRT2=LRT2+RT;break;
      case 3: lcond3++;LRT3=LRT3+RT;break;
      case 4: lcond4++;LRT4=LRT4+RT;break;
     }
     else switch (cond[rnum[count]]) {
      case 1: wcond1++;WRT1=WRT1+RT;break;
      case 2: wcond2++;WRT2=WRT2+RT;break;
      case 3: wcond3++;WRT3=WRT3+RT;break;
      case 4: wcond4++;WRT4=WRT4+RT;break;
     }
    }
    else {
     if(rnum[count]%2) switch(cond[rnum[count]]) {
      case 1: nlcond1++;break;
      case 2: nlcond2++;break;
      case 3: nlcond3++;break;
      case 4: nlcond4++;break;
     }
     else switch (cond[rnum[count]]) {
      case 1: nwcond1++;break;
      case 2: nwcond2++;break;
      case 3: nwcond3++;break;
      case 4: nwcond4++;break;
     }
    }
    /*pause after every 28 trials*/
    if(count>0 && count%28==0) {
     clrscr();
     printf("\a");
     gotoxy(20,10);
     printf("Have a short rest.\n");
     gotoxy(1,25);
     printf("Press any key to continue...");
     getch();
     clrscr();
     printf("\a");
     delay(1000);

    }

   delay(400);
   }



   /*calculate averages for all conditions*/


   if(wcond1) WMRT1=WRT1/wcond1;
   else WMRT1=0;
   if(wcond2) WMRT2=WRT2/wcond2;
   else WMRT2=0;
   if(wcond3) WMRT3=WRT3/wcond3;
   else WMRT3=0;
   if(wcond4) WMRT4=WRT4/wcond4;
   else WMRT4=0;


   if(lcond1) LMRT1=LRT1/lcond1;
   else LMRT1=0;
   if(lcond2) LMRT2=LRT2/lcond2;
   else LMRT2=0;
   if(lcond3) LMRT3=LRT3/lcond3;
   else LMRT3=0;
   if(lcond4) LMRT4=LRT4/lcond4;
   else LMRT4=0;


   if(wcond1) WPC1=100*wcond1/(wcond1+nwcond1);
   else WPC1=0;
   if(wcond2) WPC2=100*wcond2/(wcond2+nwcond2);
   else WPC2=0;
   if(wcond3) WPC3=100*wcond3/(wcond3+nwcond3);
   else WPC3=0;
   if(wcond4) WPC4=100*wcond4/(wcond4+nwcond4);
   else WPC4=0;


   if(lcond1) LPC1=100*lcond1/(lcond1+nlcond1);
   else LPC1=0;
   if(lcond2) LPC2=100*lcond2/(lcond2+nlcond2);
   else LPC2=0;
   if(lcond3) LPC3=100*lcond3/(lcond3+nlcond3);
   else LPC3=0;
   if(lcond4) LPC4=100*lcond4/(lcond4+nlcond4);
   else LPC4=0;

   if((fp=fopen(filetemp,"a"))==NULL) {
    printf("Cannot open '%s' file!",filetemp);
    exit(1);
   }

   fprintf(fp,"\n\t\t Pecentage correct\tMean reaction time (ms.)");
   fprintf(fp,"\n\t\t  Words   Letters\tWords    Letters");
   fprintf(fp,"\n20ms. condition:  %6.2f  %6.2f        %4d     %4d ",WPC1,LPC1,WMRT1,LMRT1);
   fprintf(fp,"\n40ms. condition:  %6.2f  %6.2f        %4d     %4d ",WPC2,LPC2,WMRT2,LMRT2);
   fprintf(fp,"\n60ms. condition:  %6.2f  %6.2f        %4d     %4d ",WPC3,LPC3,WMRT3,LMRT3);
   fprintf(fp,"\n80ms. condition:  %6.2f  %6.2f        %4d     %4d ",WPC4,LPC4,WMRT4,LMRT4);
   fclose(fp);

      /* Update master catalogue */
   if((fpmaster=fopen("reicher.cat","a"))==NULL) {
    printf("Error: Cannot open REICHER.CAT file\n");
    exit(1);
   }
   if (tolower(sex)=='m') sexno=1;
   else if(tolower(sex)=='f') sexno=2;

   fprintf(fpmaster,"%4s %d %6.2f %4d %6.2f %4d %6.2f %4d %6.2f %4d\n", init, sexno, LPC1,LMRT1,LPC2,LMRT2,LPC3,LMRT3,LPC4,LMRT4);
   fprintf(fpmaster,"%6.2f %4d %6.2f %4d %6.2f %4d %6.2f %4d\n", WPC1,WMRT1,WPC2,WMRT2,WPC3,WMRT3,WPC4,WMRT4);
   fclose(fpmaster);

   /* END MESSAGE*/
   clrscr();
   window(9,8,71,17);
   textbackground(LIGHTGRAY);
   clrscr();
   window(10,9,70,16);
   textbackground(GREEN);
   textcolor(BLACK);
   clrscr();
   gotoxy(3,2);
   printf("THIS IS THE END OF THE EXPERIMENT");
   gotoxy(3,3);
   printf("YOUR SCORE IS %6.2f%% CORRECT",(WPC1+WPC2+WPC3+WPC4+LPC1+LPC2+LPC3+LPC4)/8);
   gotoxy(3,5);
   printf("Your complete results were saved in the '%s' file.",filetemp);
   getch();
   return;






 }



