/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1992
 *
 * This file contains the credit screen, main help screen and the help
 * displays for functions where help would be useful.
 */

/*
#include "tdestr.h"
#include "define.h"
*/
#define NULL 0

#if !defined( __UNIX__ )

char *credit_screen[] = {
"Ŀ",
"                                                    ",
"           TDE, the Thomson-Davis Editor            ",
"                                                    ",
"                    Version 5.0                     ",
"                                                    ",
"                    Frank Davis                     ",
"                        and                         ",
"                     Jason Hood                     ",
"                                                    ",
"                  December 5, 1998                  ",
"                                                    ",
"                                                    ",
"      This program is released into the public      ",
"   domain.  You may use and distribute it freely.   ",
"                                                    ",
"",
NULL
};


/*
 * The lines in this help screen need to be exactly 80 characters.
 * There can be any number of lines; the display will stop at the first NULL
 *  line or the bottom of the screen, whichever occurs first.
 */
char *help_screen[] = {
"$  help",
" HELP ͻ",
"Ŀ  Ŀ   Ŀ",
" # = Shift   @ = Alt   ^ = Ctrl    ^\\ for Menu     abort command     ^[ ",
"     ٺ",
" Cursor Movement Ŀ Screen Movement Ŀ",
" next line, first character                  #Enter  pan left       @Left ",
" next line, first column                     ^Enter  pan right     @Right ",
"Ĵ pan up           @Up ",
" word left         ^Left  word end left         @;  pan down       @Down ",
" word right       ^Right  word end right        @' Ĵ",
" full word left   #^Left  full word end left   #@;  scroll up        ^Up ",
" full word right #^Right  full word end right  #@'  center       ^Center ",
"Ĵ scroll down    ^Down ",
" set marker     @1 -  @3  match () [] {} \"      ^]  window left    @PgUp ",
" goto marker   #@1 - #@3  previous position     @~  window right   @PgDn ",
"ٺ",
" Insert / Delete Ŀ Block Ŀ Macro Ŀ",
" insert newline, match indentation    Enter  box      @B  marker    #@M ",
" next tab, add spaces if insert         Tab  line     @L  pause      ^P ",
" previous tab, delete if insert        #Tab  stream   @X ٺ",
" delete, join lines if at eol       ^Delete  unmark   @U Ŀ",
" delete word                             ^T  adjust begin/end    #@[, #@] ",
" delete previous word            ^Backspace  move to begin/end    @[,  @] ",
"ٺ",
"ͼ",
NULL
};


char *regx_help[] = {
"Ŀ",
"   c = char    x = string    r,s = regular expression ",
"Ĵ",
"  c        any non-operator character    Felis      ",
"  \\c       c literally and C escapes     catus\\.    ",
"  \\:c      predefined macro              \\:a+.?\\(   ",
"            a - alphanumeric h - hex.               ",
"            b - white space  l - lower              ",
"            c - alphabetic   u - upper              ",
"            d - decimal                             ",
"  .        any character but newline     c.t        ",
"  <        beginning of word             <cat       ",
"  >        end of word                   <cat>      ",
"  ^        beginning of line             ^cat>      ",
"  $        end of line                   cat$       ",
"  [x]      any character in x            [a-z0-9]   ",
"  [^x]     any character not in x        [^AEIOU]   ",
"  r*       zero or more r's              ca*t       ",
"  r+       one or more r's               ca[b-t]+   ",
"  r?       zero or one r                 c.?t       ",
"  rs       r followed by s               ^$         ",
"  r|s      either r or s                 kitty|cat  ",
"  (r)      r                             (c)?(a+)t  ",
"",
NULL
};


char *stamp_help[] = {
"Ŀ",
"  %d     day of month          ",
"  %D     day of week           ",
"  %e     enter new line        ",
"  %h     hour (12-hour)        ",
"  %H     hour (24-hour)        ",
"  %m     month (number)        ",
"  %M     month (word)          ",
"  %n     minutes               ",
"  %p     am or pm              ",
"  %s     seconds               ",
"  %t     tab                   ",
"  %y     year (two digits)     ",
"  %Y     year (full)           ",
"  %Z     timezone (abbr.)      ",
"  %0?    zero-padded numbers,  ",
"         abbreviated words     ",
"  %2?    blank-padded numbers  ",
"  %%     a percent sign        ",
"",
NULL
};


char *border_help[] = {
"Ŀ",
"  # of chars                    Style characters                 ",
"   in style                        represent                     ",
"Ĵ",
"      0         current graphic set                              ",
"      1         entire border                                    ",
"      2         vertical and horizontal edges                    ",
"      3         corners, vertical and horizontal edges           ",
"      4         left, right, top and bottom edges                ",
"      5         top-left, top-right, bottom-left,                ",
"                  bottom-right corners and the edges             ",
"      6         the four corners, vertical and horizontal edges  ",
"      8         the four corners and the four edges              ",
"",
NULL
};

#else

char *credit_screen[] = {
"+----------------------------------------------------+",
"|                                                    |",
"|           TDE, the Thomson-Davis Editor            |",
"|                                                    |",
"|                    Version 5.0                     |",
"|                                                    |",
"|                    Frank Davis                     |",
"|                        and                         |",
"|                     Jason Hood                     |",
"|                                                    |",
"|                  December 5, 1998                  |",
"|                                                    |",
"|                                                    |",
"|      This program is released into the public      |",
"|   domain.  You may use and distribute it freely.   |",
"|                                                    |",
"+----------------------------------------------------+",
NULL
};


char *help_screen[] = {
"$  help",
"+==================================== HELP ====================================+",
"|+--------------------------------+  +-------------+   +----------------------+|",
"|| # = Shift   @ = Alt   ^ = Ctrl |  | ^\\ for Menu |   | abort command     ^[ ||",
"|+--------------------------------+  +-------------+   +----------------------+|",
"|+------------------ Cursor Movement -----------------++--- Screen Movement --+|",
"|| next line, first character                       - || pan left           - ||",
"|| next line, first column                          - || pan right          - ||",
"|+-------------------------+--------------------------+| pan up             - ||",
"|| word left         #Left | word end left          - || pan down           - ||",
"|| word right       #Right | word end right         - |+----------------------+|",
"|| full word left        - | full word end left     - || scroll up          - ||",
"|| full word right       - | full word end right    - || center             - ||",
"|+-------------------------+--------------------------+| scroll down        - ||",
"|| set marker    ^K! - ^K# | match () [] {} \"      ^] || window left        - ||",
"|| goto marker   ^K1 - ^K3 | previous position      - || window right       - ||",
"|+----------------------------------------------------++----------------------+|",
"|+------------- Insert / Delete --------------++--- Block ---++---- Macro ----+|",
"|| insert newline, match indentation    Enter || box      ^B || marker    ^Km ||",
"|| next tab, add spaces if insert         Tab || line     ^L || pause     ^Kp ||",
"|| previous tab, delete if insert        #Tab || stream   ^X |+---------------+|",
"|| delete, join lines if at eol             - || unmark   ^^ +----------------+|",
"|| delete word                             ^T || adjust begin/end    ^Kb, ^Kk ||",
"|| delete previous word                     - || move to begin/end ^K^B, ^K^K ||",
"|+--------------------------------------------++------------------------------+|",
"+==============================================================================+",
NULL
};


char *regx_help[] = {
"+------------------------------------------------------+",
"|   c = char    x = string    r,s = regular expression |",
"+---------+------------------------------+-------------+",
"|  c      |  any non-operator character  |  Felis      |",
"|  \\c     |  c literally and C escapes   |  catus\\.    |",
"|  \\:c    |  predefined macro            |  \\:a+.?\\(   |",
"|         |   a - alphanumeric h - hex.  |             |",
"|         |   b - white space  l - lower |             |",
"|         |   c - alphabetic   u - upper |             |",
"|         |   d - decimal                |             |",
"|  .      |  any character but newline   |  c.t        |",
"|  <      |  beginning of word           |  <cat       |",
"|  >      |  end of word                 |  <cat>      |",
"|  ^      |  beginning of line           |  ^cat>      |",
"|  $      |  end of line                 |  cat$       |",
"|  [x]    |  any character in x          |  [a-z0-9]   |",
"|  [^x]   |  any character not in x      |  [^AEIOU]   |",
"|  r*     |  zero or more r's            |  ca*t       |",
"|  r+     |  one or more r's             |  ca[b-t]+   |",
"|  r?     |  zero or one r               |  c.?t       |",
"|  rs     |  r followed by s             |  ^$         |",
"|  r|s    |  either r or s               |  kitty|cat  |",
"|  (r)    |  r                           |  (c)?(a+)t  |",
"+---------+------------------------------+-------------+",
NULL
};


char *stamp_help[] = {
"+-------+------------------------+",
"|  %d   |  day of month          |",
"|  %D   |  day of week           |",
"|  %e   |  enter new line        |",
"|  %h   |  hour (12-hour)        |",
"|  %H   |  hour (24-hour)        |",
"|  %m   |  month (number)        |",
"|  %M   |  month (word)          |",
"|  %n   |  minutes               |",
"|  %p   |  am or pm              |",
"|  %s   |  seconds               |",
"|  %t   |  tab                   |",
"|  %y   |  year (two digits)     |",
"|  %Y   |  year (full)           |",
"|  %Z   |  timezone (abbr.)      |",
"|  %0?  |  zero-padded numbers,  |",
"|       |  abbreviated words     |",
"|  %2?  |  blank-padded numbers  |",
"|  %%   |  a percent sign        |",
"+-------+------------------------+"
NULL
};


char *border_help[] = {
"+--------------+---------------------------------------------------+",
"|  # of chars  |                  Style characters                 |",
"|   in style   |                     represent                     |",
"+--------------+---------------------------------------------------+",
"|      1       |  entire border                                    |",
"|      2       |  vertical and horizontal edges                    |",
"|      3       |  corners, vertical and horizontal edges           |",
"|      4       |  left, right, top and bottom edges                |",
"|      5       |  top-left, top-right, bottom-left,                |",
"|              |    bottom-right corners and the edges             |",
"|      6       |  the four corners, vertical and horizontal edges  |",
"|      8       |  the four corners and the four edges              |",
"+--------------+---------------------------------------------------+",
NULL
};

#endif
