/*
 * DPMI justs fails hardware errors, and since some providers (notably CWSDPMI)
 * don't allow int24 to be patched, we'll just make do with djgpp's signals.
 * I don't think it matters too much - the only time I've seen the handler is
 * when I deliberately accessed A: without a disk.
 *
 *
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991, version 1.0
 * Date:             July 29, 1991, version 1.1
 * Date:             October 5, 1991, version 1.2
 * Date:             January 20, 1992, version 1.3
 * Date:             February 17, 1992, version 1.4
 * Date:             April 1, 1992, version 1.5
 * Date:             June 5, 1992, version 2.0
 * Date:             October 31, 1992, version 2.1
 * Date:             April 1, 1993, version 2.2
 * Date:             June 5, 1993, version 3.0
 * Date:             August 29, 1993, version 3.1
 * Date:             November 13, 1993, version 3.2
 * Date:             June 5, 1994, version 4.0
 * Date:             December 5, 1998, version 5.0 (jmh)
 *
 * This code is released into the public domain, Frank Davis.
 *    You may distribute it freely.
 */

#include "tdestr.h"
#include "common.h"
#include "tdefunc.h"
#include "djgpp/criterr.h"
#include <signal.h>


/*
 * Save the area of the screen that will display the Critical
 * Error info.  CEH_WIDTH and CEH_HEIGHT are the dimensions of critical
 * error screen in criterr.h.
 */
#define CEH_ROW          5
#define CEH_COL          8
#define CEH_WIDTH       63
#define CEH_HEIGHT       9
#define CEH_INFO_ROW     8
#define CEH_INFO_COL    22


/*
 * buffer for ceh info screen.
 */
Char ceh_buffer[CEH_HEIGHT][CEH_WIDTH];


/*
 * Name:    crit_err_handler
 * Purpose: Show user something is wrong and get a response
 * Date:    July 21, 1997
 */
void crit_err_handler( int sig )
{
int  c;
char **pp;

   if (sig == SIGINT) {
      g_status.control_break = TRUE;
      return;
   }

   save_area( (Char *)ceh_buffer, CEH_WIDTH, CEH_HEIGHT, CEH_ROW, CEH_COL );
   show_strings( criterr_screen, CEH_HEIGHT, CEH_ROW, CEH_COL );
   switch (sig) {
      case SIGABRT:
         pp = sigabrt;
         break;
      case SIGFPE:
         pp = sigfpe;
         break;
      case SIGILL:
         pp = sigill;
         break;
      case SIGSEGV:
      default:                  /* should never occur */
         pp = sigsegv;
         break;
   }
   show_strings( pp, 3, CEH_INFO_ROW, CEH_INFO_COL );

   xygoto( -1, -1 );
   c = get_response( NULL, 0, 0, 2, L_CONTINUE, OK, L_ABORT, ERROR );
   restore_area( (Char *)ceh_buffer, CEH_WIDTH, CEH_HEIGHT, CEH_ROW, CEH_COL );
   if (c == ERROR) {
      page( 0 );
      exit( 1 );
   } else
      xygoto( 0, g_display.mode_line );
}

void crit_err_handler_end( void ) { }
