#include "syncdir.h"
#include <assert.h>

jmp_buf    jmpbuf;
char       includeList[2048];
char       excludeList[2048];
char       logFileName[MAX_PATH];
FILE      *logFile = 0;
unsigned   granularity = 0;

FILETABLE *source = 0;
FILETABLE *dest = 0;

static UINT32 optionFlags = 0;

void optionSet(UINT32 remove, UINT32 add)
{
  optionFlags = (optionFlags & ~remove) | add;
}

BOOL optionTest(UINT32 flags)
{
  return (optionFlags & flags) == flags;
}

BOOL optionTestOne(UINT32 flags)
{
  return (optionFlags & flags) != 0;
}

const char *actionString(ACTION act)
{
  switch (act)
  {
    case ACTION_NONE:   return "none";
    case ACTION_ADD:    return "add";
    case ACTION_COPY:   return "copy";
    case ACTION_DELETE: return "delete";
    case ACTION_UPDATE: return "update";
    case ACTION_ERROR:  return "error";
    case ACTION_AMBIG:  return "ambig";
    default:
      assert(0);
      return "??";
  }
}


/*
// return values:
//   0: no fatal errors (see log)
//   1: parse error
//   2: error opening log file
//   3: bad source
//   4: bad dest
//      note : if [dest] does not exist, create it!
*/
int syncdir(int argc, char **argv)
{
  int ret;

  memset(includeList, 0, sizeof(includeList));
  memset(excludeList, 0, sizeof(excludeList));
  memset(logFileName, 0, sizeof(logFileName));

  ret = setjmp(jmpbuf);
  if (ret == 0)
  {
    parse(argc, argv);

    if (logFileName[0])
    {
      if (logFileName[0] == '+')
        logFile = fopen(logFileName+1, "a+t");    
      else
        logFile = fopen(logFileName, "w+t");
      if (!logFile)
        longjmp(jmpbuf, SYNCDIR_ERROR_LOGFILE);
    }
    logBegin();
    if (directoryScan(source) && directoryScan(dest))
    {
      process();
      execute();
    }
  }

  logComplete();
  if (logFile)
    fclose(logFile);
  if (dest)
    fileTableFree(dest);
  if (source)
    fileTableFree(source);

  return ret;
}
