/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/

/*
   f1_fun.c 
   help function
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include "fl_ut.h"
#include "f1_fun.h"
#include "refs.h"
#include "l_menu.h"
#include "str_fun.h"
#include "cfg_fun.h"
#include "vtxt.h"

#define HILFSFUNKTION_TITELZEILE "REFERENCES VERSION 3.5 * HELP"

 extern char wrtxtbu[WRTXTBU_LEN];
 extern config_set one_config_set;

 static void f1_text_zeigen(const char * txt);
 static void allgemeinesmenu(void);
 int edit_hilfe_befehl_schreiben(char * dateiname);



int f1_fun_main(void)
{
   static int taste, menupos;

   cls_line(HILFSFUNKTION_TITELZEILE);
   do
   {
       taste = lotus_menu_default(
                     &menupos,
                   "@MainMenuOptions$Short description of main menu options"
                   "@UserInterface$Description of menus, data entry fields, file selection functions"
                   "@DocumentTypes$Description of document types processed by REFERENCES"
                   "@TextDoc$Overview on documentation in accompanying text files"
                   "@SHelpF$Show HELP text file for reading"
                   "@EHelpF$Load HELP text file into the text editor"
                   "@About$Information about REFERENCES, Version 3.5"
                          );
       if (taste==1)
       {
          f1_text_zeigen(F1_HAUPTMENU01);
       }
       else if (taste == 2)
       {
          allgemeinesmenu();
       }
       else if (taste == 3)
       {
         f1_text_zeigen(F1_DOKUMENTENTYPEN);
       }
       else if (taste == 4)
       {
         f1_text_zeigen(F1_DOKUMENTATIONSDATEIEN);
       }

       else if (taste == 5)
       {
         static int dateipos;
         char dname[PFAD_LEN+1];
         char dmaske[PFAD_LEN+1];
         char datei[PFAD_LEN+1];
         strcpy(dname,"");
         strcpy(dmaske,"");
         strcpy(datei,"");


         cls_line("");
         strcpy(dmaske,one_config_set.help_path);
         rtrim(dmaske,'\\');

         strcat(dmaske,"\\");
         /* Verzeichnis ist nicht zu lesen */
         if (isdirectory(dmaske)==0)
         {
             cls_line(HILFSFUNKTION_TITELZEILE);
             sprintf(wrtxtbu,"\n[Cannot read directory '%s' "
                       "please press any key]>",dmaske);
             wrtxt(wrtxtbu);
             tastelesen();
             cls_line(HILFSFUNKTION_TITELZEILE);
             continue;
         }

         strcat(dmaske,"*.*");
         if (datei_suchen_default(dmaske,dname,&dateipos))
         {
            strcpy(datei,one_config_set.help_path);
            rtrim(datei,'\\');
            strlimcat(datei,"\\",PFAD_LEN);
            strlimcat(datei,dname,PFAD_LEN);
            vtxt_main(datei);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
         }
         cls_line(HILFSFUNKTION_TITELZEILE);
       }
       else if (taste == 6)
       {
         static int dateipos;
         char dname[PFAD_LEN+1];
         char dmaske[PFAD_LEN+1];
         char datei[PFAD_LEN+1];
         strcpy(dname,"");
         strcpy(dmaske,"");
         strcpy(datei,"");


         cls_line("");
         strcpy(dmaske,one_config_set.help_path);
         rtrim(dmaske,'\\');

         strcat(dmaske,"\\");
         /* Verzeichnis ist nicht zu lesen */
         if (isdirectory(dmaske)==0)
         {
             cls_line(HILFSFUNKTION_TITELZEILE);
             sprintf(wrtxtbu,"\n[Cannot read directory '%s' "
                       "please press any key]>",dmaske);
             wrtxt(wrtxtbu);
             tastelesen();
             cls_line(HILFSFUNKTION_TITELZEILE);
             continue;
         }

         strcat(dmaske,"*.*");
         if (datei_suchen_default(dmaske,dname,&dateipos))
         {
            strcpy(datei,one_config_set.help_path);
            rtrim(datei,'\\');
            strlimcat(datei,"\\",PFAD_LEN);
            strlimcat(datei,dname,PFAD_LEN);
            /* vtxt_main(datei); */
            edit_hilfe_befehl_schreiben(datei);
         }
         else
         {
           wrtxt("\n[Please press any key]>");
           tastelesen();
         }
         cls_line(HILFSFUNKTION_TITELZEILE);
       }


       else if (taste==7)  /* About */
       {
          f1_text_zeigen(F1_ABOUT);
       }
       else if (taste==0) break;
   } while(1);
   return 0;
}


static void allgemeinesmenu(void)
{
   static int  menupos;
   int taste;
   cls_line("");
   f1_text_zeigen(F1_ALLGEMEINE_ELEMENTE);
   do
   {
      taste = lotus_menu_default(&menupos,
         "@Menus$Description of line menus"
         "@InputLines$Description of text input lines and command reference"
         "@SelectFiles$Description of file selection fields"
         "@TextScreens$Description of text screens"
         "@EditingTextF$How to edit text files (TXT, TBT, ASC, TEX, LOG)"
         "@FileTypes$Description of file types used by REFERENCES: database and optional files"
         "@Colors$Change screen colors"
         );

      if (taste==1) f1_text_zeigen(F1_MEMUS_ALLGEMEIN);
      else if (taste==2) f1_text_zeigen(F1_EINGABEZEILE_ALLGEMEIN);
      else if (taste==3) f1_text_zeigen(F1_DATEIAUSWAHL_ALLGEMEIN);
      else if (taste==4) f1_text_zeigen(F1_TEXTANZEIGE_ALLGEMEIN);
      else if (taste==5) f1_text_zeigen(F1_EDITIEREN_ALLGEMEIN);
      else if (taste==6)
      {
        static int menupos;
        int tastefiles;
        do
        {
          tastefiles = lotus_menu_default(&menupos,
                 "@DatabaseFiles$Files required by each REFERNCES database"
                 "@OptionalFiles$Optional files for interaction with REFERENCES databases"
                  );
          if (tastefiles==1)
            f1_text_zeigen(F1_DATEIEN_OBLIGATORISCH);
          if (tastefiles==2)
            f1_text_zeigen(F1_DATEIEN_FAKULTATIV);
        }
        while (tastefiles>0);
      }
      else if (taste==7) f1_text_zeigen(F1_FARBEN);

   } while (taste !=0);
}


static void f1_text_zeigen(const char * txt)
{
   int i, n_zeilen, taste;
   char zeile[SCREENLINE_LEN + 256];
   cls_line("");
   n_zeilen=countitem(txt,"@");
   taste = 200;
   for (i=1;i<=n_zeilen;i++)
   {
      // if ((i==22) || ((i % 21)==0 && i > 21))
      if ((i==one_config_set.sl-3) ||
         ((i % (one_config_set.sl - 4))==0 &&
           i > (one_config_set.sl - 4)))
      {
        wrtxt("\n");
        taste = lotus_menu(
           "@NextPage$Show the next page or the remaining text"
           "@Cancel$Finish viewing the current text"
                          );
        if (taste==0 || taste==2)
        {
            break;
        }
        sc_gotoxy(1,one_config_set.sl - 2);
      }
      extractitem(i,txt,"@",zeile);
      wrtxt(zeile);
      wrtxt("\n");
   }
   if (taste!=0 && taste !=2) wrtxt("\n");

}


int edit_hilfe_befehl_schreiben(char * dateiname)
{
   FILE * fpcmd;
   /*
     name of text file in help file directory 
   */
   char kommandopfad[PFAD_LEN];

   strcpy(kommandopfad,one_config_set.call_editor_command_file);
   upper(one_config_set.call_editor_command_file);
   if ((fpcmd=fopen(kommandopfad,"wt"))==NULL)
   {
      sprintf(wrtxtbu,"\n[ERROR: Unable to create %s batch file]>",kommandopfad);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fprintf(fpcmd,"%s %s",one_config_set.text_editor,dateiname);
   fflush(fpcmd);
   fclose(fpcmd);
   sprintf(wrtxtbu,"\nPlease call '%s' to view %s\n\n",
            one_config_set.call_editor_command_file,dateiname);
   wrtxt(wrtxtbu);
   wrtxt("[Please press any key]>");
   tastelesen();
   return 1;
}
