/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/
/*
    TXT2TEX: Conversion of references output files into TEX-files
*/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <conio.h>
#include "str_fun.h"
#include "fl_ut.h"
#include "abbruch.h"
#include "cfg_fun.h"
#include "l_menu.h"

#define MAXARR          32000
#define DOSN_LEN        150
#define Z_LEN           1000
#define WW_LEN          75


 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN];

 static char tex_name[DOSN_LEN];
 static char asc_name[DOSN_LEN];

 static char * eingabe;
 static char * ausgabe;

 static FILE * fptex;
 static FILE * fpasc;

 int txt2tex_main(void);
 static int dateien_initialisieren(void);
 static void bearbeiten(void);

int txt2tex_main(void)
{
   if ((eingabe=(char*) malloc((MAXARR+1)*sizeof(char)))==NULL)
      beenden("ERROR: memory allocation 1 failed",1);
   if ((ausgabe=(char*) malloc((MAXARR+1)*sizeof(char)))==NULL)
      beenden("ERROR: memory allocation 2 failed",1);

   strcpy(eingabe,"");
   strcpy(ausgabe,"");
   strcpy(asc_name,"");
   strcpy(tex_name,"");

   if (dateien_initialisieren())
   {
      bearbeiten();
      fclose(fpasc);
      fclose(fptex);
   }
   free(ausgabe);
   free(eingabe);
   return 0;
}


static int dateien_initialisieren(void)
{
   if (!datei_suchen("*.TXT",asc_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      wrtxt(" Ok...");
      return 0;
   }
   extractitem(1,asc_name,".",tex_name);
   strcat(tex_name,".TEX");
   if ((fpasc=fopen(asc_name,"r"))==NULL)
      beenden("ERROR: cannot read *.TXT file",1);
   if ((fptex=fopen(tex_name,"w"))==NULL)
      beenden("ERROR: cannot create *.TEX file",1);
   return 1;
}

static void bearbeiten(void)
{
   unsigned int i, n;
   long j;

   char zeile[Z_LEN];
   strcpy(zeile,"");

   j=0;
   wrtxt("\nAnalyzing input TXT file...\n");
   while(fgets(eingabe,MAXARR,fpasc)!=NULL)
   {
      j++;
      /* if (strlen(eingabe)>=20-1) */
      if (strlen(eingabe)>=MAXARR-1)
      {
         sprintf(wrtxtbu,"\n** %s",eingabe);
         wrtxt(wrtxtbu);
         sprintf(wrtxtbu,"\nProblem in line %li: Line too long, "
              "file cannot be processed",j);
         wrtxt(wrtxtbu);
         wrtxt("\n\n[Please press any key]>");
         tastelesen();
         wrtxt(" Ok...");
         // printf("\n");
         return;
      }
   }
   rewind(fpasc);
   wrtxt("Writing TEX file...\n");
   fputs("\n%\n% File generated using REFERENCES 3.5 for DOS, "
          "(c) 1995-2000 V. Kiefel\n",fptex);
   fputs("%\n\n",fptex);
   while(fgets(eingabe,MAXARR,fpasc)!=NULL)
   {
      n = strlen(eingabe) -1;
      if (n > 0)
      {
         strcpy(ausgabe,"");
         for (i=0;i<=n;i++)
         {
           if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"a",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"A",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"o",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"O",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"u",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"U",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ss}",MAXARR);
           else if (eingabe[i]=='[')
              strlimcat(ausgabe,"$[$",MAXARR);
           else if (eingabe[i]==']')
              strlimcat(ausgabe,"$]$",MAXARR);
           else if (eingabe[i]=='<')
              strlimcat(ausgabe,"$<$",MAXARR);
           else if (eingabe[i]=='#')
              strlimcat(ausgabe,"\\#",MAXARR);
           else if (eingabe[i]=='$')
              strlimcat(ausgabe,"\\$",MAXARR);
           else if (eingabe[i]=='&')
              strlimcat(ausgabe,"\\&",MAXARR);
           else if (eingabe[i]=='%')
              strlimcat(ausgabe,"\\%",MAXARR);
           else if (eingabe[i]=='_')
              strlimcat(ausgabe,"\\_",MAXARR);
           else if (eingabe[i]=='\"')
              strlimcat(ausgabe,"'",MAXARR);
           else if (eingabe[i]=='^' || eingabe[i]=='~')
              strlimcat(ausgabe,"",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\c{c}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\c{C}",MAXARR);

           else if (eingabe[i]=='^' || eingabe[i]=='~')
              strlimcat(ausgabe,"",MAXARR);

           /*franzoesiche Akzente*/

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{e}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{e}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{e}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\\"{e}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{E}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{a}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{a}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{a}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{o}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{o}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{o}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{u}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{u}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{u}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{i}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{i}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{i}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\\"{i}",MAXARR);

           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\\"{y}",MAXARR);

           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{AE}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{ae}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{AA}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{aa}",MAXARR);
           /*
           else if (eingabe[i]=='\\')
              strlimcat(ausgabe,"$\\backslash$",MAXARR);
           */
           else if (eingabe[i]=='\"')
              strlimcat(ausgabe,"'",MAXARR);
           
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ensuremath{^\\circ}}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ensuremath{\\mu}}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ensuremath{\\alpha}}",MAXARR);

           else if (eingabe[i]=='>')
               strlimcat(ausgabe,"$>$",MAXARR);
           else
           {
              /*  Hier wird ein 'String' erzeugt */
              zeile[0]=eingabe[i];
              zeile[1]='\0';
              strlimcat(ausgabe,zeile,MAXARR);
           }
         }
         wwrap(ausgabe,WW_LEN);
         fprintf(fptex,"%s",ausgabe);
      }
      else fprintf(fptex,"\n");
   }
   sprintf(wrtxtbu,"\nSuccess: List of REFERENCES for LATEX written into %s",tex_name);
   wrtxt(wrtxtbu);
   wrtxt("\n\n[Please press any key]>");
   tastelesen();
   wrtxt(" Ok...");
}
