/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   rfd_fun.c: create/edit format definitions
*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "l_menu.h"
#include "str_fun.h"
#include "keycodes.h"
#include "fd.h"
#include "refs.h"
#include "rfd_fun.h"
#include "rfd1_fun.h"
#include "fl_ut.h"
#include "sortfd.h"
#include "abbruch.h"
#include "cfg_fun.h"

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

#define HAUPTMENUTEXT "Modify$Read an existing format definition from 'FORMDEF.DAT', modify/edit, save\
@New$Enter a new, empty format definition\
@Copy$Make a copy of an existing format definition\
@Export$Export a format definition into a FD3 file\
@Import$Import a format definition from a FD3 file\
@Delete$Delete a format definition\
@Sort$Sort format definitions\
@FdToText$Write REFERENCES format definition to text file FORMDEF.TXT (append)\
@TextToFd$Read format definition text file FORMDEF.TXT and import all format definitions"


 char RFD_HILFE00[] = "\nHELP 01 REFERENCES FORMAT DEFINITION: sequence of strings\n\n"
 " - On the next pages you will define a FORMAT DEFINITION. Lists of 'keywords'\n"
 "   for FORMAT DEFINITIONS are provided.\n"
 " \n"
 " - Format definitions usually consist of 3 (document types j1, b1) or 5 (b2)\n"
 "   strings or lines. Their sequence can be determined on the next screen.\n"
 " \n"
 " - Keywords for the next screen are:\n"
 "\n"
 "       %au   authors (j1, b2)\n"
 "       %ti   title of an article in a journal or a book (j1, b2)\n"
 "       %lo   localization (j1, b1, b2)\n"
 "       %ed   editors of a book or authors of a book (b1, b2)\n"
 "       %bo   title of a book (b1, b2)\n"
 "\n"
 " - Keywords always begin with the '%' sign. Their function depends upon the\n"
 "   context, in this screen they indicate in which order the major elements\n"
 "   of a reference are arranged.\n"
 " \n"
 "  Ŀ\n"
 "       [PgDn], [PgUp]: next, previous page, [F10] or [ESC] finish/save     \n"
 "  ";


 char RFD_HILFE01[] = "\nHELP 02 REFERENCES FORMAT DEFINITION: authors'/editors' strings, titles:\n"
 "keywords applicable to document types J1, B1, B2\n\n"
 "  J1 authors   : %auth, %endline, %fullstop, %refnr, %n, %space, %year;\n\n"
 "  B1 editors   : %edits, %ededs, %Ededs, %endline, %fullstop, %refnr, %n,\n"
 "                 %space, %year;\n\n"
 "  B2 authors   : %auth, %endline, %fullstop, %refnr, %n, %space, %year;\n\n"
 "  B2 editors   : %edits, %ededs, %Ededs, %endline, %fullstop, %refnr, %n,\n"
 "                 %space, %year;\n\n"
 "  J1, B2 title : %endline, %fullstop, %refnr, %n, %title, %year, %space;\n\n"
 "  B1, B2 book  : %Auflage, %e, %edno, %edition, %Edition, %endline,\n"
 "                 %fullstop, %refnr, %n, %space, %titlebo, %year. \n";

 char  RFD_HILFE02[] = "\nHELP 03 REFERENCES FORMAT DEFINITION: localization strings: keywords\n"
 "applicable to document types J1, B1, B2\n\n"
 "  J1: %day, %d(), %endline, %fullstop, %inu(), %isn(), %issn, %issuenum, \n"
 "      %journ4l, %journ, %journsh, %js(), %kwds, %m(), %month, %pagefrom, \n"
 "      %pageto, %pagetosh, %pgs(), %space, %status, %volume, %v(), %year;\n"
 " \n"
 "  B1: %Auflage, %e(), %edition, %Edition, %edno, %endline, %fullstop, %ibn(),\n"
 "      %isbn, %kwds, %p(), %pagefrom, %pageto, %pagetosh, %place, %places, \n"
 "      %publisher, %space, %status, %year;\n"
 " \n"
 "  B2: %Auflage, %e(), %edition, %Edition, %edno, %endline, %fullstop, \n"
 "      %ibn(), %isbn, %kwds, %pagefrom, %pagetosh, %pgs(), %place, %places, \n"
 "      %publisher, %space, %status, %year.";



#define ABBRUCH1  if (taste==ENTER_KEY || taste==DOWN_KEY \
                   || taste == TAB_KEY || taste==0) { posit++; break; }\
                  if (taste==SHIFTTAB_KEY || taste==UP_KEY) { posit--; break; };\
                  if (taste == PGUP_KEY || taste == PGDN_KEY) break;\
                  if (taste==0 ||  taste==ESC_KEY || taste==F10_KEY) break;\
                  if (taste==CTRLHOME_KEY || taste == CTRLEND_KEY) break

 extern char formdef_name[150];
 static char formdef_temp_name[150];

 extern FILE * fpformdef;
 static FILE * fpformdeftemp;
 static long formdef_datensatz;
 extern config_set one_config_set;
 static formdef_rec fd;


 int rfd_fun_main(char * datpath);
 static int hilfe00(void);
 static int hilfe01(void);
 static int hilfe02(void);
// static int hilfe03(void);
// static int hilfe04(void);
 static void menu_rfd_main(void);
 static void steuerung(void);
 static int formular01(void);
 static int formular02(void);
 static int formular03(void);
 static int formular04(void);
 static int formular05(void);
 static int formular06(void);
 static long datensatz_lesen(void);
 static void rewrite_record(void);
 static void rec_loeschen(void);
 static void exportieren(void);
 static void importieren(void);


int rfd_fun_main(char * datpath)
{
  strcpy(formdef_name,datpath);
  strcat(formdef_name,"FORMDEF.DAT");
  strcpy(formdef_temp_name,datpath);
  strcat(formdef_temp_name,"FORMDEF.$AT");
  if (!isfile(formdef_name))
  {
     cls_line("");
     wrtxt("File with format definitions does not exist, please run "
                "the sequence of\n"
           "commands: \n\n"
           "     \"FileSystem\" \"RebuildDbase\" \"CreateFiles\"\n\n"
           "which creates all missing files in a REFERENCES database."
           "\n\n[Please press any key]>");
     tastelesen();
     return 1;
  }
  menu_rfd_main();
  cls_line("");
  return 0;
}


static void menu_rfd_main()
{
   int taste;
   static int menupos;
   cls_line(RFD_TITELZEILE);
   taste = lotus_menu_default(&menupos,HAUPTMENUTEXT);
   if (taste==1)
   {
        if (filesize(formdef_name) < sizeof(formdef_rec))
        {
           cls_line("");
           wrtxt("No format definition in database, please create a record "
                 "with \"New\" or \n"
                 "import a format definition from a FD3 file with the "
                 "\"Import\" command.\n\n"
                 "[Please press any key]>");
                 tastelesen();
           return;
        }
        if(datensatz_lesen() > -1)
        { int taste;
          steuerung();
          cls_line(RFD_TITELZEILE);
          taste = lotus_menu(
                   "Cancel$Do not save the changes made"
                   "@Save$Save the current format definition"
                    );
          if (taste==2)
          {
             rewrite_record();
             wrtxt("\n[Record saved, please press any key]>");
             tastelesen();
          }
        }
   }
   else if (taste==2)
   {
      int taste;
      memset(&fd,0,sizeof(fd));
      steuerung();
      cls_line(RFD_TITELZEILE);
      taste = lotus_menu(
               "Cancel$Do not save the changes made"
               "@Save$Save the current format definition"
                );
      if (taste==2)
      {
         if ((fpformdef=fopen(formdef_name,"r+b"))==NULL)
         {
            sprintf(fehlermeldung,"ERROR: File %s does not exist",
                formdef_name);
            beenden(fehlermeldung,2);
         }
         fseek(fpformdef,0L,SEEK_END);
         fwrite(&fd,sizeof(fd),1,fpformdef);
         fclose(fpformdef);
         wrtxt("\n[Record saved, please press any key]>");
         tastelesen();
      }
   }
   else if (taste==3)
   {
       if (datensatz_lesen() > -1)
       {
            if ((fpformdef=fopen(formdef_name,"r+b"))==NULL)
            {
               sprintf(fehlermeldung,"ERROR: File %s does not exist",
                  formdef_name);
               beenden(fehlermeldung,2);
            }
            cls_line(RFD_TITELZEILE);
            fseek(fpformdef,0L,SEEK_END);
            fwrite(&fd,sizeof(fd),1,fpformdef);
            fclose(fpformdef);
            wrtxt("\n[Record copied to the end "
                  "of the table, please press any key]>");
            tastelesen();
       }
   }
   else if (taste==4)
   {
      exportieren();
   }
   else if (taste==5)
   {
      importieren();
   }
   else if (taste==6)
   {
      rec_loeschen();
   }
   else if (taste==7)
   {
      int taste;
      taste =
        lotus_menu("@Cancel$Do *not* sort format definitions"
                   "@Sort$Sort file with format definitions");
      if (taste==2)
      {
        if (filesize(formdef_name) > sizeof(formdef_rec))
        {
          if (isfile(formdef_temp_name)) remove (formdef_temp_name);
          domergefd(formdef_name,formdef_temp_name);
          remove(formdef_name);
          rename(formdef_temp_name,formdef_name);
          wrtxt("\n[Please press any key]>");
          tastelesen();
        }
      }
   }
   else if (taste==8)
   {
        if(datensatz_lesen() > -1)
        {
          fd_in_textdatei(fd,FORMDEF_TXT);
        }
   }
   else if (taste==9)
   {
        textdatei_in_fd(formdef_name,FORMDEF_TXT);
   }
}



static void steuerung()
{
  int seiten_zeiger;
  int MAXSEITEN;
  int richtung;
  richtung = 0;

  seiten_zeiger = 1;
  MAXSEITEN = 9;
  do
  {
      if (seiten_zeiger == 1)
      {
           richtung = hilfe00();
      }

      if (seiten_zeiger == 2)
      {
           richtung = formular01();
      }
      if (seiten_zeiger == 3)
      {
           richtung = hilfe01();
      }
/*
      if (seiten_zeiger == 4)
      {
           richtung = hilfe02();
      }
*/
      if (seiten_zeiger == 4)
      {
           richtung = formular02();
      }
      if (seiten_zeiger == 5)
      {
           richtung = hilfe02();
      }
/*
      if (seiten_zeiger == 7)
      {
           richtung = hilfe04();
      }
*/
      if (seiten_zeiger == 6)
      {
           richtung = formular03();
      }
      if (seiten_zeiger == 7)
      {
           richtung = formular04();
      }
      if (seiten_zeiger == 8)
      {
           richtung = formular05();
      }

      if (seiten_zeiger == 9)
      {
           richtung = formular06();
      }
      if (!richtung) return;
       seiten_zeiger = seiten_zeiger + richtung;
       if (seiten_zeiger <1) seiten_zeiger  =1;
       if (seiten_zeiger > MAXSEITEN) seiten_zeiger = MAXSEITEN;

  } while(1);
}



static int hilfe00(void)
{
     int taste;
     do
     {
          sc_clrscr();
          wrtxt(RFD_HILFE00);
          sc_gotoxy(1,2);
          taste=tastelesen();
     } while (taste!=PGUP_KEY && taste!=PGDN_KEY && taste!=F10_KEY && taste !=ESC_KEY);
     if (taste==PGUP_KEY)
         return -1;
     else if (taste==PGDN_KEY) return 1;
     else return 0;
}

static int hilfe01(void)
{
     int taste;
     do
     {
          sc_clrscr();
          wrtxt(RFD_HILFE01);
          sc_gotoxy(1,2);
          taste=tastelesen();
     } while (taste!=PGUP_KEY && taste!=PGDN_KEY && taste!=F10_KEY && taste !=ESC_KEY);
     if (taste==PGUP_KEY)
         return -1;
     else if (taste==PGDN_KEY) return 1;
     else return 0;
}


static int hilfe02(void)
{
     int taste;
     do
     {
          sc_clrscr();
          wrtxt(RFD_HILFE02);
          sc_gotoxy(1,2);
          taste=tastelesen();
     } while (taste!=PGUP_KEY && taste!=PGDN_KEY && taste!=F10_KEY && taste !=ESC_KEY);
     if (taste==PGUP_KEY)
         return -1;
     else if (taste==PGDN_KEY) return 1;
     else return 0;
}


static int formular01(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS =13;
   sc_gotoxy(1,2);
   wrtxt("[01] * Name, code and sequence of strings of the current format "
         "definition");
   posit = 1;
   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(1,4);
             strcpy(wrtxtbu,"   Code for format description..");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),4,fd.formkennung,FORMKENNUNG_LEN,FORMKENNUNG_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==2)
     {
        do
        {
             sc_gotoxy(1,5);
             strcpy(wrtxtbu,"   Name of format description...");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),5,fd.formatbeschreibung,FORMATBESCHREIBUNG_LEN-20,FORMATBESCHREIBUNG_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==3)
     {
        do
        {
             sc_gotoxy(1,7);
             wrtxt("   - Sequence of elements for formats j1 (Article in a journal)\n");
             strcpy(wrtxtbu,"     %au (authors), %ti (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),8,fd.fdj1_str1,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==4)
     {
        do
        {
             sc_gotoxy(1,9);
             strcpy(wrtxtbu,"     %au (authors), %ti (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),9,fd.fdj1_str2,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==5)
     {
        do
        {
             sc_gotoxy(1,10);
             strcpy(wrtxtbu,"     %au (authors), %ti (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),10,fd.fdj1_str3,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }




     if (posit==6)
     {
        do
        {
             sc_gotoxy(1,12);
             wrtxt("   - Sequence of elements for formats b1 (book)\n");
             strcpy(wrtxtbu,"     %ed (editors), %bo (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),13,fd.fdb1_str1,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==7)
     {
        do
        {
             sc_gotoxy(1,14);
             strcpy(wrtxtbu,"     %ed (authors), %bo (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),14,fd.fdb1_str2,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==8)
     {
        do
        {
             sc_gotoxy(1,15);
             strcpy(wrtxtbu,"     %ed (authors), %bo (title) or %lo (localization)..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),15,fd.fdb1_str3,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }


     if (posit==9)
     {
        do
        {
             sc_gotoxy(1,17);
             wrtxt("   - Sequence of elements for formats b2 (chapter/article in a book)\n");
             strcpy(wrtxtbu,"     %au, %ed, %ti, %bo, or %lo................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),18,fd.fdb2_str1,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==10)
     {
        do
        {
             sc_gotoxy(1,19);
             strcpy(wrtxtbu,"     %au, %ed, %ti, %bo, or %lo................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),19,fd.fdb2_str2,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==11)
     {
        do
        {
             sc_gotoxy(1,20);
             strcpy(wrtxtbu,"     %au, %ed, %ti, %bo, or %lo................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),20,fd.fdb2_str3,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==12)
     {
        do
        {
             sc_gotoxy(1,21);
             strcpy(wrtxtbu,"     %au, %ed, %ti, %bo, or %lo................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),21,fd.fdb2_str4,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==13)
     {
        do
        {
             sc_gotoxy(1,22);
             strcpy(wrtxtbu,"     %au, %ed, %ti, %bo, or %lo................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),22,fd.fdb2_str5,TYP_STRING_LEN,TYP_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }



     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;
     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;

   } while(1);

}


static int formular02(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS = 68;
   sc_gotoxy(1,2);
   wrtxt("[02] * Authors' and editors' strings, title strings");
   posit = 1;
   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(3,4);
             wrtxt("(J1) Authors");
             // sc_gotoxy(3,5);
             taste=e_zle (3,5,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==2)
     {
        do
        {
             // sc_gotoxy(3,6);
             taste=e_zle (3,6,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==3)
     {
        do
        {
             // sc_gotoxy(3,7);
             taste=e_zle (3,7,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==4)
     {
        do
        {
             // sc_gotoxy(3,8);
             taste=e_zle (3,8,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==5)
     {
        do
        {
             // sc_gotoxy(3,9);
             taste=e_zle (3,9,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==6)
     {
        do
        {
             // sc_gotoxy(3,10);
             taste=e_zle (3,10,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==7)
     {
        do
        {
             // sc_gotoxy(3,11);
             taste=e_zle (3,11,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==8)
     {
        do
        {
             // sc_gotoxy(3,12);
             taste=e_zle (3,12,fd.j1_aut[posit-1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==9)
     {
        do
        {
             sc_gotoxy(23,4);
             wrtxt("(B1) Editors");
             // sc_gotoxy(23,5);
             taste=e_zle (23,5,fd.b1_ed[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==10)
     {
        do
        {
             // sc_gotoxy(23,6);
             taste=e_zle (23,6,fd.b1_ed[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==11)
     {
        do
        {
             // sc_gotoxy(23,7);
             taste=e_zle (23,7,fd.b1_ed[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==12)
     {
        do
        {
             // sc_gotoxy(23,8);
             taste=e_zle (23,8,fd.b1_ed[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==13)
     {
        do
        {
             // sc_gotoxy(23,9);
             taste=e_zle (23,9,fd.b1_ed[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==14)
     {
        do
        {
             // sc_gotoxy(23,10);
             taste=e_zle (23,10,fd.b1_ed[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==15)
     {
        do
        {
             // sc_gotoxy(23,11);
             taste=e_zle (23,11,fd.b1_ed[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==16)
     {
        do
        {
             // sc_gotoxy(23,12);
             taste=e_zle (23,12,fd.b1_ed[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==17)
     {
        do
        {
             sc_gotoxy(43,4);
             wrtxt("(B2) Authors");
             // sc_gotoxy(43,5);
             taste=e_zle (43,5,fd.b2_aut[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==18)
     {
        do
        {
             // sc_gotoxy(43,6);
             taste=e_zle (43,6,fd.b2_aut[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==19)
     {
        do
        {
             // sc_gotoxy(43,7);
             taste=e_zle (43,7,fd.b2_aut[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==20)
     {
        do
        {
             // sc_gotoxy(43,8);
             taste=e_zle (43,8,fd.b2_aut[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==21)
     {
        do
        {
             // sc_gotoxy(43,9);
             taste=e_zle (43,9,fd.b2_aut[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==22)
     {
        do
        {
             // sc_gotoxy(43,10);
             taste=e_zle (43,10,fd.b2_aut[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==23)
     {
        do
        {
             // sc_gotoxy(43,11);
             taste=e_zle (43,11,fd.b2_aut[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==24)
     {
        do
        {
             // sc_gotoxy(43,12);
             taste=e_zle (43,12,fd.b2_aut[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==25)
     {
        do
        {
             sc_gotoxy(63,4);
             wrtxt("(B2) Editors");
             // sc_gotoxy(63,5);
             taste=e_zle (63,5,fd.b2_ed[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==26)
     {
        do
        {
             // sc_gotoxy(63,6);
             taste=e_zle (63,6,fd.b2_ed[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==27)
     {
        do
        {
             // sc_gotoxy(63,7);
             taste=e_zle (63,7,fd.b2_ed[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==28)
     {
        do
        {
             // sc_gotoxy(63,8);
             taste=e_zle (63,8,fd.b2_ed[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==29)
     {
        do
        {
             // sc_gotoxy(63,9);
             taste=e_zle (63,9,fd.b2_ed[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==30)
     {
        do
        {
             // sc_gotoxy(63,10);
             taste=e_zle (63,10,fd.b2_ed[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==31)
     {
        do
        {
             // sc_gotoxy(63,11);
             taste=e_zle (63,11,fd.b2_ed[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==32)
     {
        do
        {
             // sc_gotoxy(63,12);
             taste=e_zle (63,12,fd.b2_ed[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==33)
     {
        do
        {
             sc_gotoxy(3,14);
             wrtxt("Title");
             // sc_gotoxy(3,15);
             taste=e_zle (3,15,fd.j1_tit[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==34)
     {
        do
        {
             // sc_gotoxy(3,16);
             taste=e_zle (3,16,fd.j1_tit[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==35)
     {
        do
        {
             // sc_gotoxy(3,17);
             taste=e_zle (3,17,fd.j1_tit[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==36)
     {
        do
        {
             // sc_gotoxy(3,18);
             taste=e_zle (3,18,fd.j1_tit[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==37)
     {
        do
        {
             // sc_gotoxy(3,19);
             taste=e_zle (3,19,fd.j1_tit[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==38)
     {
        do
        {
             // sc_gotoxy(3,20);
             taste=e_zle (3,20,fd.j1_tit[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==39)
     {
        do
        {
             // sc_gotoxy(3,21);
             taste=e_zle (3,21,fd.j1_tit[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==40)
     {
        do
        {
             // sc_gotoxy(3,22);
             taste=e_zle (3,22,fd.j1_tit[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==41)
     {
        do
        {
             sc_gotoxy(23,14);
             wrtxt("Title of book");
             // sc_gotoxy(23,15);
             taste=e_zle (23,15,fd.b1_tit[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==42)
     {
        do
        {
             // sc_gotoxy(23,16);
             taste=e_zle (23,16,fd.b1_tit[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==43)
     {
        do
        {
             // sc_gotoxy(23,17);
             taste=e_zle (23,17,fd.b1_tit[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==44)
     {
        do
        {
             // sc_gotoxy(23,18);
             taste=e_zle (23,18,fd.b1_tit[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==45)
     {
        do
        {
             // sc_gotoxy(23,19);
             taste=e_zle (23,19,fd.b1_tit[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==46)
     {
        do
        {
             // sc_gotoxy(23,20);
             taste=e_zle (23,20,fd.b1_tit[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==47)
     {
        do
        {
             // sc_gotoxy(23,21);
             taste=e_zle (23,21,fd.b1_tit[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==48)
     {
        do
        {
             // sc_gotoxy(23,22);
             taste=e_zle (23,22,fd.b1_tit[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==49)
     {
        do
        {
             // sc_gotoxy(23,23);
             taste=e_zle (23,23,fd.b1_tit[8],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==50)
     {
        do
        {
             // sc_gotoxy(23,24);
             taste=e_zle (23,24,fd.b1_tit[9],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==51)
     {
        do
        {
             sc_gotoxy(43,14);
             wrtxt("Title of article");
             // sc_gotoxy(43,15);
             taste=e_zle (43,15,fd.b2_tit[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==52)
     {
        do
        {
             // sc_gotoxy(43,16);
             taste=e_zle (43,16,fd.b2_tit[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==53)
     {
        do
        {
             // sc_gotoxy(43,17);
             taste=e_zle (43,17,fd.b2_tit[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==54)
     {
        do
        {
             // sc_gotoxy(43,18);
             taste=e_zle (43,18,fd.b2_tit[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==55)
     {
        do
        {
             // sc_gotoxy(43,19);
             taste=e_zle (43,19,fd.b2_tit[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==56)
     {
        do
        {
             // sc_gotoxy(43,20);
             taste=e_zle (43,20,fd.b2_tit[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==57)
     {
        do
        {
             // sc_gotoxy(43,21);
             taste=e_zle (43,21,fd.b2_tit[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==58)
     {
        do
        {
             // sc_gotoxy(43,22);
             taste=e_zle (43,22,fd.b2_tit[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==59)
     {
        do
        {
             sc_gotoxy(63,14);
             wrtxt("Title of book");
             // sc_gotoxy(63,15);
             taste=e_zle (63,15,fd.b2_titb[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==60)
     {
        do
        {
             // sc_gotoxy(63,16);
             taste=e_zle (63,16,fd.b2_titb[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==61)
     {
        do
        {
             // sc_gotoxy(63,17);
             taste=e_zle (63,17,fd.b2_titb[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==62)
     {
        do
        {
             // sc_gotoxy(63,18);
             taste=e_zle (63,18,fd.b2_titb[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==63)
     {
        do
        {
             // sc_gotoxy(63,19);
             taste=e_zle (63,19,fd.b2_titb[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==64)
     {
        do
        {
             // sc_gotoxy(63,20);
             taste=e_zle (63,20,fd.b2_titb[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==65)
     {
        do
        {
             // sc_gotoxy(63,21);
             taste=e_zle (63,21,fd.b2_titb[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==66)
     {
        do
        {
             // sc_gotoxy(63,22);
             taste=e_zle (63,22,fd.b2_titb[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==67)
     {
        do
        {
             // sc_gotoxy(63,23);
             taste=e_zle (63,23,fd.b2_titb[8],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==68)
     {
        do
        {
             // sc_gotoxy(63,24);
             taste=e_zle (63,24,fd.b2_titb[9],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }





     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;
     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;

   } while(1);
}

static int formular03(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS =80;
   sc_gotoxy(1,2);
   wrtxt("[03] * Localization strings");
   posit = 1;

   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(3,4);
             wrtxt("(J1)");
             // sc_gotoxy(3,5);
             taste=e_zle (3,5,fd.j1_lok[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==2)
     {
        do
        {
             // sc_gotoxy(3,6);
             taste=e_zle (3,6,fd.j1_lok[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==3)
     {
        do
        {
             // sc_gotoxy(3,7);
             taste=e_zle (3,7,fd.j1_lok[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==4)
     {
        do
        {
             // sc_gotoxy(3,8);
             taste=e_zle (3,8,fd.j1_lok[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==5)
     {
        do
        {
             // sc_gotoxy(3,9);
             taste=e_zle (3,9,fd.j1_lok[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==6)
     {
        do
        {
             // sc_gotoxy(3,10);
             taste=e_zle (3,10,fd.j1_lok[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==7)
     {
        do
        {
             // sc_gotoxy(3,11);
             taste=e_zle (3,11,fd.j1_lok[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==8)
     {
        do
        {
             // sc_gotoxy(3,12);
             taste=e_zle (3,12,fd.j1_lok[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==9)
     {
        do
        {
             // sc_gotoxy(3,13);
             taste=e_zle (3,13,fd.j1_lok[8],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==10)
     {
        do
        {
             // sc_gotoxy(3,14);
             taste=e_zle (3,14,fd.j1_lok[9],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==11)
     {
        do
        {
             // sc_gotoxy(3,15);
             taste=e_zle (3,15,fd.j1_lok[10],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==12)
     {
        do
        {
             // sc_gotoxy(3,16);
             taste=e_zle (3,16,fd.j1_lok[11],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==13)
     {
        do
        {
             // sc_gotoxy(3,17);
             taste=e_zle (3,17,fd.j1_lok[12],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==14)
     {
        do
        {
             // sc_gotoxy(3,18);
             taste=e_zle (3,18,fd.j1_lok[13],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==15)
     {
        do
        {
             // sc_gotoxy(3,19);
             taste=e_zle (3,19,fd.j1_lok[14],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==16)
     {
        do
        {
             // sc_gotoxy(3,20);
             taste=e_zle (3,20,fd.j1_lok[15],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==17)
     {
        do
        {
             // sc_gotoxy(3,21);
             taste=e_zle (3,21,fd.j1_lok[16],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==18)
     {
        do
        {
             // sc_gotoxy(3,22);
             taste=e_zle (3,22,fd.j1_lok[17],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==19)
     {
        do
        {
             // sc_gotoxy(3,23);
             taste=e_zle (3,23,fd.j1_lok[18],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==20)
     {
        do
        {
             // sc_gotoxy(3,24);
             taste=e_zle (3,24,fd.j1_lok[19],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }


     if (posit==21)
     {
        do
        {
             sc_gotoxy(23,4);
             wrtxt("(B1)");
             // sc_gotoxy(23,5);
             taste=e_zle (23,5,fd.b1_lok[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==22)
     {
        do
        {
             // sc_gotoxy(23,6);
             taste=e_zle (23,6,fd.b1_lok[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==23)
     {
        do
        {
             // sc_gotoxy(23,7);
             taste=e_zle (23,7,fd.b1_lok[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==24)
     {
        do
        {
             // sc_gotoxy(23,8);
             taste=e_zle (23,8,fd.b1_lok[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==25)
     {
        do
        {
             // sc_gotoxy(23,9);
             taste=e_zle (23,9,fd.b1_lok[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==26)
     {
        do
        {
             // sc_gotoxy(23,10);
             taste=e_zle (23,10,fd.b1_lok[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==27)
     {
        do
        {
             // sc_gotoxy(23,11);
             taste=e_zle (23,11,fd.b1_lok[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==28)
     {
        do
        {
             // sc_gotoxy(23,12);
             taste=e_zle (23,12,fd.b1_lok[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==29)
     {
        do
        {
             // sc_gotoxy(23,13);
             taste=e_zle (23,13,fd.b1_lok[8],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==30)
     {
        do
        {
             // sc_gotoxy(23,14);
             taste=e_zle (23,14,fd.b1_lok[9],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==31)
     {
        do
        {
             // sc_gotoxy(23,15);
             taste=e_zle (23,15,fd.b1_lok[10],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==32)
     {
        do
        {
             // sc_gotoxy(23,16);
             taste=e_zle (23,16,fd.b1_lok[11],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==33)
     {
        do
        {
             // sc_gotoxy(23,17);
             taste=e_zle (23,17,fd.b1_lok[12],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==34)
     {
        do
        {
             // sc_gotoxy(23,18);
             taste=e_zle (23,18,fd.b1_lok[13],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==35)
     {
        do
        {
             // sc_gotoxy(23,19);
             taste=e_zle (23,19,fd.b1_lok[14],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==36)
     {
        do
        {
             taste=e_zle (23,20,fd.b1_lok[15],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==37)
     {
        do
        {
             taste=e_zle (23,21,fd.b1_lok[16],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==38)
     {
        do
        {
             taste=e_zle (23,22,fd.b1_lok[17],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==39)
     {
        do
        {
             taste=e_zle (23,23,fd.b1_lok[18],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==40)
     {
        do
        {
             taste=e_zle (23,24,fd.b1_lok[19],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==41)
     {
        do
        {
             sc_gotoxy(43,4);
             wrtxt("(B2)");
             taste=e_zle (43,5,fd.b2_lok[0],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==42)
     {
        do
        {
             taste=e_zle (43,6,fd.b2_lok[1],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==43)
     {
        do
        {
             taste=e_zle (43,7,fd.b2_lok[2],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==44)
     {
        do
        {
             taste=e_zle (43,8,fd.b2_lok[3],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==45)
     {
        do
        {
             taste=e_zle (43,9,fd.b2_lok[4],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==46)
     {
        do
        {
             taste=e_zle (43,10,fd.b2_lok[5],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==47)
     {
        do
        {
             taste=e_zle (43,11,fd.b2_lok[6],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==48)
     {
        do
        {
             taste=e_zle (43,12,fd.b2_lok[7],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==49)
     {
        do
        {
             taste=e_zle (43,13,fd.b2_lok[8],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==50)
     {
        do
        {
             taste=e_zle (43,14,fd.b2_lok[9],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==51)
     {
        do
        {
             taste=e_zle (43,15,fd.b2_lok[10],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==52)
     {
        do
        {
             taste=e_zle (43,16,fd.b2_lok[11],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==53)
     {
        do
        {
             taste=e_zle (43,17,fd.b2_lok[12],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==54)
     {
        do
        {
             taste=e_zle (43,18,fd.b2_lok[13],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==55)
     {
        do
        {
             taste=e_zle (43,19,fd.b2_lok[14],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==56)
     {
        do
        {
             taste=e_zle (43,20,fd.b2_lok[15],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==57)
     {
        do
        {
             taste=e_zle (43,21,fd.b2_lok[16],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==58)
     {
        do
        {
             taste=e_zle (43,22,fd.b2_lok[17],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==59)
     {
        do
        {
             taste=e_zle (43,23,fd.b2_lok[18],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==60)
     {
        do
        {
             taste=e_zle (43,24,fd.b2_lok[19],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==61)
     {
        do
        {
             taste=e_zle (63,5,fd.b2_lok[20],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==62)
     {
        do
        {
             taste=e_zle (63,6,fd.b2_lok[21],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==63)
     {
        do
        {
             taste=e_zle (63,7,fd.b2_lok[22],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==64)
     {
        do
        {
             taste=e_zle (63,8,fd.b2_lok[23],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==65)
     {
        do
        {
             taste=e_zle (63,9,fd.b2_lok[24],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==66)
     {
        do
        {
             taste=e_zle (63,10,fd.b2_lok[25],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==67)
     {
        do
        {
             taste=e_zle (63,11,fd.b2_lok[26],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==68)
     {
        do
        {
             taste=e_zle (63,12,fd.b2_lok[27],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==69)
     {
        do
        {
             taste=e_zle (63,13,fd.b2_lok[28],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==70)
     {
        do
        {
             taste=e_zle (63,14,fd.b2_lok[29],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==71)
     {
        do
        {
             taste=e_zle (63,15,fd.b2_lok[30],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==72)
     {
        do
        {
             taste=e_zle (63,16,fd.b2_lok[31],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==73)
     {
        do
        {
             taste=e_zle (63,17,fd.b2_lok[32],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==74)
     {
        do
        {
             taste=e_zle (63,18,fd.b2_lok[33],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==75)
     {
        do
        {
             taste=e_zle (63,19,fd.b2_lok[34],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==76)
     {
        do
        {
             taste=e_zle (63,20,fd.b2_lok[35],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==77)
     {
        do
        {
             taste=e_zle (63,21,fd.b2_lok[36],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==78)
     {
        do
        {
             taste=e_zle (63,22,fd.b2_lok[37],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==79)
     {
        do
        {
             taste=e_zle (63,23,fd.b2_lok[38],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==80)
     {
        do
        {
             taste=e_zle (63,24,fd.b2_lok[39],FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;

     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;
   } while(1);
}

static int formular04(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS =4;
   sc_gotoxy(1,2);
   wrtxt("[04] * Definition of authors' and editors' strings: sequence of first names\n");
   wrtxt("and names\n\n");
   wrtxt("   Sequence type Ŀ   \n");
   wrtxt("                                                                      \n");
   wrtxt("      0  FirstAuth, SecondAuth, ...  LastAuth                         \n");
   wrtxt("      1  FirstAuth A.A., SecondAuth B.B., ... LastAuth Z.Z.           \n");
   wrtxt("      2  A.A. FirstAuth, B.B. SecondAuth, ... Z.Z. LastAuth           \n");
   wrtxt("      3  FirstAuth, A.A., B.B. SecondAuth, ... Z.Z. LastAuth          \n");
   wrtxt("     \n");

   sc_gotoxy(1,18);
   wrtxt("Delimiters (to be defined on the next page) applicable to patterns 0-3\n\n");
   wrtxt("  pattern 0   delimiters: 1, 2, 6\n");
   wrtxt("  pattern 1   delimiters: 1, 2, 3, 5, 6\n");
   wrtxt("  pattern 2   delimiters: 1, 2, 3, 4, 6\n");
   wrtxt("  pattern 3   delimiters: 1, 2, 3, 4, 5, 6\n");


   posit = 1;
   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(1,13);
             strcpy(wrtxtbu,"  J1, %au: authors, article in a journal........................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),13,fd.fdauttyp_j1,AUTTYP_LEN,AUTTYP_LEN,status);
             ABBRUCH1;
        } while(1);
     }


     if (posit==2)
     {
        do
        {
             sc_gotoxy(1,14);
             strcpy(wrtxtbu,"  B1, %ed: editors, book........................................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),14,fd.fdauttyp_b1,AUTTYP_LEN,AUTTYP_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==3)
     {
        do
        {
             sc_gotoxy(1,15);
             strcpy(wrtxtbu,"  B2, %au: authors, article or chapter in a book................");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),15,fd.fdauttyp_b2au,AUTTYP_LEN,AUTTYP_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==4)
     {
        do
        {
             sc_gotoxy(1,16);
             strcpy(wrtxtbu,"  B2, %ed: editors, book, article or chapter in a book..........");
             wrtxt(wrtxtbu);
             taste=e_zle (1+strlen(wrtxtbu),16,fd.fdauttyp_b2ed,AUTTYP_LEN,AUTTYP_LEN,status);
             ABBRUCH1;
        } while(1);
     }



     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;

     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;
   } while(1);
}

static int formular05(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS =24;
   sc_gotoxy(1,2);
   wrtxt("[05] * Definition of authors' and editors' strings: spaces and delimiters\n\n");
   wrtxt("  Delimiters of authors'/editors' strings Ŀ\n");
   wrtxt("                                                                           \n");
   wrtxt("   FirstAuth, A. A., B. B. SecondAuth, C. C. ThirdAuth & Z. Z. LastAuth.   \n"),
   wrtxt("                   ^^1               ^^1              ^^^2                 \n");
   wrtxt("   FirstAuth, A. A., B. B. SecondAuth, C. C. ThirdAuth & Z. Z. LastAuth.   \n"),
   wrtxt("            ^^5^^3^3      ^4            ^3  ^4                         ^6  \n");
   wrtxt(" \n");
   wrtxt("                                                                           \n");
   wrtxt("^1: delimiter (del.) between authors' names, ^2 del. between last two names\n");
   wrtxt("^3: del. after first names, ^4: del. between first name and name, ^5: del.\n");
   wrtxt("between name and first name, ^6: del. after last name.\n");
   sc_gotoxy(1+2,16);wrtxt("J1, %au");
   sc_gotoxy(21+2,16);wrtxt("B1, %ed");
   sc_gotoxy(41+2,16);wrtxt("B2, %au");
   sc_gotoxy(61+2,16);wrtxt("B2, %ed");
   sc_gotoxy(1,24);
   wrtxt("All fields: %() enters the string of the argument.");

   posit = 1;

   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(1,17);wrtxt("^1");
             taste=e_zle (1+2,17,fd.fdbetwau_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==2)
     {
        do
        {
             // sc_gotoxy(21+2,17);
             taste=e_zle (21+2,17,fd.fdbetwau_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==3)
     {
        do
        {
             // sc_gotoxy(41+2,17);
             taste=e_zle (41+2,17,fd.fdbetwau_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==4)
     {
        do
        {
             // sc_gotoxy(61+2,17);
             taste=e_zle (61+2,17,fd.fdbetwau_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==5)
     {
        do
        {
             sc_gotoxy(1,18);wrtxt("^2");
             taste=e_zle (1+2,18,fd.fdbetwaulast_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==6)
     {
        do
        {
             // sc_gotoxy(21+2,18);
             taste=e_zle (21+2,18,fd.fdbetwaulast_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==7)
     {
        do
        {
             // sc_gotoxy(41+2,18);
             taste=e_zle (41+2,18,fd.fdbetwaulast_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==8)
     {
        do
        {
             // sc_gotoxy(61+2,18);
             taste=e_zle (61+2,18,fd.fdbetwaulast_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==9)
     {
        do
        {
             sc_gotoxy(1,19);wrtxt("^3");
             taste=e_zle (1+2,19,fd.fdv_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==10)
     {
        do
        {
             // sc_gotoxy(21+2,19);
             taste=e_zle (21+2,19,fd.fdv_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==11)
     {
        do
        {
             // sc_gotoxy(41+2,19);
             taste=e_zle (41+2,19,fd.fdv_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==12)
     {
        do
        {
             // sc_gotoxy(61+2,19);
             taste=e_zle (61+2,19,fd.fdv_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==13)
     {
        do
        {
             sc_gotoxy(1,20);wrtxt("^4");
             taste=e_zle (1+2,20,fd.fdauvornach_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==14)
     {
        do
        {
             // sc_gotoxy(21+2,20);
             taste=e_zle (21+2,20,fd.fdauvornach_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==15)
     {
        do
        {
             // sc_gotoxy(41+2,20);
             taste=e_zle (41+2,20,fd.fdauvornach_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==16)
     {
        do
        {
             // sc_gotoxy(61+2,20);
             taste=e_zle (61+2,20,fd.fdauvornach_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==17)
     {
        do
        {
             sc_gotoxy(1,21);wrtxt("^5");
             taste=e_zle (1+2,21,fd.fdaunachvor_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==18)
     {
        do
        {
             // sc_gotoxy(21+2,21);
             taste=e_zle (21+2,21,fd.fdaunachvor_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==19)
     {
        do
        {
             // sc_gotoxy(41+2,21);
             taste=e_zle (41+2,21,fd.fdaunachvor_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==20)
     {
        do
        {
             // sc_gotoxy(61+2,21);
             taste=e_zle (61+2,21,fd.fdaunachvor_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }





     if (posit==21)
     {
        do
        {
             sc_gotoxy(1,22);wrtxt("^6");
             taste=e_zle (1+2,22,fd.fdafterlastau_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==22)
     {
        do
        {
             // sc_gotoxy(21+2,22);
             taste=e_zle (21+2,22,fd.fdafterlastau_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==23)
     {
        do
        {
             // sc_gotoxy(41+2,22);
             taste=e_zle (41+2,22,fd.fdafterlastau_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==24)
     {
        do
        {
             // sc_gotoxy(61+2,22);
             taste=e_zle (61+2,22,fd.fdafterlastau_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;

     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;
   } while(1);
}


static int formular06(void)
{
   int MAXITEMS;
   int posit;
   static int posit_alt;
   int status = 2; /* Status bei ein_zeile */
   int taste = 1;
   sc_clrscr();
   MAXITEMS =12;
   sc_gotoxy(1,2);
   posit = 1;
   wrtxt("[06] * Definition of authors' and editors' strings: number of authors printed\n");
   wrtxt("into the textfile\n\n");
   wrtxt("       An example Ŀ   \n");
   wrtxt("                                                                     \n");
   wrtxt("           print all authors if not more than 6 else print 3         \n");
   wrtxt("                                              ^n           ^m        \n");
   wrtxt("        \n\n");
   wrtxt("Other figures for n, m are possible. If all authors are to be printed enter\n");
   wrtxt("'999' for n, m. If not all authors are printed into the textfile, a string\n");
   wrtxt("like 'et al.' can be entered in the fields of the 3rd column.\n");
   sc_gotoxy(11+18,15);wrtxt("'n'");
   sc_gotoxy(21+18,15);wrtxt("'m'");
   sc_gotoxy(31+18,15);wrtxt("'et al.'");
   sc_gotoxy(1,21);
   wrtxt("'%()' may be used: the string in brackets will be entered in the 'et al.'-\n");
   wrtxt("field.\n\n");
   wrtxt("This is the last page of the current format definition, go back with [PgUp]");


   do
   {
     if (posit==1)
     {
        do
        {
             sc_gotoxy(1,16);
             wrtxt("         J1, %au...........");
             // sc_gotoxy(5+18,16);
             taste=e_zle (10+18,16,fd.fdau_n_j1,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==2)
     {
        do
        {
             // sc_gotoxy(15+18,16);
             taste=e_zle (20+18,16,fd.fdau_m_j1,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }


     if (posit==3)
     {
        do
        {
             // sc_gotoxy(25+18,16);
             taste=e_zle (30+18,16,fd.fdweitereau_j1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==4)
     {
        do
        {
             sc_gotoxy(1,17);
             wrtxt("         B1, %ed...........");
             // sc_gotoxy(5+18,17);
             taste=e_zle (10+18,17,fd.fdau_n_b1,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==5)
     {
        do
        {
             // sc_gotoxy(15+18,17);
             taste=e_zle (20+18,17,fd.fdau_m_b1,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==6)
     {
        do
        {
             // sc_gotoxy(25+18,17);
             taste=e_zle (30+18,17,fd.fdweitereau_b1,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }


     if (posit==7)
     {
        do
        {
             sc_gotoxy(1,18);
             wrtxt("         B2, %au...........");
             // sc_gotoxy(5+18,18);
             taste=e_zle (10+18,18,fd.fdau_n_b2au,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==8)
     {
        do
        {
             // sc_gotoxy(15+18,18);
             taste=e_zle (20+18,18,fd.fdau_m_b2au,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==9)
     {
        do
        {
             // sc_gotoxy(25+18,18);
             taste=e_zle (30+18,18,fd.fdweitereau_b2au,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==10)
     {
        do
        {
             sc_gotoxy(1,19);
             wrtxt("         B2, %ed...........");
             // sc_gotoxy(5+18,19);
             taste=e_zle (10+18,19,fd.fdau_n_b2ed,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }
     if (posit==11)
     {
        do
        {
             // sc_gotoxy(15+18,19);
             taste=e_zle (20+18,19,fd.fdau_m_b2ed,ZIFFER_STRING_LEN,ZIFFER_STRING_LEN,status);
             ABBRUCH1;
        } while(1);
     }

     if (posit==12)
     {
        do
        {
             // sc_gotoxy(25+18,19);
             taste=e_zle (30+18,19,fd.fdweitereau_b2ed,FD_FELD_LEN,FD_FELD_LEN,status);
             ABBRUCH1;
        } while(1);
     }



     if (status==2) { status = 0; posit = posit_alt; } /* Nach dem ersten Durchlauf umschalten auf Eingabe */
     posit_alt = posit;

     if (taste==PGUP_KEY) return -1;
     else if (taste==PGDN_KEY) return 1;
     else  if (taste==ESC_KEY || taste == F10_KEY) return 0;

     if (posit > MAXITEMS) posit=MAXITEMS;
     if (posit < 1) posit = 1;
     if (taste==CTRLHOME_KEY) posit = 1;
     if (taste==CTRLEND_KEY) posit = MAXITEMS;
   } while(1);
}


static long datensatz_lesen(void)
{
   long i, j, anzahl_records, byte_zeiger, zahl;
   int taste;
   if (isfile(formdef_name))
   {
      if ((fpformdef=fopen(formdef_name,"rb"))==0)
      {
        sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
        beenden(fehlermeldung,2);
      }
   }
   else
   {
      sprintf(wrtxtbu,"\n[%s does not exist: create a new file]>",formdef_name);
      wrtxt(wrtxtbu);
      tastelesen();
      sc_gotoxy(1,one_config_set.sl - 1);
      return -1;
   }
   fseek(fpformdef,0L,SEEK_END);
   byte_zeiger = ftell(fpformdef);
   anzahl_records = byte_zeiger/sizeof(fd);
   anzahl_records--;
   j = 1;
   rewind(fpformdef);
   for (i=0;i<=anzahl_records;i++)
   {
       if (fread(&fd,sizeof(fd),1,fpformdef)==0)
       {
         sprintf(fehlermeldung,"Cannot read record in %s",formdef_name);
         beenden(fehlermeldung,2);
       }
       // if ((j % 22)==0)
       if ((j % (one_config_set.sl-3))==0)
       {
          wrtxt("\n");
          taste=lotus_menu(
             "NextPage$Show the next page of format definitions"
             "@Cancel$Finish viewing the current text, enter the format definition code"
                          );
          if (taste==0 || taste==2)
          {
             sc_gotoxy(1,one_config_set.sl-2); break;
          }
          j++;
       }
       sprintf(wrtxtbu,"%6li %*s: %s\n",i,-FORMKENNUNG_LEN,fd.formkennung,fd.formatbeschreibung);
       wrtxt(wrtxtbu);
       j++;
   }
   wrtxt("\n\n");

   fclose(fpformdef);
   do
   {
       static char zahlstring[10];
       int ok;
       sc_gotoxy(1,one_config_set.sl-1);
       info_zeile("Please enter the number of the format definition to be selected");
       strcpy(wrtxtbu,"Format definition code.....");
       wrtxt(wrtxtbu);
       taste = e_zle(1+strlen(wrtxtbu),one_config_set.sl-1,zahlstring,4,4,0);
       if ((strlen(zahlstring)==0 && taste==ENTER_KEY) || (taste==ESC_KEY)) return -1;
       string_in_long(zahlstring,&zahl,&ok);
       if (!ok || zahl<0 || zahl > anzahl_records) continue;
       if (taste==ENTER_KEY)
           break;

   } while (1);
   formdef_datensatz = zahl;
   byte_zeiger=formdef_datensatz*sizeof(fd);
   if ((fpformdef=fopen(formdef_name,"rb"))==0)
   {
     sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
     beenden(fehlermeldung,2);
   }

   fseek(fpformdef,byte_zeiger,SEEK_SET);
   fread(&fd,sizeof(fd),1,fpformdef);
   fclose(fpformdef);
   return formdef_datensatz;
}

static void rewrite_record(void)
{
   long byte_zeiger;

   if ((fpformdef=fopen(formdef_name,"r+b"))==0)
   {
     sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
     beenden(fehlermeldung,2);
   }
   byte_zeiger = formdef_datensatz * sizeof(fd);

   fseek(fpformdef,byte_zeiger,SEEK_SET);
   fwrite(&fd,sizeof(fd),1,fpformdef);
   fclose(fpformdef);

}

static void rec_loeschen(void)
{
   long del_rec, i, anzahl_records, byte_zeiger;

   del_rec = datensatz_lesen();
   cls_line("");
   if (del_rec > -1)
   {
      if ((fpformdef=fopen(formdef_name,"rb"))==0)
      {
        sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
        beenden(fehlermeldung,2);
      }
      if ((fpformdeftemp=fopen(formdef_temp_name,"wb"))==NULL)
      {
        sprintf(fehlermeldung,"ERROR: cannot create %s",formdef_temp_name);
        beenden(fehlermeldung,2);
      }
      fseek(fpformdef,0L,SEEK_END);

      byte_zeiger = ftell(fpformdef);
      anzahl_records = byte_zeiger / sizeof(fd);
      anzahl_records--;
      memset(&fd,0,sizeof(fd));
      rewind(fpformdef);
      for (i=0;i<=anzahl_records;i++)
      {
         fread(&fd,sizeof(fd),1,fpformdef);
         if (i!=del_rec)
         {
             fwrite(&fd,sizeof(fd),1,fpformdeftemp);
         }
      }
      fclose(fpformdeftemp);
      fclose(fpformdef);
      remove(formdef_name);
      rename(formdef_temp_name,formdef_name);
      cls_line(RFD_TITELZEILE);
      sprintf(wrtxtbu,"\n[Record %li deleted, please press any key]>",del_rec);
      wrtxt(wrtxtbu);
      tastelesen();
   }
   else
   {
      cls_line(RFD_TITELZEILE);
      wrtxt("\n[No record deleted, please press any key]>");
      tastelesen();
   }
}


static void exportieren(void)
{
   FILE * fpexport;
   static char eingabe[DOSDATEIVORNAME_LEN+1];
   char export_datei[150];
   int taste, option;

   if (datensatz_lesen()==-1)
   {
      cls_line(RFD_TITELZEILE);
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   cls_line("");
   do
   {
       info_zeile("Enter a filename for the export *.FD3 file, [Esc] to leave");
       strcpy(wrtxtbu,"FD export file.....");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,
                   DOSDATEIVORNAME_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl);sc_clreol();

       if (taste==ESC_KEY) return ;
       if (isdosfilename(eingabe)==0)
       {
           taste=200;
           continue;
       }
       upper(eingabe);
   }
   while (taste!=ENTER_KEY);
   if (!strcmp(eingabe,"")) return;
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(export_datei,eingabe);
   strcat(export_datei,".FD3");
   if (isfile(export_datei))
   {
      option = lotus_menu("Cancel$Quit the export procedure@"
                          "Overwrite$Overwrite the existent export file");
      if (option<=1) return;
   }
   if ((fpexport=fopen(export_datei,"wb"))==NULL)
   {
     sprintf(fehlermeldung,"ERROR: cannot create %s",export_datei);
     beenden(fehlermeldung,2);
   }
   fwrite(&fd,sizeof(fd),1,fpexport);
   fclose(fpexport);
   cls_line(RFD_TITELZEILE);
   sprintf(wrtxtbu,"\n[%s closed, please press any key]>",export_datei);
   wrtxt(wrtxtbu);
   tastelesen();
}

static void importieren(void)
{
   char import_datei[150];
   FILE * fpimport;

   if (!datei_suchen("*.FD3",import_datei))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   if (filesize(import_datei)!=sizeof(fd))
   {
    sprintf(wrtxtbu,"\nProblem: incorrect file size of %s, possibly generated\n"
        "in different program version (other than 3.5).\n",import_datei);
    wrtxt(wrtxtbu);
    wrtxt("\n[Please press any key]>");
    tastelesen();
    return;
   }
   wrtxt("\n");
   if ((fpimport=fopen(import_datei,"rb"))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot open %s",import_datei);
       beenden(fehlermeldung,2);
   }
   if ((fpformdef = fopen(formdef_name,"r+b"))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: File %s does not exist",formdef_name);
       beenden(fehlermeldung,2);
   }
   if (fread(&fd,sizeof(fd),1,fpimport) < 1)
   {
      sprintf(wrtxtbu,"[Unable to read %s]>",import_datei);
      wrtxt(wrtxtbu);
      tastelesen();
   }
   else
   {
      fseek(fpformdef,0L,SEEK_END);
      fwrite(&fd,sizeof(fd),1,fpformdef);
      sprintf(wrtxtbu,"[Format definition from %s added to %s]>",import_datei,formdef_name);
      wrtxt(wrtxtbu);
      tastelesen();
   }
   fclose(fpimport);
   fclose(fpformdef);
}


#undef ABBRUCH1
