/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
    rfd1_fun.c
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fd.h"
#include "refs.h"
#include "abbruch.h"
#include "rfd_fun.h"
#include "rfd1_fun.h"
#include "l_menu.h"
#include "fl_ut.h"
#include "str_fun.h"
 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

#define RFDZEILE_LEN 1024
#define VZEILE_LEN 255


#define RFD_TEXTIMPORT_ABB1 extract_subs(ex_rfdzeile,rfdzeile,vzpos,RFDZEILE_LEN); \
          if (strlen(ex_rfdzeile) <= 1) \
          { \
            continue; \
          } \
          vzpos=strlen(ex_rfdzeile)-1; \
          if (ex_rfdzeile[vzpos]=='\'') ex_rfdzeile[vzpos]='\0'




int fd_in_textdatei(formdef_rec fd, char * dateiname)
{
   FILE * fptext;
   int i;
   int option;
   char text_name[PFAD_LEN];
   strcpy(text_name,dateiname);

   if (isfile(text_name))
   {
      option = lotus_menu("Cancel$Output text file already exists, quit the export procedure@"
                          "Append$Append format definition to output text file");
      if (option<=1) return 0;
   }

   if ((fptext=fopen(text_name,"at"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: cannot create %s",text_name);
      beenden(fehlermeldung,2);
   }

   fprintf(fptext,"BIBLIOGRAPHIC STYLE FORMAT DEFINITION -- REFERENCES 3.5\n");

   fprintf(fptext,"\nformat definition '%s'",fd.formkennung);
   fprintf(fptext,"\ndescription '%s'",fd.formatbeschreibung);

   fprintf(fptext,"\n");

   fprintf(fptext,"\nj1 string 1 '%s'",fd.fdj1_str1);
   fprintf(fptext,"\nj1 string 2 '%s'",fd.fdj1_str2);
   fprintf(fptext,"\nj1 string 3 '%s'",fd.fdj1_str3);
   fprintf(fptext,"\n");
   fprintf(fptext,"\nb1 string 1 '%s'",fd.fdb1_str1);
   fprintf(fptext,"\nb1 string 2 '%s'",fd.fdb1_str2);
   fprintf(fptext,"\nb1 string 3 '%s'",fd.fdb1_str3);
   fprintf(fptext,"\n");
   fprintf(fptext,"\nb2 string 1 '%s'",fd.fdb2_str1);
   fprintf(fptext,"\nb2 string 2 '%s'",fd.fdb2_str2);
   fprintf(fptext,"\nb2 string 3 '%s'",fd.fdb2_str3);
   fprintf(fptext,"\nb2 string 4 '%s'",fd.fdb2_str4);
   fprintf(fptext,"\nb2 string 5 '%s'",fd.fdb2_str5);

   fprintf(fptext,"\n");
   for (i=0;i<J1_AUT_N;i++)
   {
     fprintf(fptext,"\nj1 authors %i '%s'",i,fd.j1_aut[i]);
   }
   for (i=0;i<J1_TIT_N;i++)
   {
     fprintf(fptext,"\nj1 title %i '%s'",i,fd.j1_tit[i]);
   }
   for (i=0;i<J1_LOK_N;i++)
   {
     fprintf(fptext,"\nj1 localization %i '%s'",i,fd.j1_lok[i]);
   }

   fprintf(fptext,"\n");
   for (i=0;i<B1_ED_N;i++)
   {
     fprintf(fptext,"\nb1 editors %i '%s'",i,fd.b1_ed[i]);
   }
   for (i=0;i<B1_TIT_N;i++)
   {
     fprintf(fptext,"\nb1 book-title %i '%s'",i,fd.b1_tit[i]);
   }
   for (i=0;i<B1_LOK_N;i++)
   {
     fprintf(fptext,"\nb1 localization %i '%s'",i,fd.b1_lok[i]);
   }

   fprintf(fptext,"\n");
   for (i=0;i<B2_AUT_N;i++)
   {
     fprintf(fptext,"\nb2 authors %i '%s'",i,fd.b2_aut[i]);
   }
   for (i=0;i<B2_TIT_N;i++)
   {
     fprintf(fptext,"\nb2 title %i '%s'",i,fd.b2_tit[i]);
   }
   for (i=0;i<B2_ED_N;i++)
   {
     fprintf(fptext,"\nb2 editors %i '%s'",i,fd.b2_ed[i]);
   }
   for (i=0;i<B2_TITB_N;i++)
   {
     fprintf(fptext,"\nb2 book-title %i '%s'",i,fd.b2_titb[i]);
   }
   for (i=0;i<B2_LOK_N;i++)
   {
     fprintf(fptext,"\nb2 localization %i '%s'",i,fd.b2_lok[i]);
   }

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 authors string type '%s'",fd.fdauttyp_j1);
   fprintf(fptext,"\nb1 editors string type '%s'",fd.fdauttyp_b1);
   fprintf(fptext,"\nb2 authors string type '%s'",fd.fdauttyp_b2au);
   fprintf(fptext,"\nb2 editors string type '%s'",fd.fdauttyp_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^1 in authors string '%s'",fd.fdbetwau_j1);
   fprintf(fptext,"\nb1 delimiter ^1 in editors string '%s'",fd.fdbetwau_b1);
   fprintf(fptext,"\nb2 delimiter ^1 in authors string '%s'",fd.fdbetwau_b2au);
   fprintf(fptext,"\nb2 delimiter ^1 in editors string '%s'",fd.fdbetwau_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^2 in authors string '%s'",fd.fdbetwaulast_j1);
   fprintf(fptext,"\nb1 delimiter ^2 in editors string '%s'",fd.fdbetwaulast_b1);
   fprintf(fptext,"\nb2 delimiter ^2 in authors string '%s'",fd.fdbetwaulast_b2au);
   fprintf(fptext,"\nb2 delimiter ^2 in editors string '%s'",fd.fdbetwaulast_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^3 in authors string '%s'",fd.fdv_j1);
   fprintf(fptext,"\nb1 delimiter ^3 in editors string '%s'",fd.fdv_b1);
   fprintf(fptext,"\nb2 delimiter ^3 in authors string '%s'",fd.fdv_b2au);
   fprintf(fptext,"\nb2 delimiter ^3 in editors string '%s'",fd.fdv_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^4 in authors string '%s'",fd.fdauvornach_j1);
   fprintf(fptext,"\nb1 delimiter ^4 in editors string '%s'",fd.fdauvornach_b1);
   fprintf(fptext,"\nb2 delimiter ^4 in authors string '%s'",fd.fdauvornach_b2au);
   fprintf(fptext,"\nb2 delimiter ^4 in editors string '%s'",fd.fdauvornach_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^5 in authors string '%s'",fd.fdaunachvor_j1);
   fprintf(fptext,"\nb1 delimiter ^5 in editors string '%s'",fd.fdaunachvor_b1);
   fprintf(fptext,"\nb2 delimiter ^5 in authors string '%s'",fd.fdaunachvor_b2au);
   fprintf(fptext,"\nb2 delimiter ^5 in editors string '%s'",fd.fdaunachvor_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter ^6 in authors string '%s'",fd.fdafterlastau_j1);
   fprintf(fptext,"\nb1 delimiter ^6 in editors string '%s'",fd.fdafterlastau_b1);
   fprintf(fptext,"\nb2 delimiter ^6 in authors string '%s'",fd.fdafterlastau_b2au);
   fprintf(fptext,"\nb2 delimiter ^6 in editors string '%s'",fd.fdafterlastau_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 delimiter more names in authors string '%s'",fd.fdweitereau_j1);
   fprintf(fptext,"\nb1 delimiter more names in editors string '%s'",fd.fdweitereau_b1);
   fprintf(fptext,"\nb2 delimiter more names in authors string '%s'",fd.fdweitereau_b2au);
   fprintf(fptext,"\nb2 delimiter more names in editors string '%s'",fd.fdweitereau_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 n in authors string '%s'",fd.fdau_n_j1);
   fprintf(fptext,"\nb1 n in editors string '%s'",fd.fdau_n_b1);
   fprintf(fptext,"\nb2 n in authors string '%s'",fd.fdau_n_b2au);
   fprintf(fptext,"\nb2 n in editors string '%s'",fd.fdau_n_b2ed);

   fprintf(fptext,"\n");
   fprintf(fptext,"\nj1 m in authors string '%s'",fd.fdau_m_j1);
   fprintf(fptext,"\nb1 m in editors string '%s'",fd.fdau_m_b1);
   fprintf(fptext,"\nb2 m in authors string '%s'",fd.fdau_m_b2au);
   fprintf(fptext,"\nb2 m in editors string '%s'",fd.fdau_m_b2ed);
   fprintf(fptext,"\n\n");
   fprintf(fptext,"END OF BIBLIOGRAPHIC STYLE FORMAT DEFINITION");
   fprintf(fptext,"\n\n");

   cls_line(RFD_TITELZEILE);
   sprintf(wrtxtbu,"\n[Format definition text file %s written, "
                     "please press any key]>",
            FORMDEF_TXT);
   wrtxt(wrtxtbu);
   tastelesen();
   // wrtxt(" Ok...");

   fclose(fptext);

   return 1;
}

int textdatei_in_fd(char * formdef_datei_name, char * text_datei_name)
{

   int i, taste;
   FILE * fptext;
   FILE * fpformdef;
   char * rfdzeile;
   char * ex_rfdzeile;
   char vzeile[VZEILE_LEN];
   formdef_rec fd;
   long nfd;
   int vzpos;
   int fd_isopen;
     /* format defintion is opened */
   int fd_completed;
     /* format defintion has been read and may be written into binary file */
   nfd = 0L;
     /* n of format definitions */
   memset(&fd,0,sizeof(fd));
     /* doch nicht importieren: */
   taste=lotus_menu("@Cancel$Do *not* import TEXT format into format "
                            "definition files"
                    "@Import$Import TEXT format into format definition files");
   if (taste!=2)
   {
      return 0;
   }

   if ((rfdzeile =  (char *) malloc((RFDZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for RFD input line");
       beenden(fehlermeldung,2);
   }
   if ((ex_rfdzeile =  (char *) malloc((RFDZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for RFD buffer");
       beenden(fehlermeldung,2);
   }

   if ((fptext=fopen(text_datei_name,"r"))==NULL)
   {
      cls_line(RFD_TITELZEILE);
      sprintf(wrtxtbu,"\n[Problem: unable to open file %s]>",text_datei_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }

   if ((fpformdef=fopen(formdef_datei_name,"r+b"))==NULL)
   {
      cls_line(RFD_TITELZEILE);
      sprintf(wrtxtbu,"\n[Problem: unable to open file %s for writing]>",
            formdef_datei_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fseek(fpformdef,0L,SEEK_END);
   fd_isopen=0;
   fd_completed=0;
   while (fgets(rfdzeile,RFDZEILE_LEN,fptext)!=NULL)
   {
     if (strlen(rfdzeile)>=RFDZEILE_LEN)
     {
        break;
     }
     rtrim(rfdzeile,'\n');
     if (locate_substring("BIBLIOGRAPHIC STYLE FORMAT DEFINITION -- REFERENCES",
                          rfdzeile)==0)
     {
        memset(&fd,0,sizeof(fd));
        fd_isopen=1;
        fd_completed=0;
     }
     if (locate_substring("END OF BIBLIOGRAPHIC STYLE FORMAT DEFINITION",
                          rfdzeile)==0)
     {
        fd_isopen=0;
        fd_completed=1;
     }
     if (fd_completed==1 && fd_isopen==0)
     {
        fwrite(&fd,sizeof(fd),1,fpformdef);
        nfd++;
        memset(&fd,0,sizeof(fd));
        fd_completed=0;
     }

     if (fd_isopen==1)
     {
        if ( strlen (rfdzeile) < 5)
        {
          continue;
        }

        strcpy(vzeile,"format definition '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.formkennung,ex_rfdzeile,FORMKENNUNG_LEN);
          wrtxt("FORMAT DEFINITION "); wrtxt(ex_rfdzeile);
          continue;
        }

        strcpy(vzeile,"description '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.formatbeschreibung,ex_rfdzeile,FORMATBESCHREIBUNG_LEN);
          wrtxt(": "); wrtxt(ex_rfdzeile);
          wrtxt("\n");
          continue;
        }

        strcpy(vzeile,"j1 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j1 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"j1 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdj1_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb1_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 1 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str1,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 2 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str2,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 3 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str3,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 4 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str4,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 string 5 '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdb2_str5,ex_rfdzeile,TYP_STRING_LEN);
          continue;
        }

        for (i=0;i<J1_AUT_N;i++)
        {
           sprintf(vzeile,"j1 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J1_TIT_N;i++)
        {
           sprintf(vzeile,"j1 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<J1_LOK_N;i++)
        {
           sprintf(vzeile,"j1 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.j1_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B1_ED_N;i++)
        {
           sprintf(vzeile,"b1 editors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_ed[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B1_TIT_N;i++)
        {
           sprintf(vzeile,"b1 book-title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B1_LOK_N;i++)
        {
           sprintf(vzeile,"b1 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b1_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_AUT_N;i++)
        {
           sprintf(vzeile,"b2 authors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_aut[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_TIT_N;i++)
        {
           sprintf(vzeile,"b2 title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_tit[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_ED_N;i++)
        {
           sprintf(vzeile,"b2 editors %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_ed[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_TITB_N;i++)
        {
           sprintf(vzeile,"b2 book-title %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_titb[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        for (i=0;i<B2_LOK_N;i++)
        {
           sprintf(vzeile,"b2 localization %i '",i);
           vzpos=strlen(vzeile);
           if (locate_substring(vzeile,rfdzeile)==0)
           {
             RFD_TEXTIMPORT_ABB1;
             strlimcpy(fd.b2_lok[i],ex_rfdzeile,FD_FELD_LEN);
             continue;
           }
        }

        strcpy(vzeile,"j1 authors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_j1,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b1 editors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b1,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b2 authors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b2au,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"b2 editors string type '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauttyp_b2ed,ex_rfdzeile,AUTTYP_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^1 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^1 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^1 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^1 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^2 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^2 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^2 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^2 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdbetwaulast_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 delimiter ^3 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^3 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^3 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^3 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdv_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }



        strcpy(vzeile,"j1 delimiter ^4 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^4 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^4 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^4 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdauvornach_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }


        strcpy(vzeile,"j1 delimiter ^5 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^5 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^5 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^5 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdaunachvor_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }


        strcpy(vzeile,"j1 delimiter ^6 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter ^6 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^6 in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter ^6 in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdafterlastau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }



        strcpy(vzeile,"j1 delimiter more names in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_j1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b1 delimiter more names in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b1,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter more names in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b2au,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"b2 delimiter more names in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdweitereau_b2ed,ex_rfdzeile,FD_FELD_LEN);
          continue;
        }

        strcpy(vzeile,"j1 n in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_j1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 n in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 n in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b2au,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 n in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_n_b2ed,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }


        strcpy(vzeile,"j1 m in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_j1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b1 m in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b1,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 m in authors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b2au,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }

        strcpy(vzeile,"b2 m in editors string '");
        vzpos=strlen(vzeile);
        if (locate_substring(vzeile,rfdzeile)==0)
        {
          RFD_TEXTIMPORT_ABB1;
          strlimcpy(fd.fdau_m_b2ed,ex_rfdzeile,ZIFFER_STRING_LEN);
          continue;
        }
     }
   }


   free(rfdzeile);
   free(ex_rfdzeile);
   fclose(fpformdef);
   fclose(fptext);
   sprintf(wrtxtbu,"\n[%li format defintions imported, please "
                      "press any key]>",nfd);
   wrtxt(wrtxtbu);
   tastelesen();

   return 1;
}

#undef RFDZEILE_LEN
#undef VZEILE_LEN
#undef RFD_TEXTIMPORT_ABB1
