/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   key_fun.c
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include "str_fun.h"
#include "ix03_fun.h"
#include "l_menu.h"
#include "fl_ut.h"
#include "key_fun.h"
#include "abbruch.h"
#include "keycodes.h"

 extern char stichw_name[150];
 extern char stichw_pix_name[150];
 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern config_set one_config_set;


 extern FILE * ix03file;
 FILE * ix_stichw;
 FILE * dat_stichw;

 extern keylist_rec one_stichw_rec;
 static keylistpix_rec ix_stichw_rec;

void stichw_menu(char * stichw_zeile)
{
    int eingabe_taste;
    long ix_zeiger;
    int taste = lotus_menu(STICHW_MENU_TXT);
    static char eingabe_zeile[KEYWORDS_LEN + 2];
    if ((taste==1) || (taste==4) || (taste==5))
    {

       do
       {
          sc_gotoxy(1,one_config_set.sl-1);
          info_zeile("Write a KEYWORD-substring or an empty field for all KEYWORDS [Enter]");
          strcpy(wrtxtbu,"Substring..........");
          wrtxt(wrtxtbu);
          eingabe_taste = e_zle(
                      1+strlen(wrtxtbu),
                      one_config_set.sl-1,
                      eingabe_zeile,
                      KEYWORDS_LEN,
                      KEYWORDS_LEN,
                      0
                   );
          sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
          if (eingabe_taste==ESC_KEY) break;
       }
       while ((eingabe_taste!=ENTER_KEY) && (eingabe_taste!=F10_KEY));

       if (eingabe_taste==ESC_KEY) return;

       upper(eingabe_zeile);

       if (taste==1)
       {
           ix_zeiger = show_stichw(eingabe_zeile,0);
           sc_gotoxy(1,one_config_set.sl-1);
           if (ix_zeiger == -1) return;
           appendstring(stichw_zeile, ix_zeiger);
       }
       if (taste==4)
       {
           show_stichw(eingabe_zeile,1);
           sc_gotoxy(1,one_config_set.sl-1);
       }
    }
    if (taste==2)
    {
       enter_stichw_items();
    }
    if (taste==3)
    {
       show_stichw("",1);
       sc_gotoxy(1,one_config_set.sl-1);
    }
    if (taste==5)
    {
           ix_zeiger = show_stichw(eingabe_zeile,0);
           sc_gotoxy(1,one_config_set.sl-1);
           if (ix_zeiger == -1) return;
           delete_keywords(ix_zeiger);
           sc_gotoxy(1,one_config_set.sl-1);
    }
    return;
}

void enter_stichw_items(void)
{
    FILE * tmpix;
    char tmpix_name[150];
    int taste;
    keylistpix_rec ix_stichw_rec_lokal;
    char eingabe_zeile[KEYWORDS_LEN + 2];
    long ix_zeiger, rec_zeiger, byte_zeiger;

    strcpy(tmpix_name,"tmp_key.ix");

    strcpy(eingabe_zeile,"");
    do
    {
       // strcpy(eingabe_zeile,"");
       memset(&one_stichw_rec,0,sizeof(one_stichw_rec));
       memset(&ix_stichw_rec,0,sizeof(ix_stichw_rec));
       ix_stichw_rec.keywords_rptr=-1;

       info_zeile("Enter a new KEYWORD - [Enter] or [Esc] Quit");
       strcpy(wrtxtbu,"New keyword........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe_zeile,
                   KEYWORDS_LEN,
                   KEYWORDS_LEN,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste==ESC_KEY) break;
    }
    while (((taste!=ENTER_KEY) && (taste!=F10_KEY)) ||
            (strlen(eingabe_zeile)==0));
    if (taste==ESC_KEY)
    {
       //cls_line("");
       return;
    }
    strncpy(ix_stichw_rec.keywordsfield,eingabe_zeile,KEYWORDS_LEN);

    if (!isfile(stichw_name))
    {
          sprintf(fehlermeldung,"ERROR: Cannot read %s",stichw_name);
          beenden(fehlermeldung,2);
          // fcloseall();
          // exit(1);
    }

    if (!isfile(stichw_pix_name))
    {
          sprintf(fehlermeldung,"ERROR: Cannot read %s",stichw_name);
          beenden(fehlermeldung,2);
          // fcloseall();
          // exit(1);
    }

    if (filesize(stichw_pix_name) < sizeof(ix_stichw_rec))
    {
       ix_zeiger = -1;
    } else
    {
       read_ix03(stichw_pix_name);
       ix_zeiger = locate_ix03(eingabe_zeile, &ix_stichw_rec_lokal);
       close_ix03();
    }

    if (ix_zeiger==-1)
    {
       /* neuen Datensatz einlesen */
       one_stichw_rec.in_use = 1;
       strcpy(one_stichw_rec.keywordsfield,eingabe_zeile);
    }
    else
    {

       sc_gotoxy(1,one_config_set.sl);sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       sprintf(wrtxtbu,"\n['%s' already in file]>",eingabe_zeile);
       wrtxt(wrtxtbu);
       tastelesen();
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       return;
    }

    if (ix_zeiger==-1)
    {
       /*
          Datei stichw_name oeffnen, Datensatz an das Ende schreiben,
          Dateizeiger ist rec_zeiger;
       */
       if ((dat_stichw=fopen(stichw_name,"r+b"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: Cannot write into %s",stichw_name);
          beenden(fehlermeldung,2);
       }
       fseek(dat_stichw,0L,SEEK_END);
       byte_zeiger=ftell(dat_stichw);
       rec_zeiger=byte_zeiger/sizeof(one_stichw_rec);
       fwrite(&one_stichw_rec,sizeof(one_stichw_rec),1,dat_stichw);
       fclose(dat_stichw);
       ix_stichw_rec.keywords_rptr = rec_zeiger;

       /* Einen neuen Eintrag in Indexdatei schreiben Anfang */
       if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
       {
          sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
          beenden(fehlermeldung,2);
       }
       fwrite(&ix_stichw_rec,sizeof(ix_stichw_rec),1,tmpix);
       fclose(tmpix);
       if (isfile(stichw_pix_name))
       {
         if (filesize(stichw_pix_name)==0) remove(stichw_pix_name);
       }
       if (!isfile(stichw_pix_name))
       {
         rename(tmpix_name,stichw_pix_name);
         sc_gotoxy(1,one_config_set.sl-1);
       }
       else
       {
          mrgeix03(stichw_pix_name,tmpix_name,"tmp03.ix$");
          remove(stichw_pix_name); remove(tmpix_name);
          rename("tmp03.ix$",stichw_pix_name);
          sc_gotoxy(1,one_config_set.sl-1);
       }
       /* Einen neuen Eintrag in Indexdatei schreiben Ende */
    }
    return;
}


/* view_only 1/0: Eingabezeile am Schluss wird nicht/wird angezeigt  */

long show_stichw(const char * suchmuster, int view_only)
{
   int taste, ok, schleife_ok;
   long anzahl_stichw, i,j;
   long rec_zeiger, byte_zeiger, ix_zeiger;
   keylistpix_rec ix_stichw_rec_lokal;
   int was_gelesen;    /* steuert die Anzeige der Zifferneigabe am Schluss */

   char eingabe_zeile[ZAHLSTRING_LEN+1];
   char test_zeile[KEYWORDS_LEN+1];

   was_gelesen = 0;
   strncpy(eingabe_zeile,"",ZAHLSTRING_LEN);
   if (!isfile(stichw_pix_name))
   {
     beeps();
     wrtxt("[No Keyword index file found]>");
     sc_clreol();
     tastelesen();
     return -1L;
   }
   if (filesize(stichw_pix_name) <  sizeof(ix_stichw_rec_lokal))
   {
     beeps();
     wrtxt("\n[No Keywords found]>");
     sc_clreol();
     tastelesen();
     return -1L;
   }
   if ((dat_stichw=fopen(stichw_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot create %s",stichw_name);
      beenden(fehlermeldung,2);
   }

   cls_line("");
           wrtxt("searching keywords ..."); sc_gotoxy(1,one_config_set.sl-1);
   read_ix03(stichw_pix_name);
   anzahl_stichw = lastkey03(&ix_stichw_rec_lokal);
   i=firstkey03(&ix_stichw_rec_lokal);
   /*
   rewind(ix03file);
   entfernt am 16.11.1996
   */
   rec_zeiger = ix_stichw_rec_lokal.keywords_rptr;
   byte_zeiger = rec_zeiger * sizeof(one_stichw_rec);

   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   fread(&one_stichw_rec,sizeof(one_stichw_rec),1,dat_stichw);
   j = 1;

   if (strlen(suchmuster) > 0)
   {
      strncpy(test_zeile,one_stichw_rec.keywordsfield,KEYWORDS_LEN);
      upper(test_zeile);
      if (is_substring(suchmuster,test_zeile))
      {
        sprintf(wrtxtbu,"%6li:  %-45s\n",i,one_stichw_rec.keywordsfield);
        wrtxt(wrtxtbu);
        j++;
        was_gelesen = 1;
      }
   }
   else
   {
     sprintf(wrtxtbu,"%6li:  %-45s\n",i,one_stichw_rec.keywordsfield);
     wrtxt(wrtxtbu);
     j++;
     was_gelesen = 1;  // ???
   }

   for (i=1;i<=anzahl_stichw;i++)
   {

      // if ((j % 22)==0)
      if ((j % (one_config_set.sl-3))==0)
      {
        wrtxt("\n");
        taste = lotus_menu(
           "NextPage$Show the next page of text@"
           "Cancel$Finish viewing the current text"
                          );
        if (taste==0 || taste==2)
        {
           sc_gotoxy(1,one_config_set.sl-2); break;
        }
        j++;
      }

      /*
      nextkey03(&ix_stichw_rec_lokal);
      Ersetzung vom 16.01.1996
      */
      if(fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix03file)==0)
      {
          sc_gotoxy(1,one_config_set.sl);sc_clreol();sc_gotoxy(1,one_config_set.sl-1);
          beeps();
          wrtxt("[Unexpected ERROR in show_stichw(), cannot read more keywords]>");
          tastelesen();
          sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      }
      rec_zeiger = ix_stichw_rec_lokal.keywords_rptr;
      byte_zeiger = rec_zeiger * sizeof(one_stichw_rec);

      fseek(dat_stichw,byte_zeiger,SEEK_SET);
      fread(&one_stichw_rec,sizeof(one_stichw_rec),1,dat_stichw);
      if (strlen(suchmuster)>0)
      {
         strncpy(test_zeile,one_stichw_rec.keywordsfield,KEYWORDS_LEN);
         upper(test_zeile);
         if (is_substring(suchmuster,test_zeile))
         {
           sprintf(wrtxtbu,"%6li:  %-45s\n",i,one_stichw_rec.keywordsfield);
           wrtxt(wrtxtbu);
           j++;
           was_gelesen = 1;
         }
      }
      else
      {
         sprintf(wrtxtbu,"%6li:  %-45s\n",i,one_stichw_rec.keywordsfield);
         wrtxt(wrtxtbu);
         j++;
         was_gelesen = 1; // ??
      }
   }
   /* if ((j % 22)!=0) */
   sc_clreol();
   wrtxt("\n\n");
   close_ix03();
   fclose(dat_stichw);
   if (view_only==1) return -1L;
   if (!was_gelesen) return -1L;
   do
   {
      sc_gotoxy(1,one_config_set.sl-1);
      info_zeile("Enter number of KEYWORD - [Enter] or [Esc] Quit");
      strcpy(wrtxtbu,"KEYWORD no.........");
      wrtxt(wrtxtbu);
      taste = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  eingabe_zeile,
                  ZAHLSTRING_LEN,
                  ZAHLSTRING_LEN,
                  0
               );
      sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      string_in_long(eingabe_zeile,&ix_zeiger,&ok);
      if ((taste==ENTER_KEY && strlen(eingabe_zeile)==0) ||
           taste==ESC_KEY) break;
      if ((taste==ENTER_KEY) && (ok) && (ix_zeiger >= 0) &&
          (ix_zeiger <=anzahl_stichw))
         schleife_ok=1; else schleife_ok=0;
   } while (!schleife_ok);

   if (strlen(eingabe_zeile)==0)
   {
     strcpy(eingabe_zeile,"");
     return -1L;
   }
   if (taste==ESC_KEY)
   {
     strcpy(eingabe_zeile,"");
     return -1L;
   }

   return ix_zeiger;
}


void appendstring(char * stichw_zeile, long ix_zeiger)
{
   keylist_rec one_stichw_rec_lokal;
   keylistpix_rec ix_stichw_rec_lokal;
   long rec_zeiger, byte_zeiger;

   /* Bugfix 20.07.1997
       char zeile[KEYWORDS_LEN+3];
     ersetzt:
   */

   char zeile[KEYWORDS_LEN+4];

   if ((ix_stichw=fopen(stichw_pix_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot open %s",stichw_pix_name);
      beenden(fehlermeldung,2);
      // fcloseall();
      // exit (1);
   }
   if ((dat_stichw=fopen(stichw_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot open %s",stichw_name);
      beenden(fehlermeldung,2);
      // fcloseall();
      // exit (1);
   }
   byte_zeiger = ix_zeiger * sizeof(ix_stichw_rec_lokal);
   fseek(ix_stichw,byte_zeiger,SEEK_SET);
   fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix_stichw);
   rec_zeiger = ix_stichw_rec_lokal.keywords_rptr;
   byte_zeiger = rec_zeiger * sizeof(one_stichw_rec_lokal);
   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   fread(&one_stichw_rec_lokal,sizeof(one_stichw_rec_lokal),1,dat_stichw);

   if (strlen(stichw_zeile) > 0)
      strncpy(zeile,", ",KEYWORDS_LEN);
   else strncpy(zeile,"",KEYWORDS_LEN); // ergaenzt am 17.2.96
   /* Bugfix 20.07.1997:
      strlimcat(zeile,one_stichw_rec_lokal.keywordsfield,KEYWORDS_LEN+2);
      ersetzt durch:
   */
   strlimcat(zeile,one_stichw_rec_lokal.keywordsfield,KEYWORDS_LEN+3);
   /*
      Erlaeuterung: strlimcat() konkateniert nur, wenn die Summe beider
      Stringlanegen < maxl (nicht <= maxl) ist.
   */
   fclose(ix_stichw);
   fclose(dat_stichw);

   if (!strlimcat(stichw_zeile,zeile,DESC_ZEILE_LEN))
   {
      sprintf(wrtxtbu,"\n[KEYWORDS text was not prolonged to > %d characters]>",(int) DESC_ZEILE_LEN);
      wrtxt(wrtxtbu);
      tastelesen();
      sc_clreol();
      sc_gotoxy(1,one_config_set.sl-1);
      sc_clreol();
   }
}


void delete_keywords(long ix_zeiger)
{
   FILE * tmpix;
   char tmpix_name[150];
   char newix_name[150];

   int taste;
   keylistpix_rec     ix_stichw_rec_lokal;
   keylist_rec        one_stichw_rec_lokal;
   long rec_zeiger, byte_zeiger;



   strcpy(tmpix_name,"tmp_key.ix");
   strcpy(newix_name,"new_key.ix");

   taste = lotus_menu("Cancel$Do not delete keyword@"
                      "Ok$Keyword will be deleted");
   if (taste==0 || taste==1) return;


   read_ix03(stichw_pix_name);
   byte_zeiger = ix_zeiger * sizeof(ix_stichw_rec_lokal);
   fseek(ix03file,byte_zeiger,SEEK_SET);
   fread(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,ix03file);
   close_ix03();

   rec_zeiger = ix_stichw_rec_lokal.keywords_rptr;
   byte_zeiger = rec_zeiger * sizeof(one_stichw_rec_lokal);

   if ((dat_stichw=fopen(stichw_name,"r+b"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR: Cannot write into %s",stichw_name);
      beenden(fehlermeldung,2);
   }
   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   fread(&one_stichw_rec_lokal,sizeof(one_stichw_rec_lokal),1,dat_stichw);
   one_stichw_rec_lokal.in_use = 0;
   fseek(dat_stichw,byte_zeiger,SEEK_SET);
   fwrite(&one_stichw_rec_lokal,sizeof(one_stichw_rec_lokal),1,dat_stichw);
   fclose(dat_stichw);

   if ((tmpix = fopen(tmpix_name,"wb"))==NULL)
   {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
   }
   fwrite(&ix_stichw_rec_lokal,sizeof(ix_stichw_rec_lokal),1,tmpix);
   fclose(tmpix);

   deleteix03(stichw_pix_name,tmpix_name,newix_name);
   remove(stichw_pix_name); remove(tmpix_name);
   rename(newix_name,stichw_pix_name);
   return;
}
