/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/
#ifndef F1_FUN_H
#define F1_FUN_H

#define F1_ABOUT "  @\
REFERENCES 3.5, BIBLIOGRAPHIC SOFTWARE -- Copyright (C) V. Kiefel, 1995-2000@\
This software comes with ABSOLUTELY NO WARRANTY, for details read the file @\
`COPYING'. REFERENCES is free software, and you are welcome to redistribute it@\
under certain conditions: see `COPYING' for details."



#define F1_HAUPTMENU01 "HELP * Main menu@\
 @\
This screen gives you a short overview on the localization of the different@\
procedures in the program. For detailed information, please read the program@\
description files.@\
 @\
 Ŀ@\
  Option      allows you to...                                              @\
 Ĵ@\
  EditView    Enter new refences, edit references already existing in the   @\
              database, browse the complete database, view data defined     @\
              by a ('binary') batch file (*.BBT), enter keywords or journal @\
              names, enter abstract texts, view text files.                 @\
                                                                            @\
  ListR       Write references into a text file using a standard format or  @\
              formats defined by the user, write keywords and journal names @\
              into a text file.                                             @\
                                                                            @\
  BatchT      Work with batch files: batch files (batch tables) in two      @\
              forms: binary batch tables (named *.bbt) and text b. tables   @\
              (named  *.tbt). With batch files, you are able to define      @\
              subsets of records.                                           @\
                                                                            @\
  SearchR     Search references by keywords, authors' or editors' names,    @\
              document type, journal name, publisher, title of an article   @\
              or a book, year of publication, status character.             @\
                                                                            @\
  RefFormatD  Manage reference format definitions: edit, import, export,    @\
              duplicate, enter, reference format definitions.               @\
                                                                            @\
  Transfer    Prepare archives of the current database, export and import   @\
              data into/from archive files. Convert records into 'foreign'  @\
              file formats.                                                 @\
                                                                            @\
  FileSystem  Delete, rename references, restructure index files and the    @\
              complete database, edit text files, use the file manager,     @\
              verify database integrity, execute a DOS command from the OS  @\
              shell.                                                        @\
                                                                            @\
  Help        Read the help screens on different topics. Other help texts   @\
              are available directly from within various functions of the   @\
              program. More information is available in the documentation   @\
              text files.                                                   @\
                                                                            @\
  Quit        Finish REFERENCES the regular way. You must never turn off    @\
              the computer before closing the program with 'Quit'.          @\
 @"

#define F1_ALLGEMEINE_ELEMENTE "Elements of the REFERENCES user interface @\
 @\
Certain objects of the program for communication of the user with the database@\
files occur in different situations: @\
 @\
 Ŀ@\
  Item in UserInterface                                                   @\
  menu                   Description                                      @\
 Ĵ@\
  Menus                  Function: Selection of options of program        @\
                         functions, features of REFERENCES line menus     @\
                         are described.                                   @\
                                                                          @\
  InputLines             Function: Allow input of text. Keys for naviga-  @\
                         ting in and between input lines are described.   @\
                                                                          @\
  SelectFiles            Function: Selection of files for REFERENCES      @\
                         operation, features of the file selection screen @\
                         are described.                                   @\
                                                                          @\
  TextScreens            Function: Short information (including 'help').  @\
                                                                          @\
  EditingTextF           Functions: Editing abstracts texts for records,  @\
                         writing/editing TBT-files, reading log files,    @\
                         edit text format of format definitions;          @\
                         explains how an editor is made available to      @\
                         REFERENCES.                                      @\
                                                                          @\
  FileTypes              Explains the file types processed by REFERENCES. @\
                                                                          @\
  Colors                 Gives the table of color codes to be defined     @\
                         in the configuration file REFS.CFG.              @\
 @"

#define  F1_MEMUS_ALLGEMEIN "Line menus @\
 @\
You will find the menus in REFERENCES, Version 3.5 usually in the two bottom @\
lines of the screen. The upper menu line contains the menu options, one option@\
is always highlighted (option cursor). The lower menu line presents a brief @\
description of the highligted option. An example:@\
                                                                      @\
       FirstOption  SecondOpt  ThirdOpt  MoreOptions                  @\
       Description of the first option...                             @\
 @\
In order to select and activate an option, please move the option cursor with@\
the [LEFT] and [RIGHT] keys and press [ENTER]. In all menus, you can activate@\
an option by selecting the key corresponding to the first character of the @\
option (this is an alternative method). Everywhere you will encounter 'nested'@\
menus: i. e. after selecting one menu you will get into another menu which @\
gives you more options. In order to 'go back' to the previous menu, or to the@\
main menu, you should press [ESC].@\
 @\
The most rapid method to select menu items is to press the first character of@\
a menu option, the method of choice, if you search something, ist to highlight@\
the options with the [RIGHT] and [LEFT] keys and to read the descriptions."


#define  F1_EINGABEZEILE_ALLGEMEIN "Text input fields @\
 @\
In most situations, where new text is entered and existing data are edited in@\
REFERENCES, text input fields are used. They usually appear as dotted areas@\
on the screen. A field with 's is ready for editing or entering of text: @\
 @\
         @\
 @\
A field with brackets only shows text without permission to edit:@\
 @\
       () @\
 @\
All fields accept your input in the 'insert' or 'overwrite' mode (you may @\
toggle between the two modes with the [INSERT] key). Some fields accept text@\
lines which are longer the space shown on the screen. If you move to the right@\
end of these screens, the text is 'scrolled' through the field. You may@\
navigate within the fields and between fields with the following keys:@\
 @\
 Ŀ@\
   Key                         Function                                     @\
 Ĵ@\
   [ENTER], [DOWN], [PGDN],    Accepts the text in the current data entry   @\
   [TAB]                       field and opens the next field.              @\
                                                                            @\
   [UP], [PGUP], [SHIFT-TAB]   Accepts the current text and moves to the    @\
                               previous field.                              @\
                                                                            @\
   [CTRL-BACKSPACE]            Deletes the current data entry field.        @\
                                                                            @\
   [CTRL-RIGHT], [CTRL-LEFT]   Moves the cursor 5 characters right/left     @\
                               within the current field.                    @\
                                                                            @\
   [CTRL-HOME], [CTRL-END]     Moves to the first/last field in a data      @\
                               entry screen.                                @\
                                                                            @\
   [HOME], [END]               Moves the cursor to the first/last           @\
                               character in the current field.              @\
                                                                            @\
   [INSERT]                    Toggles between 'insert' and 'overwrite'     @\
                               editing modes.                               @\
                                                                            @\
   [ALT-C]                     Copies text into clipboard.                  @\
                                                                            @\
   [ALT-I]                     Inserts text from clipboard into current     @\
                               field.                                       @\
 @"


#define F1_DATEIAUSWAHL_ALLGEMEIN "File selection screens@\
 @\
If the program wants you to select an existing file, you will be presented a@\
file selection screen:@\
 @\
 @\
   [*.BBT] File selection                                                     @\
      1: ANSWER01.BBT    2: ANSWER02.BBT    3: NAIT1.BBT       4: NAIT2.BBT   @\
      5: NATURE.BBT      6: NATURE_.BBT     7: NN.BBT          8: NN1.BBT     @\
      9: SEARCH.BBT     10: STRUCT.BBT     11: ZZB.BBT                        @\
  @\
   File number........                                                  @\
   Please enter file number, range: 1..11                                     @\
 @\
 @\
Please select the file by entering the number assigned to the file name, to@\
to select the file 'NAIT2.BBT' you should enter '4' and the press [ENTER].@\
If there are more files than there is space on the screen, you are asked to@\
press only [ENTER] in order to show you the next screen. If you press [ENTER]@\
after presentation of the last screen the program concludes that you selected@\
no file and proceeds.@"

#define F1_TEXTANZEIGE_ALLGEMEIN "Text and help screens @\
 @\
In the BROWSE and EDIT funcions and in the different help screens, REFERENCES@\
allows you to view text with a normal word wrap. If a text is longer than the @\
screen, the menu: @\
 @\
     NextPage  Cancel  @\
     Show the next text page of text @\
 @\
is presented. This allows you to see the next page or to return to the previous@\
element of the user interface (text input field or menu). @\
 @\
In some functions short pieces of information are presented on screens with a@\
simple prompt:@\
 @\
     [..., please press any key]>@\
 @\
This technique is used to give you information on error conditions, problems,@\
successful completion of a task or to show you a short help screen. After @\
touching any key the program will proceed.@\
 "


#define F1_EDITIEREN_ALLGEMEIN "How to edit text files @\
 @\
REFERENCES uses unformatted text files to exchange information. Any text @\
editor including EDIT (MS-DOS) can be used with the REFERENCES software. The@\
only features it *should* have are:@\
                                                                         @\
    Ŀ @\
      The text editor used together with REFERENCES should accept the  @\
      file name to be opened as the first command line parameter and   @\
      should write 'pure' text files without formatting code to disk.  @\
     @\
                                                                         @\
The editor can be invoked from the OS prompt, you may change its default name @\
in the REFERENCES configuration file (REFS.CFG, default ist 'EDIT') with the @\
'EDITOR' variable in REFS.CFG.@\
 @\
For editing, REFERENCES writes a command file (a DOS batch file) to disk which@\
calls the editor with the text file to be editied. Default for this command @\
is 'TF.BAT' in the current database directory, you may change its name and@\
location by assigning the path to the 'CALL_EDITOR_COMMAND_FILE' variable in@\
REFS.CFG. An example for the pertinent lines in the REFS.CFG is:@\
 @\
       EDITOR=C:\\REFS35\\EDITOR\\PEDIT.EXE@\
       CALL_EDITOR_COMMAND_FILE=C:\\UTIL\\E.BAT@\
 @\
Text files will then be opened by calling 'E' from the OS prompt with PEDIT @\
if you execute commands as: 'FileSystem' 'EditText' or 'EditView', 'Abstracts'@\
or 'EditText'."



#define F1_DATEIEN_OBLIGATORISCH "Database and index files used by REFERENCES @\
 @\
Data of a REFERENCES Database are stored in a set of files, which must remain @\
complete, and must never be edited with another program, otherwise proper@\
function of the program is not guaranteed.@\
  @\
           Ŀ @\
              Data files     Index files    document types   @\
           Ĵ @\
              JOURNAL.DAT    JOURNAL.IX     j1, b1, b2       @\
              DESC.DAT       JOURNAL.IX     j1, b1, b2       @\
              AUTORJL.DAT    JOURNAL.IX     j1,     b2       @\
              AUTORBO.DAT    JOURNAL.IX         b1, b2       @\
              BOOK.DAT       JOURNAL.IX         b1, b2       @\
              SOURCE.DAT     SOURCE.IX      j1, b1, b2       @\
              KEYW.DAT       KEYW.IX        j1, b1, b2       @\
              ABST.DAT       ABST.IX        j1, b1, b2       @\
              FORMDEF.DAT    [no index f.]  j1, b1, b2       @\
            @\
 @\
  - JOURNAL.DAT contains titles of articles in books/journals, the code for @\
    document types (j1, b1 or b2), first and last page of a document, date@\
    (year of publication), edition no, the keywords field, and 'status' field,@\
    four-letter-code for journal, @\
   @\
  - DESC.DAT stores descriptions (keywords) assigned to a record,@\
   @\
  - AUTORJL.DAT contains lists of authors of articles in journals and in@\
    books,@\
   @\
  - AUTORBO.DAT contains lists of editors of books,@\
   @\
  - BOOK.DAT contains titles of books, place of publication, publisher,@\
   @\
  - SOURCE.DAT stores names of journals, linked to the JOURNAL.DAT file by@\
    the four-letter-code,@\
   @\
  - KEYW.DAT stores the `keywords-thesaurus',@\
   @\
  - FORMDEF.DAT stores definitions of user defined citation formats for @\
    generation of text files,@\
   @\
  - ABST.DAT contains the text of abstracts, notes of records. @\
  @\
INDEX FILES (IX) allow quick access to the contents of the DATABASE FILES@\
(DAT). If index file are damaged, they may be reconstructed from a complete@\
set of database files. The functions behind the 'FileSystem' 'Verify' command@\
check the integrity of the database."


#define F1_DATEIEN_FAKULTATIV "Optional files: @\
 @\
The following files are intended for communication between the database and@\
the user, they are not required by a 'minimal' REFERENCES database:@\
 @\
      Ŀ@\
        Type of file                      File name extension(s) @\
      Ĵ@\
        Binary batch table (binary)       BBT                    @\
        Text batch table (text)           TBT                    @\
        Archive file (text)               ARR                    @\
        Format definition transfer file   FD3                    @\
        Text files (text)                 TXT, ASC, DOC, TEX     @\
        Script files (text)               SCF                    @\
        Log files (text)                  LOG                    @\
      @\
 @\
 - BATCH FILES define subsets of records of a REFERENCES database. Two forms@\
   can be converted with the 'BBTtoText' and 'TextToBBT' functions.@\
 @\
    . TEXT BATCH TABLES (TBT) can be read and written by the user with the @\
      text editor.@\
 @\
    . BINARY BATCH TABLES (BBT) are directly processed by the program. They@\
      define subsets of database records. @\
 @\
 - ARCHIVE FILES (ARR) allow storage or transfer of a complete database or a@\
   subset of records in a database.@\
 @\
 - FORMAT DEFINITION FILES (FD3) store one format definition (binary files),@\
   they may be used for the exchange of format definitions between users. One@\
   or more format definitions may also be exported into a text file and read@\
   from a text file named FORMDEF.TXT.@\
 @\
 - The ListR functions of REFERENCES generate TEXT FILES (TXT) which can be@\
   read or imported by any word processor (text files). Other text files for@\
   different purposes (ASC, DOC, TEX) may be edited with the text editor. @\
 @\
 - SCRIPT files (SCF) are related to automation of functions, they contain @\
   instructions for the `search and replace' function.@\
 @\
 - LOG FILES (LOG) are written by the 'ListR', 'Transfer-Export' and other@\
   functions and contain messages about missing elements and error conditions@\
   (text files) or about (successful) completion of a task.@\
 @\
To create a new file you should use the 'FileSystem' 'FileManager' 'Create'@\
command. @"


#define F1_DOKUMENTENTYPEN "Document types processed by REFERENCES @\
 @\
REFERENCES allows you to process three different types of documents: @\
 @\
      Ŀ @\
        type    description                                         @\
      Ĵ @\
        j1      Article published in a periodical ('journal')       @\
                                                                    @\
        b1      Complete book or range of pages in a book           @\
                                                                    @\
        b2      Article or chapter in a book                        @\
       @\
 @\
 - An ARTICLE PUBLISHED IN A JOURNAL usually encompasses a list of authors @\
   (allowed: 1-999), a title, the year of publication, journal name, volume,@\
   page numbers (first page, last page), month, day of publication, issue @\
   number, International Standard Serial Number (ISSN). The j1 document type@\
   may also be used for abstracts published in a journal. @\
  @\
 - A COMPLETE BOOK includes a list of editors (allowed: 1-999), title of a@\
   book publisher, place of publication, date of publication (year), edition,@\
   International Standard Book Number (ISBN). You may also use the b1 @\
   document type to store a range of pages in a book.@\
  @\
 - A CHAPTER OR AN ARTICLE IN A BOOK includes a list of authors (article),@\
   a list of editors or authors of the book, the title of both the book and@\
   the chapter, range of pages within the book, publisher, place and date of @\
   publication, edition number, International Standard Book Number (ISBN). @"

#define F1_FARBEN "Selection of screen colors @\
 @\
Screen colors are determined by the 'COLORS' variable in REFS.CFG:@\
 @\
    Ŀ @\
            Normal text            Highlighted menu-opt.             @\
     Value Ĵ Comment   @\
            Text      Background   Text      Background              @\
    Ĵ @\
      0     white     black        black     light-gr.     (1)       @\
      1     white     blue         black     light-gr.               @\
      2     white     blue         white     magenta            (2)  @\
      3     white     blue         white     red                (2)  @\
      4     white     blue         white     cyan               (2)  @\
      5     light-gr. blue         white     magenta            (2)  @\
      6     yellow    blue         white     magenta            (2)  @\
      7     white     black        black     light-gr.     (1)  (2)  @\
      8     cyan      black        white     magenta            (2)  @\
      9     yellow    black        white     brown              (2)  @\
     10     white     cyan         white     magenta            (3)  @\
     11     blue      light-gr.    white     magenta            (3)  @\
     @\
  @\
(1) recommended options for monochrome systems, @\
(2) text input fields: black text on light-gray, (3) white text on blue@\
  @\
An example for the pertinent line in REFS.CFG:@\
 @\
      COLORS=4 @\
 @\
-> white text on blue background, highlighted menu option: white text on @\
cyan background.@"

#define F1_DOKUMENTATIONSDATEIEN "Documentation of REFERENCES in \
accompanying text files@\
 @\
 - Additional documentation appears in text files in the '[DRIVE:]\\REFS35\\DOC' @\
   directory. Text files with the extension GER are written in German, files @\
   with the extension ENG in English.@\
   @\
 - The help files can be viewed with the command: 'Help' 'SHelpF', which@\
   prompts you for a file selection screen. After opening the text file you@\
   may navigate through the text: @\
   @\
    Ŀ @\
     Menu option     Function                                            @\
    Ĵ @\
     NextPage        Proceeds to the next page without changing the      @\
                     address variable (see below)                        @\
                                                                         @\
     Rewind          Goes back to the beginning of the text file         @\
                     without changing the address variable (see below)   @\
                                                                         @\
     EnterLine       Prompts you for a line number (to be assigned to    @\
                     the address variable):                              @\
                       enter `#' to go to line # (absolute address)      @\
                       enter `+#' to proceed # lines,                    @\
                       enter `-#' to to go back # lines (relative a.)    @\
                                                                         @\
                     an example:                                         @\
                     '-22' shows you the previous page (if all lines     @\
                     in the actual range of pages are not longer than    @\
                     78 characters)                                      @\
                                                                         @\
     Go+|-Lines      Proceeds/goes back # lines as specified with the    @\
                     EnterLine command with `+#'/`-#', prompts you for   @\
                     a relative address, if an absolute address has      @\
                     been given to `EnterLine'. Both `EnterLine' and     @\
                     `Go+|-Lines' prompt you for the same address        @\
                     variable                                            @\
                                                                         @\
     Find            Prompts you for a TEXT to be searched for: the      @\
                     program will list those line numbers, where the     @\
                     TEXT occurred, you may then use `EnterLine' to      @\
                     jump to this line(s). You may use this function     @\
                     to search for a text fragment in the table of       @\
                     contents and to find the beginning of the chapter   @\
                     in the text (`Find' works case-sensitive!)          @\
     @\
   @\
 - The help files may also be read with the text editor (e. g. in another@\
   DOS-Window under a modern OS)@\
   @\
 - It is recommended to print important text files using the `Courier' text@\
   font or another font with fixed character width.@\
@"
#endif
