#include <stdio.h>
#include <string.h>

FILE * eins;
FILE * zwei;
long max_eins, max_zwei, min_max,i;

unsigned char c1, c2;
int nodiff;

char eins_name[200];
char zwei_name[200];


main(int argc, char * argv[])
{
   
   if (argc < 3)
   {
      printf("\nFCMP.EXE - binary comparison of two files\n");
      printf("\nUSAGE: FCMP FILE1 FILE2\n");
      printf("(c) V. Kiefel, 1995-1999\n");
      exit (1);
   }

   strcpy(eins_name,argv[1]); strcpy(zwei_name,argv[2]);
   if (!stricmp(eins_name,zwei_name))
   {
      fprintf(stderr,"A file is not compared to itself\n");
      exit(1);
   }
   if ((eins=fopen(eins_name,"rb"))==NULL)
   {
      fprintf(stderr,"Unable to open %s",eins_name);
      exit (1);
   }
   if (setvbuf(eins,NULL,_IOFBF,25000)!=0)
   {
      printf("failed to set up buffer for input of first file\n");
      /* fcloseall(); */
      exit(1);
   }

   if ((zwei=fopen(zwei_name,"rb"))==NULL)
   {
      fprintf(stderr,"Unable to open %s",zwei_name);
      /* fcloseall(); */
      exit (1);
   }
   if (setvbuf(zwei,NULL,_IOFBF,25000)!=0)
   {
      printf("failed to set up buffer for input of second file\n");
      /* fcloseall(); */
      exit(1);
   }
   fseek(eins,0L,SEEK_END); max_eins = ftell(eins)-1;rewind(eins);
   fseek(zwei,0L,SEEK_END); max_zwei = ftell(zwei)-1;rewind(zwei);
   if (max_zwei!=max_eins)
   {
     fprintf(stderr,"Different file lengths, files uncomparable\n");
     fclose(zwei);fclose(eins);
     exit(1);
   }
   nodiff = 1;
   printf("\nFCMP compares `%s' and `%s'\n",eins_name,zwei_name);
   for (i=0;i<=max_eins;i++)
   {
      unsigned char c1out, c2out;
      fread(&c1,1,1,eins);
      fread(&c2,1,1,zwei);
      if (c1!=c2)
      {
          nodiff = 0;
          if (c1>=32 && c1<=127) 
          {
             c1out=c1;
          } else
          {
             c1out='.';
          }
          if (c2>=32 && c2<=127) 
          {
             c2out=c2;
          } else
          {
             c2out='.';
          }
          printf("Offset %012li: %s: %03d [%c]  %s: %03d [%c]\n",
                i,eins_name,c1,c1out,zwei_name,c2,c2out);
      }
   }
   fclose(zwei);fclose(eins);
   if (nodiff) printf("No differences found by FCMP\n");
   return 0;
}
