/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/

/*
 * endline.c
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

 FILE * eins;
 FILE * zwei;
 int c1;

 char eins_name[200];
 char zwei_name[200];

void upper(char * sp);

int main(int argc, char * argv[])
{
   if ((argc < 3) || (!strcmp(argv[1],"/?")) || (!strcmp(argv[1],"-?")))
   {
      printf("\nENDLINE converts `UNIX-style end-of-line' [0x0A] into\n"
               "`MS-DOS-style end-of-line' [0x0D 0x0A] in text files.\n"
               "\n"
               "   Usage:       ENDLINE <infile> <outfile>\n"
               "   Example:     ENDLINE old.txt new.txt\n\n"
               "Copyright (c) V. Kiefel, 1997-2000\n");
      return 0;
   }


   strcpy(eins_name,argv[1]); strcpy(zwei_name,argv[2]);
   upper(eins_name);
   upper(zwei_name);

   if (!strcmp(eins_name,zwei_name))
   {
      fprintf(stderr,"\nERROR: a file is not converted to itself\n");
      exit(1);
   }

   if ((zwei=fopen(zwei_name,"rb"))!=NULL)
   {
      fprintf(stderr,"\nFile %s already exists\n",zwei_name);
      fclose(zwei);
      exit(1);
   }

   if ((eins=fopen(eins_name,"rt"))==NULL)
   {
      fprintf(stderr,"\nUnable to open %s\n",eins_name);
      exit (1);
   }

   if (setvbuf(eins,NULL,_IOFBF,25000)!=0)
   {
      printf("failed to set up buffer for input of first file\n");
      fclose(eins);
      exit(1);
   }

   if ((zwei=fopen(zwei_name,"wt"))==NULL)
   {
      fprintf(stderr,"\nUnable to open %s\n",zwei_name);
      fclose(eins);
      exit (1);
   }
   if (setvbuf(zwei,NULL,_IOFBF,25000)!=0)
   {
      printf("failed to set up buffer for input of second file\n");
      fclose(eins);
      fclose(zwei);
      exit(1);
   }
   printf("\nENDLINE converts %s into %s...\n",eins_name,zwei_name);
   for (;;)
   {
      c1 = fgetc(eins);
      if (c1==EOF) break;
      fputc(c1,zwei);
   }
   fclose(zwei);fclose(eins);
   return 0;
}

void upper(char * sp)
{
  int i;
  for (i = 0; i < strlen(sp) ; i++)
  {
    if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';
    else if (sp[i]=='') sp[i]='';

    sp[i] = toupper(sp[i]);
  }
  sp[i] = '\0';
}
