/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
 *    abst_fun.c -- management of abstract texts
 *
 *    (1) reads an abstract text file and writes it into the ABST.DAT
 *    database file;
 *
 *    (2) extracts an abstract text file and writes it into the ABSTRACT._T_
 *    text file.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <signal.h>
#include <conio.h>
#include "refs.h"
#include "fl_ut.h"
#include "l_menu.h"
#include "str_fun.h"
#include "abbruch.h"
#include "abstr.h"
#include "keycodes.h"
#include "ix01_fun.h"
#include "ix04_fun.h"
#include "sortix04.h"
#include "rfnr_fun.h"
#include "cfg_fun.h"


#define ZEILE_LEN 30600
#define MAX_BLOECKE 62
  /* 62 * 492 Zeichen lange strings koennen verwaltet werden */

#define ABSTR_DOC_MAX 2000000L
  /* groesse von abstr_doc_name, ab der zu loeschen aufgefordert wird */

#define ABST_DAT "ABST.DAT"
#define ABST_IX  "ABST.IX"
#define ABST_TXT "ABSTRACT._T_"
#define ABST_DOC "ABSTRACT.DOC"
#define TMP_REC_KEY "R_KEY.T"
 /* Textdatei mit der Kennziffer */
#define JOURNAL_IX "JOURNAL.IX"

#define AB01_IX "AB01.IX$"
#define AB02_IX "AB02.IX$"
  /* Temporaere Dateien beim Mergen*/
#define TITEL_ABS "REFERENCES VERSION 3.5 * VIEW-ENTER-EDIT ABSTRACT TEXT FILE"


 static char abstr_text_name[PFAD_LEN];
   /* Datei in die der zu bearbeitende Abstract geschrieben wird */
 extern char abstr_dat_name[PFAD_LEN];
 static char abstr_doc_name[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];
 extern char journal_pix_name[PFAD_LEN];
 extern char kennziff_temp_name[PFAD_LEN];
   /* Datei, die die temporaere Kennziffer enthaelt */
   /* in rfnr_fun.h vereinbart */

 static char kennziffer[KENNZIFFER_LEN + 1];
 static char * zeile;
 extern char fehlermeldung[250];

 static FILE * fpabstext;
 static FILE * fpabsdat;
 static FILE * fpabsdoc;

 extern FILE * fpkennzifftemp;
 /* in rfnr_fun.h vereinbart */
 extern FILE * ix04file;
 static FILE * fpab01ix;

 extern char wrtxtbu[WRTXTBU_LEN];

 extern config_set one_config_set;

 extern abstr_rec one_abstr_rec;
 extern abstrpix_rec ix04rec;
 extern refspix_rec ix01rec;

 int abst_fun_main(char * amodus, char * datpath);
 static unsigned int blocks_required(const char * abstract);
 static int textdatei_lesen(char * abstract);
 static int dat_datei_schreiben(char * abstract,char * kennziffer);
 static int dat_datei_lesen(char * abstract, char * kennziffer);

int abst_fun_main(char * amodus, char * datpath)
{
   long pos_zeiger;
   strcpy(abstr_text_name,datpath);
   strcat(abstr_text_name,ABST_TXT);
   strcpy(abstr_dat_name,datpath);
   strcat(abstr_dat_name,ABST_DAT);
   strcpy(abstr_pix_name,datpath);
   strcat(abstr_pix_name,ABST_IX);
   strcpy(kennziff_temp_name,datpath);
   strcat(kennziff_temp_name,TMP_REC_KEY);
   strcpy(journal_pix_name,datpath);
   strcat(journal_pix_name,JOURNAL_IX);
   strcpy(abstr_doc_name,datpath);
   strcat(abstr_doc_name,ABST_DOC);

   /* ersten Kommandozeilenparameter abfragen */
   if (strcmp(amodus,"-1")==0)
   {
       int loeschtaste;

       cls_line(TITEL_ABS);
       if (filesize(abstr_doc_name) > ABSTR_DOC_MAX)
       {
           sprintf(wrtxtbu,"Size of file '%s' > %li bytes, delete it?\n\n",
               abstr_doc_name,ABSTR_DOC_MAX);
           wrtxt(wrtxtbu);
           loeschtaste = lotus_menu(
                                    "@Cancel$Do not delete ABSTRACT.DOC"
                                    "@Delete$Delete ABSTRACT.DOC"
                                   );
           if (loeschtaste==2) remove(abstr_doc_name);
       }

       if (!isfile(abstr_pix_name))
       {
           sprintf(fehlermeldung,"Cannot read %s, please press any key",
                  abstr_pix_name);
           beenden(fehlermeldung,1);
       }
       /* Text aus abst.dat in abstract._t_ ueberfuehren */
       if (kennziffer_lesen(kennziffer))
       {
           kennziffer_schreiben(kennziffer);
           read_ix01(journal_pix_name);
           pos_zeiger=locate_ix01(kennziffer,&ix01rec);
           close_ix01();
           if (pos_zeiger==-1)
           {
               sprintf(wrtxtbu,"[No reference matching key '%s' found]>",
                      kennziffer);
               wrtxt(wrtxtbu);
               tastelesen();
               return 0;
           }
           if ((zeile = (char *) malloc ((ZEILE_LEN +1) * sizeof(char)))
                          ==NULL)
           {
               beenden("Memory allocation error ZEILE",2);
           }
           dat_datei_lesen(zeile, kennziffer);
           free(zeile);
           wrtxt("[Abstract text file may be edited with 'EditView' 'Abstracts' 'EditText']>");
           tastelesen();
       }

       /* else.. abbrechen */
   }
   else if (strcmp(amodus,"-2")==0)
   {
       /* Text aus abstract._t_ in abst.dat schreiben */
       cls_line(TITEL_ABS);
       if (!isfile(abstr_text_name))
       {
           wrtxt("\n[No text file to be entered into database]>");
           tastelesen();
           return 0;
       }
       if (!isfile(abstr_pix_name))
       {
           sprintf(fehlermeldung,"Cannot read %s, please press any key",
                abstr_pix_name);
           beenden(fehlermeldung,1);
       }
       if ((zeile = (char *) malloc ((ZEILE_LEN +1) * sizeof(char)))==NULL)
       {
           beenden("Memory allocation error ZEILE",2);
       }
       textdatei_lesen(zeile);
       if (kennziffer_lesen(kennziffer))
       {
           kennziffer_schreiben(kennziffer);
           read_ix01(journal_pix_name);
           pos_zeiger=locate_ix01(kennziffer,&ix01rec);
           close_ix01();
           if (pos_zeiger==-1)
           {
              sprintf(wrtxtbu,"[No reference matching key '%s' found]>",
                      kennziffer);
              wrtxt(wrtxtbu);
              tastelesen();
              free(zeile);
              return 0;
           }
           if (dat_datei_schreiben(zeile,kennziffer)==1)
           {
              cls_line(TITEL_ABS);
              wrtxt("\n[Abstract written into database]>");
              tastelesen();
           }
       }
       free(zeile);
   }

   return 0;
}



/*
   Bestimmt die Anzahl der fuer einen Abstract erforderlichen Datensaetze
*/

static unsigned int blocks_required(const char * abstract)
{
    unsigned int nb, i; /* nb Anzahl Bloecke */
    i = strlen(abstract);

    if (i==0) i++;
    nb = i / ABSTEXT_LEN;
    if ((i % ABSTEXT_LEN) != 0)
       nb++;
    return nb;
}


static int textdatei_lesen(char * abstract)
{
    unsigned int i, laenge;

    char zeichen;
    if ((fpabstext=fopen(abstr_text_name,"rt"))==NULL)
    {
       sprintf(fehlermeldung,"Cannot read %s",abstr_text_name);
       beenden(fehlermeldung,1);
    }
    i=0;
    do
    {
          zeichen=fgetc(fpabstext);
          if (zeichen!=EOF)
             abstract[i]=zeichen;
          else abstract[i] = '\0';
          i++;
          if (i>=ZEILE_LEN) break;
    } while (zeichen!=EOF);
    zeile[i]='\0';
    fclose(fpabstext);
    laenge=strlen(abstract);
    for (i=0;i<=laenge;i++)
    {
      if (abstract[i]=='\n')
      {
        abstract[i] = '\xfe';
      }
    }

    return 1;
}

static int dat_datei_schreiben(char * abstract, char * kennziffer)
{
    int i,j,k, anzahl_bloecke, anzahl_loeschen, lauf;
    long byte_zeiger, rec_zeiger, pos_zeiger;
    unsigned int laenge;
    int taste;
    char ze[2];
    int ii;

    sc_gotoxy(1,one_config_set.sl-9);
    wrtxt("Abstract: ");
    ii = 0;
    ze[0]='\0';
    ze[1]='\0';
    for (;;)
    {
      if (abstract[ii]=='\0') break;
      if (ii==50) break;
      if (abstract[ii]=='\xfe')
      {
         ze[0]='<';
      }
      else if (abstract[ii]=='\t')
      {
         ze[0]='>';
      }
      else
      {
         ze[0]=abstract[ii];
      }
      ze[1]='\0';
      wrtxt(ze);
      ii++;
    }
    if (ii>=50) wrtxt("...");

    sc_gotoxy(1,one_config_set.sl-7);
    sprintf(wrtxtbu,"Target reference number: %s",kennziffer);
    wrtxt(wrtxtbu);
    sc_gotoxy(1,one_config_set.sl-5);
    wrtxt("Please verify if the current abstract text file is now assigned to the\n"
          "correct reference number, otherwise it will overwrite the abstract of\n"
          "another record.");

    sc_gotoxy(1,one_config_set.sl-1);
    taste = lotus_menu(
        "@SaveAbstrText$Write the abstract text file into the database"
        "@Cancel$Do not copy the abstract text file into the into "
                 "the database"
                      );

    if (taste==2 || taste==0) return 0;
    i = 1;
    laenge = strlen(abstract);
    if (!isfile(abstr_dat_name))
    {
      if ((fpabsdat=fopen(abstr_dat_name,"wb"))==NULL)
      {
          sprintf(fehlermeldung,"ERROR: Cannot create %s",
                  abstr_dat_name);
          beenden(fehlermeldung,2);
      }
    } else
    {
      if ((fpabsdat=fopen(abstr_dat_name,"r+b"))==NULL)
      {
          sprintf(fehlermeldung,"ERROR: Cannot write into %s",
                  abstr_dat_name);
          beenden(fehlermeldung,2);
      }
    }
    if (!isfile(abstr_pix_name))
    {
      if ((ix04file=fopen(abstr_pix_name,"wb"))==NULL)
      {
          sprintf(fehlermeldung,"ERROR: Cannot create %s",
                  abstr_pix_name);
          beenden(fehlermeldung,2);
      }
      fclose(ix04file);
    }
    /* Index zum lesen oeffnen etc.. */
    memset(&ix04rec,0,sizeof(ix04rec));

    read_ix04(abstr_pix_name);
    pos_zeiger = locate_ix04(kennziffer,&ix04rec);
    close_ix04();


    anzahl_bloecke =  blocks_required(abstract);
    if (anzahl_bloecke > MAX_BLOECKE)
    {
       sprintf(wrtxtbu,"\n[Abstract text file contains > %i characters, will be "
              "truncated]>", ABSTEXT_LEN * MAX_BLOECKE);
       wrtxt(wrtxtbu);
       anzahl_bloecke = MAX_BLOECKE;
       tastelesen();
    }

      /*
         Datensatz noch nicht in DAT-Datei, neuer DS wird
         hinten angehaengt
      */
    if (pos_zeiger==-1)
    {
        fseek(fpabsdat,0L,SEEK_END);
        byte_zeiger=ftell(fpabsdat);
        rec_zeiger = byte_zeiger/sizeof(one_abstr_rec);

        strcpy(ix04rec.kennziffer,kennziffer);
        ix04rec.abstr_rptr = rec_zeiger;

        if ((fpab01ix=fopen(AB01_IX,"wb"))==NULL)
        {
           sprintf(fehlermeldung,"ERROR: cannot create %s",AB01_IX);
           beenden(fehlermeldung,1);
        }
        fwrite(&ix04rec,sizeof(ix04rec),1,fpab01ix);
        fclose(fpab01ix);
    }
    else
    {
      /*
        Datensatz bereits in DAT-Datei
      */
        rec_zeiger = ix04rec.abstr_rptr;
        byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
        fseek(fpabsdat,byte_zeiger,SEEK_SET);
        fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
        anzahl_loeschen = one_abstr_rec.abstr_n;
        fseek(fpabsdat,byte_zeiger,SEEK_SET);

          /*
             Datensatz bereits in DAT-Datei, belegt aber nun
             mehr Bloecke als bei der vorigen Eintragung
          */
         memset(&one_abstr_rec,0,sizeof(one_abstr_rec));
         for (lauf=1;lauf<=anzahl_loeschen;lauf++)
         {
            fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
         }

        if (anzahl_bloecke > anzahl_loeschen)
        {
           fseek(fpabsdat,0L,SEEK_END);
        }
        else
        {
           fseek(fpabsdat,byte_zeiger,SEEK_SET);
        }
        byte_zeiger=ftell(fpabsdat);
        rec_zeiger = byte_zeiger/sizeof(one_abstr_rec);
        if (anzahl_bloecke > anzahl_loeschen)
        {
          strcpy(ix04rec.kennziffer,kennziffer);
          ix04rec.abstr_rptr = rec_zeiger;
          read_write_ix04(abstr_pix_name);
          fseek(ix04file,(long) pos_zeiger * sizeof(ix04rec),SEEK_SET);
          strcpy(ix04rec.kennziffer,kennziffer);
          ix04rec.abstr_rptr = rec_zeiger;
          fwrite(&ix04rec,sizeof(ix04rec),1,ix04file);
          close_ix04();
        }
    }


    j = 0; /* Adresse in abstract */
    for (i=1;i<=anzahl_bloecke;i++)
    {
         memset(&one_abstr_rec,'\0',sizeof(one_abstr_rec));
         one_abstr_rec.in_use=1;
         one_abstr_rec.abstr_i=i;
         one_abstr_rec.abstr_n=anzahl_bloecke;
         strcpy(one_abstr_rec.kennziffer,kennziffer);
         k = 0; /* Adresse in one_abstr_rec.abs_text */
         for (k=0;k < ABSTEXT_LEN;k++)
         {
           if (j<laenge)
           {
             one_abstr_rec.abs_text[k] = abstract[j++];
           }
         }
         fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
    }
    fclose(fpabsdat);

    /* Hier noch die Option anhaengen ermoeglichen */

    if (isfile(AB01_IX))
    {
      /* Beginn Einfuegung vom 20.06.1997 */
      if (filesize(abstr_pix_name)==0)
      {
        remove(abstr_pix_name);
        rename(AB01_IX,abstr_pix_name);
        wrtxt("\nIndex file for abstracts created...");
      }
      /* Ende Einfuegung vom 20.06.1997 nach 'else' in folg. Zeile */
      else if (ok_appix04(abstr_pix_name,AB01_IX))
      {
        appendix04(abstr_pix_name,AB01_IX);
        remove(AB01_IX);
        wrtxt("\nIndex file for abstracts appended...");
      }
      else
      {
        mrgeix04(abstr_pix_name,AB01_IX,AB02_IX);
        remove(abstr_pix_name);remove(AB01_IX);
        rename(AB02_IX,abstr_pix_name);
        wrtxt("\nIndex file for abstracts merged...");
      }
      /* tastelesen(); */
    }
    return 1;
}

static int dat_datei_lesen(char * abstract, char * kennziffer)
{
    long rec_zeiger, byte_zeiger, pos_zeiger;
    int i, anzahl_records;
    unsigned int laenge;

    read_ix04(abstr_pix_name);
    pos_zeiger=locate_ix04(kennziffer,&ix04rec);
    close_ix04();

    if (pos_zeiger==-1)
    {
       sprintf(abstract,"%s\n",kennziffer);
    } else
    {
       strcpy(abstract,"");
       rec_zeiger=ix04rec.abstr_rptr;
       byte_zeiger=rec_zeiger * sizeof(one_abstr_rec);
       if ((fpabsdat=fopen(abstr_dat_name,"rb"))==NULL)
       {
           sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",
                   abstr_dat_name);
           beenden(fehlermeldung,2);
       }
       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);

       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       anzahl_records=one_abstr_rec.abstr_n;
       for (i=1;i<=anzahl_records;i++)
       {
          if (i > MAX_BLOECKE)
          {
            wrtxt("[Unexpected LOOP-ERROR in 'dat_datei_lesen()', "
                   "please inform program author]>");
            fclose(fpabsdat);
            tastelesen();
            break;
          }
          fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
          strcat(abstract,one_abstr_rec.abs_text);

       }
       fclose(fpabsdat);
    }


    laenge = strlen(abstract);
    for (i=0;i<laenge;i++)
    {
       if (abstract[i]=='\xfe')
          abstract[i]= '\n';
    }

    if ((fpabstext=fopen(abstr_text_name,"wt"))==NULL)

    {
          sprintf(fehlermeldung,"Cannot create %s",abstr_text_name);
          beenden(fehlermeldung,1);
    }

    if ((fpabsdoc=fopen(abstr_doc_name,"a"))==NULL)
    {
        sprintf(fehlermeldung,"ERROR: cannot create %s",abstr_doc_name);
        beenden(fehlermeldung,1);
    }

    fprintf(fpabstext,"%s",abstract);
    fprintf(fpabsdoc,"%s\n***\n",abstract);

    fclose(fpabstext);
    fclose(fpabsdoc);
    return 1;
}
