// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Simple test program demonstrating the basic operation of the
vbThread class using semaphores
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <stdlib.h>
#include "vbthread.h"
#include "vbsema.h"

// Global semaphores objects
vbSemaphore child_counter;
vbSemaphore parent_counter;

// Class derived from the abstract vbThread base class 
class MessageClass : public vbThread
{
public:
  MessageClass() { }
  ~MessageClass() { }
  
public:
  char *message;

private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

void *MessageClass::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << message << endl << flush;

  // The up operation increments the semaphore
  parent_counter.SemaphorePost();
  child_counter.SemaphorePost();
  return 0;
}

int main()
{
  MessageClass t;

  char *message1 = "Test message 1";
  char *message2 = "Test message 2";

  parent_counter.SemaphoreWait(); 
  
  child_counter--; // Semaphore value now 0 
  child_counter--; // Semaphore value now -1
  
  // The child_counter now must be incremented 2 times 
  // for a thread blocked on it to be released 
  
  t.message = message1;
  t.CreateThread();
  
  // The wait operation blocks the thread if the semaphore
  // has a value less than or equal to zero.
  parent_counter.SemaphoreWait();
  
  t.message = message2;
  t.CreateThread();
  
  // Force the parent thread to block until both children have
  // printed their message and executed the following semaphore
  // up function.
  child_counter.SemaphoreWait();
  
  // Wait for the last thread to print its message  before exiting
  t.sSleep(1);

  cout << endl;

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

