// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbsocket.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbSocket class is used to create TCP/IP sockets. The vbSocket
class supports stream sockets and datagram sockets It includes
several low-level functions needed by derived classes to establish
communication end-points and transfer data.
*/
// ----------------------------------------------------------- //   
#ifndef __VBSOCKET_HPP__
#define __VBSOCKET_HPP__

#include "vbstypes.h"

// vbSocket class 
class vbSocket
{
public:
  vbSocket(); 
  vbSocket(vbsSocket_t st, vbsPort_t port, char *hostname = 0); 
  virtual ~vbSocket();
  
private: // Disallow copying and assignment
  vbSocket(const vbSocket &ob) { }
  void operator=(const vbSocket &ob) { }
  
public: // Functions used to set the socket parameters
  void SetAddressFamily(vbsAddressFamily af) { address_family = af; }
  void SetProtocolFamily(vbsProtocolFamily pf) { protocol_family = pf; }
  vbsProtocolFamily GetProtocolFamily() { return protocol_family; }
  void SetSocketType(vbsSocket_t st) { socket_type = st; }
  vbsSocket_t GetSocketType() { return socket_type; }
  void SetPortNumber(vbsPort_t p) { port_number = p; }
  vbsSocket_t GetBoundSocket() { return vbsocket; } 
  vbsSocket_t GetSocket() { return vbsocket; }  
  vbsSocket_t GetRemoteSocket() { return remote_socket; }
  
public: // Socket functions
  vbsSocket_t Socket();
  vbsSocket_t InitSocket(vbsSocket_t st, int port, char *hostname = 0);
  void Close();
  void Close(vbsSocket_t s);
  void CloseSocket();
  void CloseRemoteSocket();
  int Bind();
  int Connect();
  vbsSocket_t Accept();
  int Listen(int max_connections = SOMAXCONN);
  int Recv(void *buf, int bytes, int flags = 0);
  int Recv(vbsSocket_t s, void *buf, int bytes, int flags = 0);
  int Send(const void *buf, int bytes, int flags = 0);
  int Send(vbsSocket_t s, const void *buf, int bytes, int flags = 0);
  int RemoteRecv(void *buf, int bytes, int flags = 0);
  int RemoteSend(const void *buf, int bytes, int flags = 0);
  int RawRead(void *buf, int bytes, int flags = 0);
  int RawRead(vbsSocket_t s, void *buf, int bytes, int flags = 0);
  int RawRemoteRead(void *buf, int bytes, int flags = 0);
  int RawWrite(const void *buf, int bytes, int flags = 0);
  int RawWrite(vbsSocket_t s, const void *buf, int bytes, int flags = 0);
  int RawRemoteWrite(const void *buf, int bytes, int flags = 0);
  void ResetRead() { bytes_read = 0; }
  void ResetWrite() { bytes_moved = 0; } 
  void ShutDown(int how = 0);
  void ShutDown(vbsSocket_t s, int how = 0);
  void ShutDownSocket(int how = 0);
  void ShutDownRemoteSocket(int how = 0);
  int GetSockName();
  int GetServByName(char *name, char *protocol = 0);
  int GetServByPort(int port, char *protocol = 0); 
  int GetPortNumber(); 
  int GetRemotePortNumber();
  int GetHostName(char *hs);
  int GetRemoteHostName(char *hs);
  void GetClientInfo(char *client_name, int &r_port);
  vbsAddressFamily GetAddressFamily();
  vbsAddressFamily GetRemoteAddressFamily();
  
  // Process control functions
  int BytesRead() { return bytes_read; }
  int BytesMoved() { return bytes_moved; }
  int IsConnected() { return is_connected == 1; }
  int IsBound() { return is_bound == 1; }

  // Datagram functions
  int RecvFrom(vbsSocket_t s, vbsSocketAddress *sa, void *buf,
	       int bytes, int flags = 0);
  int SendTo(vbsSocket_t s, vbsSocketAddress *sa, void *buf,
	     int bytes, int flags = 0);
  int RawReadFrom(vbsSocket_t s, vbsSocketAddress *sa, void *buf,
		  int bytes, int flags = 0);
  int RawWriteTo(vbsSocket_t s, vbsSocketAddress *sa, void *buf,
		 int bytes, int flags = 0);
  int RecvFrom(void *buf, int bytes, int flags = 0);
  int SendTo(void *buf, int bytes, int flags = 0);
  int RawReadFrom(void *buf, int bytes, int flags = 0);
  int RawWriteTo(void *buf, int bytes, int flags = 0);

  // Exception handling functions
  vbsSocketError GetSocketError() { return socket_error; }
  vbsSocketError GetSocketError() const { return socket_error; }
  void SetSocketError(vbsSocketError err) { socket_error = err; }
  void ResetSocketError() { socket_error = vbSOCKET_NO_ERROR; }
  void ResetError() { socket_error = vbSOCKET_NO_ERROR; }
  const char *SocketExceptionMessage();
  
  // Platform specific initialization functions
  int InitSocketLibrary();
  int ReleaseSocketLibrary();

public: // Overloaded operators
  int operator!() const { return socket_error != vbSOCKET_NO_ERROR; }
  int operator!() { return socket_error != vbSOCKET_NO_ERROR; }
  operator const int () const { return socket_error == vbSOCKET_NO_ERROR; }
  operator int () { return socket_error == vbSOCKET_NO_ERROR; }

protected: // Socket variables 
  vbsAddressFamily address_family;   // Object's address family
  vbsProtocolFamily protocol_family; // Object's protocol family
  vbsSocket_t socket_type;           // Object's socket type
  vbsPort_t port_number;             // Object's port number
  vbsSocket_t vbsocket;              // Socket this object is bound to
  vbsSocket_t remote_socket;         // Socket used for remote connections
  vbsSocketError socket_error;       // The last reported socket error

protected: // Process control variables
  int bytes_read;   // Number of bytes read following a read operation
  int bytes_moved;  // Number of bytes written following a write operation
  int is_connected; // True if the socket is connected
  int is_bound;     // True if the socket is bound
  
public: // Data structures used to set the internet domain and addresses
  vbsSocketAddress sin;        // Sock Internet address
  vbsSocketAddress remote_sin; // Remote socket Internet address
  vbsHostNameInfo *hostnm;     // Host name information
  vbsServent *sp;              // Service name and protocol information

public:  // Platform specfic library extensions
  vbsSocketLibraryVersion socket_version; 

#if defined (__WIN32__)
  WSADATA socket_data; 
#endif
};

#endif // __VBSOCKET_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
