// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Test program demonstrating how to cancel a long-running thread.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"

class SimpleThread : public vbThread
{
public:
  SimpleThread() { }
  ~SimpleThread() { }
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
  void ThreadCleanupHandler(vbThread_t *thread);
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << endl;
  cout << "Executing thread..." << endl;
  while (1) {
    cout << "Thread: Looping through a long running request" << endl;
    sSleep(1);
   }
  return 0;
}

void SimpleThread::ThreadCleanupHandler(vbThread_t *thread)
{
  cout << "Executing clean up routine..." << endl;
  cout << endl;
}

int main()
{
  SimpleThread t;

  vbThread_t *thread = t.CreateThread();
 
  // Wait until we realize the thread needs to be canceled
  t.sSleep(3);
  t.CancelThread(thread);
 
  // Wait for the thread to complete, and release its resources
  t.JoinThread(thread);

  if(thread->GetThreadState() == vbTHREAD_STATE_CANCELED) {
    cout << "The thread was canceled" << endl;
  }
  else {
    cout << "The thread was not canceled" << endl;
  }

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

