// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: server.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/14/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to the vbStream class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include "vbstream.h"

int ReadBlock(vbStream *server, vbBlockHeader &vb)
{
  cout << "Reading a raw block of data" << endl;
  
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadRemoteBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << buf;
  cout << server->BytesRead() << " bytes received." << endl;
  
  delete buf;
  return 0;
}

int AnswerRequest(vbStream *server, vbBlockHeader &vb)
{
  cout << "Client has requested a block" << endl;
 
  char *test_block = "The quick brown fox jumps over the lazy dog \
0123456789\n";

  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadRemoteBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested block: " << buf << endl;
  delete buf;

  cout << "Answering request" << endl;
  
  if(server->WriteRemoteBlock((char *)test_block, strlen(test_block))
			      != 0) return 1;
  return 0;
}

int ChangeBlock(vbStream *server, vbBlockHeader &vb)
{
  cout << "Received a change block request" << endl;
 
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadRemoteBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client requested that block \"" << buf << "\" be changed to:" 
       << endl << flush;
  delete buf;

  vbBlockHeader block_header;
  if(server->ReadClientHeader(block_header) != 0) return 1;

  char *block = new char[(__ULWORD__)block_header.block_length];
  if(server->ReadRemoteBlock((char *)block, block_header) != 0) return 1;

  block[(__ULWORD__)block_header.block_length] = 0;
  cout << block << flush;

  delete block;
  return 0;
}

int AddBlock(vbStream *server, vbBlockHeader &vb)
{
  cout << "Received an add block request" << endl;
  
  char *block = new char[(__ULWORD__)vb.block_length];
  if(server->ReadRemoteBlock(block, vb) != 0) return 1;

  block[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested the following block be added:" << endl;
  cout << block << flush;
  delete block;
  
  return 0;
}

int DeleteBlock(vbStream *server, vbBlockHeader &vb)
{
  cout << "Received a delete block request" << endl;
  
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadRemoteBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested block \"" << buf << "\" be deleted" << endl;
  delete buf;
  
  return 0;
}

int main(int argc, char **argv)
{
  // Check arguments. Should be only one: the port number to bind to.
  if(argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl;
    return 1;
  }

  vbStream server;
  vbsSocket_t remote_socket;
  unsigned short port = (unsigned short) atoi(argv[1]);

  cout << "Initializing the VB stream server..." << endl;
  if(server.StreamServer(port) != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  
  // Get the host name assigned to this machine
  char hostname[vbsMAX_NAME_LEN];
  if(server.HostName(hostname) != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  cout << "Opening stream server on host " << hostname << endl;
    
  while(1) { // Block until the next read. 
    cout << "Listening on port " << port << endl;
    remote_socket = server.Accept();

    if(remote_socket < 0) {
      cout << server.SocketExceptionMessage() << endl;
      return 1;
    }
    
    // Read the block following a client connection
    vbBlockHeader vb;
    if(server.ReadClientHeader(vb) != 0) {
      cout << server.SocketExceptionMessage() << endl;
      return 1;
    }

    // Get the client info
    char client_name[vbsMAX_NAME_LEN]; int r_port = -1;
    server.GetClientInfo(client_name, r_port);
    cout << client_name << " connecting on port " << r_port << endl;

    // Read the status byte to determine what to do with this block
    __ULWORD__ block_status = vb.block_status;
    __SBYTE__ status = (__SBYTE__)((block_status & 0xFF00)>>8);

    switch(status) { 
      // Process each block of data
      case vbAcknowledgeBlock:
	cout << "Received an acknowledge block command" << endl;
	cout << "Sending acknowledgment" << endl;
	if(server.WriteRemoteAckBlock() != 0)
	  cout << server.SocketExceptionMessage() << endl;	  
	server.CloseRemoteSocket();
	break;

      case vbAddRemoteBlock:
	if(AddBlock(&server, vb) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case vbChangeRemoteBlock:
	if(ChangeBlock(&server, vb) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case vbRequestBlock:
	if(AnswerRequest(&server, vb) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case vbDeleteRemoteBlock:
	if(DeleteBlock(&server, vb) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case vbSendBlock :  
	if(ReadBlock(&server, vb) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case vbCloseConnection : 
	cout << "Client sent a close connection command" << endl;
	server.CloseRemoteSocket();
	break;

      case vbKillServer:
	cout << "Client shutdown the server" << endl;
	server.Close();
	return 0;
	
      default:
	cout << "Received bad block command from client" << endl;
	server.CloseRemoteSocket();
	break;
    }
  }

  cout << "Exiting..." << endl;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
