// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: client.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to demonstrate how to stream variable blocks
across a network connection.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "vbstream.h"
#include "dbobject.h"

void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void InputName(const char *mesg, DatabaseObjectData &dbobject)
{
  cout << mesg;
  char buf[vbMaxNameLength];
  for(unsigned i = 0; i < vbMaxNameLength; i++) buf[i] = 0;
  cin >> buf;
  strcpy(dbobject.name, buf);
}

void DisplayDatabaseObject(DatabaseObjectData &dbobject, int full = 1)
{
  cout << endl;
  cout << "Database object name: " << dbobject.name << endl;
  if(full) {
    cout << "Database object OID:  " << dbobject.oid << endl;
    cout.setf(ios::showpoint | ios::fixed);
    cout.precision(3);
    cout << "Database object CID:  " << dbobject.cid << endl;
    cout << endl;
  }
}

void PrgMenu()
{
  cout << endl;
  cout << "(a, A)    Add an object to the database" << endl;
  cout << "(c, C)    Change an object in the database" << endl;
  cout << "(d, D)    Delete an object in the database" << endl;
  cout << "(f, F)    Find an object in the database" << endl;
  cout << "(h, H, ?) Help (prints this menu)" << endl;
  cout << "(k, K)    Shutdown the server" << endl;
  cout << "(q, Q)    Quit this program" << endl;
  cout << endl;
}

void DeleteObject(int port, char *host)
{
  vbStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Deleting an object from the database" << endl;
  DatabaseObjectData dbobject;
  ClearInputStream(cin);
  InputName("Enter the name of the object to delete: ", dbobject);

  vbBlockHeader vb;
  vb.block_length = sizeof(DatabaseObjectData);

  if(client.DeleteBlock((char *)&dbobject, vb) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void AddObject(int port, char *host)
{
  vbStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  DatabaseObjectData dbobject;
  ClearInputStream(cin);
  InputName("Enter the name of the new object: ", dbobject);
  int id;
  double cid;

  cout << "Enter the objects's id number: ";
  cin >> id;
  if(cin) {
    dbobject.oid = id;
    cout << "Enter the object's class id number: ";
    cin >> cid;
  } 
  else {
    cout << "Invalid entry. Object not added!" << endl;
    return;
  }
  if(cin) {
    dbobject.cid = cid;
  }
  else {
    cout << "Invalid entry. Object not added!" << endl;
    return;
  }
  
  ClearInputStream(cin);

  cout << "Sending a request to add the object" << endl;

  vbBlockHeader vb;
  vb.block_length = sizeof(DatabaseObjectData);

  if(client.AddBlock((char *)&dbobject, vb) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void ChangeObject(int port, char *host)
{
  vbStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Changing and object in the database" << endl;
  DatabaseObjectData dbobject;
  ClearInputStream(cin);
  InputName("Enter the name of the object to change: ", dbobject);

  DatabaseObjectData new_dbobject_info;
  InputName("Enter the object's new name: ", new_dbobject_info);
  int id;
  double cid;

  cout << "Enter the object's new ID number: ";
  cin >> id;
  if(cin) {
    new_dbobject_info.oid = id;
    cout << "Enter the object's new class ID: ";
    cin >> cid;
  } 
  else {
    cout << "Invalid entry. Object not added!" << endl;
    return;
  }
  if(cin) {
    new_dbobject_info.cid = cid;
  }
  else {
    cout << "Invalid entry. Object not added!" << endl;
    return;
  }
  
  ClearInputStream(cin);
  
  vbBlockHeader request_header;
  request_header.block_length = sizeof(DatabaseObjectData);

  vbBlockHeader block_header;
  block_header.block_length = sizeof(DatabaseObjectData);

  if(client.ChangeBlock((char *)&dbobject, (char *)&new_dbobject_info, 
			request_header, block_header) != 0) 
    cout << client.SocketExceptionMessage() << endl;

  client.Close();
}

void ShutDownServer(int port, char *host)
{
  vbStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Shutting down the server..." << endl;
  if(client.TerminateConnection() != 0) 
    cout << client.SocketExceptionMessage() << endl;
  client.Close();
}

void FindObject(int port, char *host)
{
  vbStream client;
  if(client.StreamClient(port, host) != 0) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }

  cout << "Searching the database" << endl;
  DatabaseObjectData dbobject;
  ClearInputStream(cin);
  InputName("Enter the name of the object to find: ", dbobject);

  vbBlockHeader request_header;
  request_header.block_length = sizeof(DatabaseObjectData);
  vbBlockHeader requested_block_header;
  request_header.block_length = sizeof(DatabaseObjectData);

  DatabaseObjectData *p = \
    (DatabaseObjectData *)client.RequestBlock((char *)&dbobject,
					      request_header,
					      requested_block_header);
  if(!p) {
    cout << client.SocketExceptionMessage() << endl;
    client.Close();
    return;
  }
  cout << "Server has answered request" << endl;
  if(p->name[0] == 0) {
    cout << "The dbobject was not found in the database" << endl;
  }
  else {
    cout << "Found the requested object: " << endl;
    DisplayDatabaseObject(*(p));
  }
    
  client.Close();
}

int main(int argc, char **argv)
{
  if(argc < 3) {
    cerr << "Usage: " << argv[0] << " hostname port" << endl;
    return 1;
  }

  unsigned short port = (unsigned short) atoi(argv[2]);
  char *host = argv[1];

  char key;
  PrgMenu();
  int rv = 1;
  while(rv) {
    if (!cin) { 
      ClearInputStream(cin); 
      if (!cin) { 
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; 
    switch(key) {
      case '?' : PrgMenu(); break;
      case 'h' : case 'H' : PrgMenu(); break;
      case 'q' : case 'Q' : rv = 0; break;

      case 'a' : case 'A' : 
	AddObject(port, host);
	break;
      case 'c' : case 'C' : 
	ChangeObject(port, host);
	break;
      case 'd' : case 'D' :  
	DeleteObject(port, host);
	break;
      case 'f' : case 'F' :
	FindObject(port, host);
	break;
      case 'k' : case 'K' : 
	ShutDownServer(port, host);
	break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }
 
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
