// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbuint64.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbUINT64 class is used to represent 64 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 64-bit value into eight separate byte
values and reordering the bytes lowest-order to highest-order.
A vbUINT64 type has a base 10 limit of 18446744073709551615.
*/
// ----------------------------------------------------------- // 

#include "vbuint64.h"

#ifndef __USE_NATIVE_INT_TYPES__ 

#include <string.h>
#include <ctype.h>
#include <iomanip.h>
#include <memory.h>

vbUINT64::vbUINT64(__ULLWORD__ val)
{
  UnPackBits(val);
}

vbUINT64::vbUINT64(const vbUINT64& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 8);
}

vbUINT64& vbUINT64::operator=(const vbUINT64& ob)
{
  memmove((void *)byte, (const void *)ob.byte, 8);
  return *this;
}

vbUINT64& vbUINT64::operator=(const __ULLWORD__ val)
{
  UnPackBits(val);
  return *this;
}

vbUINT64::operator __ULLWORD__() const
{
  return PackBits();
}

__ULLWORD__ vbUINT64::PackBits() const
{
  __ULLWORD__ a, b, c, d, e ,f, g, h;
  
  a = (__ULLWORD__)byte[0];
  b = (__ULLWORD__)byte[1];
  c = (__ULLWORD__)byte[2];
  d = (__ULLWORD__)byte[3];
  e = (__ULLWORD__)byte[4];
  f = (__ULLWORD__)byte[5];
  g = (__ULLWORD__)byte[6];
  h = (__ULLWORD__)byte[7];

  a = a & 0xFF;
  b = (b<<8) & 0xFF00;
  c = (c<<16) & 0xFF0000;
  d = (d<<24) & 0xFF000000;
  e = (e<<32) & 0xFF00000000;
  f = (f<<40) & 0xFF0000000000;
  g = (g<<48) & 0xFF000000000000;
  h = (h<<56) & 0xFF00000000000000;
  return a + b + c + d + e + f + g + h;
}

void vbUINT64::UnPackBits(__ULLWORD__ val)
{
  byte[0] = (__SBYTE__)(val & 0xFF);
  byte[1] = (__SBYTE__)((val & 0xFF00)>>8);
  byte[2] = (__SBYTE__)((val & 0xFF0000)>>16);
  byte[3] = (__SBYTE__)((val & 0xFF000000)>>24);
  byte[4] = (__SBYTE__)((val & 0xFF00000000)>>32);
  byte[5] = (__SBYTE__)((val & 0xFF0000000000)>>40);
  byte[6] = (__SBYTE__)((val & 0xFF000000000000)>>48);
  byte[7] = (__SBYTE__)((val & 0xFF00000000000000)>>56);
}

vbUINT64 vbUINT64::operator++(int) // Postfix
{
  vbUINT64 val_before(*this); 
  operator=(*this + 1);
  return val_before;
}
 
vbUINT64 vbUINT64::operator--(int) // Postfix
{
  vbUINT64 val_before(*this); 
  operator=(*this - 1);
  return val_before;
}

void vbUINT64::operator/=(const vbUINT64 &i)
{
  if(i == (vbUINT64)0) return; // Divide by zero error
  operator=(*this / i);
}

void vbUINT64::operator/=(const __LLWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __ULLWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / i);
}

void vbUINT64::operator/=(const __LWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / i);
}

void vbUINT64::operator/=(const __ULWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __WORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __SWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __UWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __USWORD__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __SBYTE__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

void vbUINT64::operator/=(const __UBYTE__ &i)
{
  if(i == 0) return; // Divide by zero error
  operator=(*this / (__ULLWORD__)i);
}

int operator==(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() == b.PackBits();
}

int operator==(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl;
}

int operator==(const __LWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits();
}

int operator==(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __SWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __USWORD__ &bl)
{
  return  a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __USWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator==(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl;
}

int operator==(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits(); 
}

int operator!=(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() != bl;
}

int operator!=(const __LWORD__ &al, const vbUINT64 &b)
{
  return al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __SWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __USWORD__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __USWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator!=(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() != (__ULLWORD__)bl;
}

int operator!=(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al != b.PackBits();
}

int operator<(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() < b.PackBits();
}

int operator<(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() < bl;
}

int operator<(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al < b.PackBits();
}

int operator<(const __LWORD__ &al, const vbUINT64 &b)
{
  return al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __SWORD__ &al, const vbUINT64 &b)
{
  return al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __USWORD__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __USWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator<(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() < (__ULLWORD__)bl;
}

int operator<(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al < b.PackBits();
}

int operator>(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() > b.PackBits();
}

int operator>(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() > bl;
}

int operator>(const __LWORD__ &al, const vbUINT64 &b)
{
  return al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __SWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __USWORD__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __USWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator>(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() > (__ULLWORD__)bl;
}

int operator>(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al > b.PackBits();
}

int operator<=(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() < bl;
}

int operator<=(const __LWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __SWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __USWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __USWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits() || al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl ||  a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator<=(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl ||  a.PackBits() < (__ULLWORD__)bl;
}

int operator<=(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al < b.PackBits();
}

int operator>=(const vbUINT64 &a, const vbUINT64 &b)
{
  return a.PackBits() == b.PackBits() || a.PackBits() > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __LWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const vbUINT64 &a, const __LLWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __LLWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __ULLWORD__ &bl)
{
  return a.PackBits() == bl || a.PackBits() > bl;
}

int operator>=(const __ULLWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const __LWORD__ &al, const vbUINT64 &b)
{
  return al == b.PackBits() || al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __ULWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __ULWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __WORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __WORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __SWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __SWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __UWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __UWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __USWORD__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __USWORD__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __SBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __SBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

int operator>=(const vbUINT64 &a, const __UBYTE__ &bl)
{
  return a.PackBits() == (__ULLWORD__)bl || a.PackBits() > (__ULLWORD__)bl;
}

int operator>=(const __UBYTE__ &al, const vbUINT64 &b)
{
  return (__ULLWORD__)al == b.PackBits() || (__ULLWORD__)al > b.PackBits();
}

char *vbUINT64::c_str(int radix)
{
  __ULLWORD__ val = PackBits();
  char *sbuf = new char[25];
  char cbuf;     
  unsigned value;
  char *s = sbuf;
  char *digit = s; 
  
  do {
    value = (unsigned) (val % radix);
    val /= radix; 
    
    if(value > 9)
      *s++ = (char) (value - 10 + 'a');
    else
      *s++ = (char) (value + '0'); 
  } while(val > 0);

  *s-- = '\0'; 

  do {
    cbuf = *s;
    *s = *digit;
    *digit = cbuf;   
    --s;
    ++digit;         
  } while(digit < s);

  return sbuf;
}

const char *vbUINT64::c_str(int radix) const
{
  __ULLWORD__ val = PackBits();
  char *sbuf = new char[25];
  char cbuf;     
  unsigned value;
  char *s = sbuf;
  char *digit = s; 
  
  do {
    value = (unsigned) (val % radix);
    val /= radix; 
    
    if(value > 9)
      *s++ = (char) (value - 10 + 'a');
    else
      *s++ = (char) (value + '0'); 
  } while(val > 0);

  *s-- = '\0'; 

  do {
    cbuf = *s;
    *s = *digit;
    *digit = cbuf;   
    --s;
    ++digit;         
  } while(digit < s);

  return (const char *)sbuf;
}

vbUINT64 &vbUINT64::StringToUINT64(const char *str)
{
  char *s = (char *)str;

  while(*s == ' ') ++s;

  int c = (int)(unsigned char)*s++;
  int sign = c; 
  if(c == '-' || c == '+') c = (int)(unsigned char)*s++;
  
  __LLWORD__ value = (__LLWORD__)0;

  while(isdigit(c)) {
    value = 10 * value + (c - '0'); 
    c = (int)(unsigned char)*s++; 
  }

  if(sign == '-') 
    *this = (__ULLWORD__)-value; 
  else
    *this = (__ULLWORD__)value;  

  return *this;
}

vbUINT64 &vbUINT64::StringToUINT64(char *str)
{
  char *s = str;

  while(*s == ' ') ++s;

  int c = (int)(unsigned char)*s++;
  int sign = c; 
  if(c == '-' || c == '+') c = (int)(unsigned char)*s++;
  
  __LLWORD__ value = (__LLWORD__)0;

  while(isdigit(c)) {
    value = 10 * value + (c - '0'); 
    c = (int)(unsigned char)*s++; 
  }

  if(sign == '-') 
    *this = (__ULLWORD__)-value; 
  else
    *this = (__ULLWORD__)value;  

  return *this;
}

ostream &operator<<(ostream &os, const vbUINT64 &val)
{
  return os << val.c_str();
}

istream &operator>>(istream &os, vbUINT64 &val) 
{
  char sbuf[25];
  for(unsigned i = 0; i < 25; i++) sbuf[i] = 0;
  os >> setw(25) >> sbuf;
  val.StringToUINT64(sbuf);
  return os;
}

#endif // __USE_NATIVE_INT_TYPES__ 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
