// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbheader.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 02/04/1997
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file contains type definitions, constants,
enumerations, and data structures needed to create variable
block database files. 
*/
// ----------------------------------------------------------- //   
#ifndef __VARIABLE_BLOCK_HEADER_HPP__
#define __VARIABLE_BLOCK_HEADER_HPP__

// --------------------------------------------------------------
// Include files
// --------------------------------------------------------------
#include "vbdtypes.h"
#include "vbint32.h"
#include "vbuint32.h"
#include "vbd_ver.h"
// --------------------------------------------------------------

// --------------------------------------------------------------
// Type definitions 
// --------------------------------------------------------------
// typedefs for file operations and stream position
typedef vbINT32 FAU; // (F)ile (A)ddress (U)nit, physical file address type
typedef vbINT32 vbStreamPos; // Stream position

// CRC-32 checksum used to detect bit errors
typedef vbUINT32 vbChecksum;
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants
// --------------------------------------------------------------
// Constants for dynamic data attributes used by the first byte of the
// block header block_status member.
const __SBYTE__ vbBadBlock     = 'B'; // Bad Variable Block
const __SBYTE__ vbDeletedBlock = 'D'; // Deleted Variable Block 
const __SBYTE__ vbNormalBlock  = 'N'; // Normal Read/Write attribute 
const __SBYTE__ vbRemovedBlock = 'R'; // Removed Variable Block

// This block was received from a remote device. Added in VBD revision C
const __SBYTE__ vbRemoteDeviceBlock = 'V'; 

// Constants for block control characters used by the second byte of the
// block header "block_status" member for device control commands.
const __SBYTE__ vbAddRemoteBlock    = 'A'; // Add a remote block
const __SBYTE__ vbChangeRemoteBlock = 'C'; // Change a remote block
const __SBYTE__ vbDeleteRemoteBlock = 'D'; // Delete a remote block
const __SBYTE__ vbRequestFailed     = 'F'; // The client request failed
const __SBYTE__ vbCloseConnection   = 'L'; // Close Client/Server connection
const __SBYTE__ vbKillServer        = 'K'; // Shutdown Client/Server
const __SBYTE__ vbRequestBlock      = 'R'; // Requesting a block
const __SBYTE__ vbSendBlock         = 'S'; // Sending raw data block
const __SBYTE__ vbAcknowledgeBlock  = 'W'; // Acknowledge a data block

// Constants for file operations and stream position 
const int vbMaxNameLength     = 255;        // Max length of names buffers
const FAU vbStartOfFile       = (FAU)0;     // First byte in the file
const FAU vbCurrAddress       = (FAU)-1;    // Indicates current location
const vbUINT32 vbCheckWord    = 0xfefefefe; // Default synchronization word
const vbINT32 vbFSListCorrupt = (FAU)-1;    // Free space list is corrupt
// --------------------------------------------------------------

// --------------------------------------------------------------
// Enumerations
// --------------------------------------------------------------
// vbDatabase access/open mode enumeration
enum vbDatabaseAccessMode { 
    vbDBASE_READONLY,   // Open file with read access only
    vbDABSE_WRITEONLY,  // Open file with write access only
    vbDBASE_READWRITE,  // Open file with read and write access
    vbDBASE_CREATE,     // Create the file if it does not exist
    vbDBASE_NO_CREATE,  // Do not create the file if it does not exist
    vbDBASE_TRUNCATE,   // Truncate the file  
    vbDBASE_APPEND,     // Append to the file
    vbDBASE_SHARE,      // Enable file sharing  (Platform specific)
    vbDBASE_EXCLUSIVE   // Disable file sharing (Platform specifiec)
  };

// vbDatabase I/O operation codes
enum vbDatabaseOperation{ 
  vbDBASE_READ,         // A read was performed
  vbDBASE_WRITE,        // A write operation was performed
  vbDBASE_REWIND,       // A rewind operation was performed
  vbDBASE_NO_OPERATION, // No operation was performed
  vbDBASE_SEEK          // A seek operation was preformed 
};

// vbDatabase seek mode enumeration
enum vbDatabaseSeekMode { 
  vbDBASE_SEEK_BEG, // Seek starting from the beginning of the file
  vbDBASE_SEEK_CUR, // Seek starting from the current location
  vbDBASE_SEEK_END  // Seek starting from the end of the file
};

// vbDatabase file/record lock enumeration
enum vbDatabaseLockType { 
  vbDBASE_READLOCK,
  vbDBASE_WRITELOCK
};

// vbDatabase Block reclamation methods
enum vbDatabaseReclaimMethod {
  vbDBASE_RECLAIM_NONE = 0, // Do not reclaim deleted blocks
  vbDBASE_RECLAIM_BESTFIT,  // Use the best fit reclamation method
  vbDBASE_RECLAIM_FIRSTFIT  // Use the first fit reclamation method
};
// --------------------------------------------------------------

// --------------------------------------------------------------
// Data Sturctures
// --------------------------------------------------------------
// Variable Block Database File Header
struct vbFileHeader // VBD file header information
{ 
  vbFileHeader() { 
    vbd_fs_fptr = vbd_eof = vbd_hs_fptr = vbd_hb_fptr = (FAU)0;
    vbd_ver = (FAU)0; vbd_sig[0] = 0;
  }
  ~vbFileHeader() { }

  FAU vbd_fs_fptr;      // Address to first block of free heap space
  FAU vbd_eof;          // Address of byte after end of file
  FAU vbd_hs_fptr;      // Address of the start of the heap space
  FAU vbd_hb_fptr;      // Highest allocated variable block
  __SBYTE__ vbd_sig[8]; // Signature used to ID a VBD file 
  FAU vbd_ver;          // VBD version number
  
private: // Disallow copying and assignment
  vbFileHeader(const vbFileHeader &ob) { }
  void operator=(const vbFileHeader &ob) { }
};

// Variable Block Header 
struct vbBlockHeader // Marks each variable data block (16 bytes total)
{
  vbBlockHeader() {
    block_check_word = vbCheckWord;
    block_status = vbNormalBlock;
    block_length = (vbUINT32)0;
    block_nd_fptr = (FAU)0;
  }
  ~vbBlockHeader() { }
  vbBlockHeader(const vbBlockHeader &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
  }
  vbBlockHeader& operator=(const vbBlockHeader &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
    return *this;
  }

  vbUINT32 block_check_word; // Block synchronization marker
  vbUINT32 block_length;     // Block length (object length + overhead)  
  vbUINT32 block_status;     // First byte  = status of the block's data 
                             // Second byte = block control commands
                             // Third byte  = reserved for future use
                             // Fourth byte = reserved for future use
  FAU block_nd_fptr;         // Pointer to next deleted block
};

// File lock header added to allow applications to lock the entire file during
// a multi-threaded/multi-machine read or write operation. The VBD advisory 
// file locking scheme includes lock protect member required to protect the 
// lock values during multiple file access. NOTE: The lock protect member is 
// required in the VBD platform  independent locking scheme because file lock 
// headers operate independently of the I/O subsystem and are manipulated
// by the database file manager in the same manner as variable blocks.
struct vbFileLockHeader
{
  vbFileLockHeader() {
    file_lock_protect = (vbUINT32)0;
    file_read_lock = file_write_lock = (vbUINT32)0; 
  }
  ~vbFileLockHeader() { }
  vbFileLockHeader(const vbFileLockHeader &ob) {
    file_lock_protect = ob.file_lock_protect;
    file_read_lock = ob.file_read_lock;
    file_write_lock = ob.file_write_lock;
  }
  vbFileLockHeader& operator=(const vbFileLockHeader &ob) {
    file_lock_protect = ob.file_lock_protect;
    file_read_lock = ob.file_read_lock;
    file_write_lock = ob.file_write_lock;
    return *this;
  }

  // The lock protect is used to serialize access to the file lock
  // values. The VBD locking scheme will allow a total of 2^32 or
  // 4,294,967,295 threads to read lock a file and single thread to
  // write lock a file.
  vbUINT32 file_lock_protect; // Serialize access to the file lock members
  vbUINT32 file_read_lock;    // Shared (or read-only) file lock 
  vbUINT32 file_write_lock;   // Exclusive (or write-only) file lock
};

// Record lock header used by an application to lock a specific block during 
// a multi-threaded/multi-machine read or write operation. The VBD advisory 
// record locking scheme includes a lock protect member required to protect 
// the lock values during multiple file access. NOTE: The lock protect member 
// is required in the VBD platform independent locking scheme because record 
// lock headers operate independently of the I/O subsystem and are manipulated
// by the database file manager in the same manner as variable blocks.
struct vbRecordLockHeader // Lock a contiguous set of bytes
{
  vbRecordLockHeader() {
    record_lock_protect = (vbUINT32)0;
    record_read_lock = record_write_lock = (vbUINT32)0;
  }
  ~vbRecordLockHeader() { }
  vbRecordLockHeader(const vbRecordLockHeader &ob) {
    record_lock_protect = ob.record_lock_protect;
    record_read_lock = ob.record_read_lock;
    record_write_lock = ob.record_write_lock;
  }
  vbRecordLockHeader& operator=(const vbRecordLockHeader &ob) {
    record_lock_protect = ob.record_lock_protect;
    record_read_lock = ob.record_read_lock;
    record_write_lock = ob.record_write_lock;
    return *this;
  }

  // The lock protect is used to serialize access to each record 
  // lock. The VBD locking scheme will allow a total of 2^32 or
  // 4,294,967,295 threads to read lock a record and single thread to
  // write lock a record.
  vbUINT32 record_lock_protect; // Serialize access to the record lock
  vbUINT32 record_read_lock;    // Shared (or read-only) file lock 
  vbUINT32 record_write_lock;   // Exclusive (or write-only) file lock
};
// --------------------------------------------------------------

#endif // __VARIABLE_BLOCK_HEADER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
