// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 08/07/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the UINT16 class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "vbuint16.h"

const __SWORD__   SWORDPositiveLimit = 32767;
const __SWORD__   SWORDNegitiveLimit = 32768;
const __USWORD__  USWORDLimit        = 65535;

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void SkipToEol(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

template<class TYPEX, class TYPEY>
inline void OperatorTest(TYPEX x, TYPEY y)
{
  char *tf[2] = {"FALSE", "TRUE"};
  cout << endl;
  cout << "Value x = " << x << ", Value y = " << y << endl;
  TYPEX z;
  cout << x << " += " << y << " = "; z = x; z += y; cout << z << endl;
  cout << x << " -= " << y << " = "; z = x; z -= y; cout << z << endl;
  cout << x << " *= " << y << " = "; z = x; z *= y; cout << z << endl;
  cout << x << " /= " << y << " = "; z = x; z /= y; cout << z << endl;
  cout << x << " * " << y << " = " ; z = (x * y); cout << z << endl;
  cout << x << " / " << y << " = " ; z = (x / y); cout << z << endl;
  cout << x << " + " << y << " = " ; z = (x + y); cout << z << endl;
  cout << x << " - " << y << " = " ; z = (x - y); cout << z << endl;
  cout << x << " == " << y << " = " << tf[(x == y)] << endl;
  cout << x << " != " << y << " = " << tf[(x != y)] << endl;
  cout << x << " <= " << y << " = " << tf[(x <= y)] << endl;
  cout << x << " >= " << y << " = " << tf[(x >= y)] << endl;
  cout << x << " < " << y << " = " << tf[(x < y)] << endl;
  cout << x << " > " << y << " = " << tf[(x > y)] << endl;
  cout << x << "++ = "; z = x; z++; cout << z << endl;
  cout << x << "-- = "; z = x; z--; cout << z << endl; 
  cout << "++" << x << " = "; z = x; ++z; cout << z << endl;
  cout << "--" << x << " = "; z = x; --z; cout << z << endl;
}

int main()
{
  vbUINT16 a = SWORDPositiveLimit;
  vbUINT16 b(SWORDNegitiveLimit);
  vbUINT16 c;

  c = USWORDLimit;
  cout << "Assigning vbUINT16 unsigned limit: " << c << endl;

  PausePrg();
  
  cout << "Testing vbUINT16 copy consturctor..." << endl;
  vbUINT16 d(a);
  cout << d << endl;

  cout << endl;
  cout << "Testing vbUINT16 assignment operator..." << endl;
  vbUINT16 e;
  e = a;
  cout << e << endl;

  PausePrg();

  cout << "Testing overloaded operators (vbUINT16, vbUINT16)..." << endl;
  __USWORD__ buf1, buf2, al, bl;
  
  cout << "Enter first integer: ";
  cin >> buf1;
  if(cin) {
    a = buf1;
    al = buf1;
    cout << "Enter second integer: ";
    cin >> buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }
  if(cin) {
    b = buf2;
    bl = buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }

  SkipToEol(cin);
    
  cout << endl;
  
  OperatorTest(a, b);

  PausePrg();

  cout << "Testing overloaded operators (vbUINT16, __LWORD__)..." << endl;
  OperatorTest(a, bl);

  PausePrg();

  cout << "Testing overloaded operators (__LWORD__, vbUINT16)..." << endl;
  OperatorTest(al, b);
  
  PausePrg();

  cout << "Testing overloaded operators (vbUINT16, __WORD__)..." << endl;
  OperatorTest(a, (__WORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__WORD__, vbUINT16)..." << endl;
  OperatorTest((__WORD__)al, b);

  PausePrg();

  cout << "Testing overloaded operators (vbUINT16, __SWORD__)..." << endl;
  OperatorTest(a, (__SWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__SWORD__, vbUINT16)..." << endl;
  OperatorTest((__SWORD__)al, b);

  PausePrg();
  
  cout << "Testing overloaded operators (vbUINT16, __UWORD__)..." << endl;
  OperatorTest(a, (__UWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__UWORD__, vbUINT16)..." << endl;
  OperatorTest((__UWORD__)al, b);

  PausePrg();

  cout << "Testing overloaded operators (vbUINT16, __USWORD__)..." << endl;
  OperatorTest(a, (__USWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__USWORD__, vbUINT16)..." << endl;
  OperatorTest((__USWORD__)al, b);

  PausePrg();
  
  cout << "Testing overloaded operators (vbUINT16, __SBYTE__)..." << endl;
  OperatorTest(a, 'B');

  PausePrg();

  cout << "Testing overloaded operators (__SBYTE__, vbUINT16)..." << endl;
  OperatorTest('A', b);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //




