// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer  
// File Creation Date: 02/14/1996  
// Date Last Modified: 08/09/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the VBD error functions and
exception classes.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include "vbderror.h"

#ifdef __CPP_EXCEPTIONS__

class CTest
{
public:
  CTest() { cout << "Constructing CTest object..." << endl; }
  ~CTest() { cout << "Destructing CTest object..." << endl; }

public:
  int FOpen(const char *s);
  vbDatabaseError GetError() { return err; }
  
private:
  vbDatabaseError err;
  fstream f;
};

int CTest::FOpen(const char *s)
{
  // ...
  // ...
  // Simulate an fopen error
  // Error detected here
     cout << "In CTest::FOpen(). Throwing a vbCDatabaseException exception..."
	  << endl;
     err = vbDBASE_FILE_OPEN_ERROR;
     throw vbCDatabaseException();
     // This will automatically call the destructor function during
     // stack unwinding for all local objects constructed before
     // the exception was thrown.

     // The context between the throw site and the catch handler
     // is known as the "exception stack frame". 
  // ...
  // ...

  return 0;   
}
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  cout << endl;
  cout << "Displaying an error message..." << endl;

  vbDatabaseError err = vbDBASE_WRONG_FILE_TYPE;
  
  cout << vbDatabaseExceptionMessage(err) << endl;
  
  PausePrg();
  
#ifdef __CPP_EXCEPTIONS__
  cout << "Testing C++'s built-in exception handling routines" << endl;

  CTest ob;
  try
    {
      cout << "In try block, calling CTest::FOpen()..." << endl;
      ob.FOpen("ABCDEF");
    }

  catch(vbCDatabaseException)
    {
      cout << vbDatabaseExceptionMessage(ob.GetError()) << endl;
    }

  cout << "Resuming program execution here..." << endl;
#else
  cout << "C++ Exception handling is not enabled" << endl;
#endif

  PausePrg();
  cout << "Test complete. Exiting..." << endl;

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
