// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: vbstat64.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 02/03/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The VBD file statistics functions are used to display detailed
file information about the open file This information is used
to analyze and troubleshoot VBD files. 
*/
// ----------------------------------------------------------- // 
#include "vbstat64.h"
#include <iostream.h>
#include <iomanip.h>

void VBDStats(vbDatabase64 *f)
{
  cout << endl;
  const char *FName = f->vbDatabaseName();
  char rev_letter = f->GetRevLetter();
  cout << "----- VBD file statistics -----" << endl;
  cout << endl;
  cout << "----- Static information -----" << endl;
  cout << "File Name:         " << FName << endl;
  cout << "File Signature:    " << f->GetSignature() << endl; 
  if(rev_letter == ' ' || rev_letter == 0)
    cout << "Revision Letter:   " << "Zero" << endl;
  else
    cout << "Revision Letter:   " << rev_letter << endl;
  cout << "Library Version:   " << f->GetVersion() << endl;
  cout << "File Header Size:  " << f->FileHeaderSize() << endl;
  cout << "Block Header Size: " << f->VBHeaderSize() << endl;
  cout << "Static area size:  " << (FAU64)f->StaticArea() << endl;
  cout << "Static file size:  " << (FAU64)f->FileSize(FName) << endl;
  cout << endl;
  cout << "----- Dynamic Information -----" << endl;
  cout << "File Status:     ";
  if(f->IsOpen()) cout << "Open "; else cout << "Closed ";
  if(f->ReadyForWriting()) cout << "Read/Write "; else cout << "Read/Only ";
  cout << endl;
  cout << "Free Space:      " << f->GetVBDFreeSpace() << endl;
  cout << "End of File:     " << f->GetEOF() << endl;
  cout << "Heap Start:      " << f->GetHeapStart() << endl;
  cout << "Highest Block:   " << f->GetHighestVB() << endl;
  cout << "Total Blocks:    " << f->VBTotal() << endl;
  __ULWORD__ tl, dl, rm;
  tl = f->VBDeleted(&dl, &rm);
  cout << "Deleted/Removed: " << dl << "/" << rm << " (" << tl << ")"
       << endl;

  vbFileLockHeader flh;
  switch(rev_letter) {
    case 'b': case 'B': case 'c': case 'C':
      cout << endl;
      cout << "----- Lock Header Information -----" << endl;
      f->ReadFileLockHdr(flh);
      cout << "File Lock Protect:     " << (int)flh.file_lock_protect << endl;
      cout << "File Read Lock Value:  " << (int)flh.file_read_lock << endl;
      cout << "File Write Lock Value: " << (int)flh.file_write_lock << endl;
      break;
    default:
      break;
  }

  cout << endl;
}

void VBStats(vbDatabase64 *f, FAU64 oa)
{
  vbBlockHeader vb;
  FAU64 VBAddress = oa - f->VBHeaderSize();
  f->Read(&vb, sizeof(vbBlockHeader), VBAddress);
  char rev_letter = f->GetRevLetter();
  __ULWORD__ object_crc, calc_crc;
  
  cout << endl;
  cout << "----- Block Statistics -----" << endl;
  
  cout << "Check Word   = ";
  cout.setf(ios::uppercase);
  cout << "0x" << setfill('0') << setw(8) << hex << vb.block_check_word 
       << endl;
  cout.unsetf(ios::uppercase);
  cout << "Length       = " << dec << vb.block_length << endl;
  cout << "Status       = " << (__SBYTE__)(vb.block_status & 0xff) << endl;
  cout << "Next Deleted = " << vb.block_nd_fptr << endl;
  cout << endl;
  cout << "----- Object Statistics -----" << endl;
  cout << "Object Length  = " << f->ObjectLength(oa) << endl;

  if((rev_letter != '\0') || (rev_letter != ' ')) {
    if(f->ReadObjectChecksum(oa, &object_crc, &calc_crc)) {
      cout.setf(ios::uppercase);
      cout << "Stored CRC     = 0x" << setfill('0') << setw(8) << hex
	   << object_crc << endl;
      cout << "Calculated CRC = 0x" << setfill('0') << setw(8) << hex
	   << calc_crc << dec << endl;
    }
    else {
      CheckError(f);
    }
  }

  if((rev_letter == 'c') || (rev_letter == 'C')) {
  vbRecordLockHeader rlh;
  cout << endl;
  cout << "----- Record Lock Statistics -----" << endl;
  f->ReadRecordLockHdr(rlh, VBAddress);
  cout << "Record Lock Protect:     " << (int)rlh.record_lock_protect 
       << endl;
  cout << "Record Read Lock Value:  " << (int)rlh.record_read_lock
       << endl;
  cout << "Record Write Lock Value: " << (int)rlh.record_write_lock
       << endl;

  }

  cout << endl;
}

int CheckError(vbDatabase64 *f)
// Check the last reported error. Prints the error
// and returns zero if an error condition was
// reached.
{
  if(f->GetDatabaseError() != vbDBASE_NO_ERROR) {
    cout << f->DatabaseExceptionMessage() << endl;
    return 1;
  }
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
