// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbint32.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbINT32 class is used to represent 32 bit signed integers
independently of the operating system or hardware platform used.
It works by separating a 32-bit value into four separate byte
values and reordering the bytes lowest-order to highest-order.
An vbINT32 type has a base 10 positive limit of 2,147,483,647 and
a negative limit of 2,147,483,648.
*/
// ----------------------------------------------------------- //   
#ifndef __vbINT32_HPP__
#define __vbINT32_HPP__

#include "vbdtypes.h"

#if defined (__USE_NATIVE_INT_TYPES__)
typedef __LWORD__ vbINT32;
#else

// Data structure for platform independent signed 32 bit integer values.
class vbINT32
{
public:
  vbINT32(__LWORD__ val = 0);
  vbINT32(const vbINT32& ob);
  vbINT32& operator=(const vbINT32& ob);
  vbINT32& operator=(const __LWORD__ ob);

public:
  void UnPackBits(__LWORD__ val);
  __LWORD__ PackBits() const;

public:
  operator __LWORD__() const;
  
public: // Arithmetic operators that modify their operand
  vbINT32 operator++(int);  // Postfix
  vbINT32 operator--(int);  // Postfix
  vbINT32 &operator++() { operator=(*this + 1); return *this; } // Prefix
  vbINT32 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const vbINT32 &i) { operator=(*this + i); }
  void operator-=(const vbINT32 &i) { operator=(*this - i); }
  void operator*=(const vbINT32 &i) { operator=(*this * i); }
  void operator/=(const vbINT32 &i);

  void operator+=(const __LWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __WORD__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __WORD__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__LWORD__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__LWORD__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__LWORD__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const vbINT32 &a, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator==(const __LWORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator==(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __WORD__ &bl);
  friend int operator==(const __WORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator==(const __SWORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator==(const __UWORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator==(const __USWORD__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator==(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator==(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator==(const __UBYTE__ &al, const vbINT32 &b);

  friend int operator!=(const vbINT32 &a, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator!=(const __LWORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator!=(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __WORD__ &bl);
  friend int operator!=(const __WORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator!=(const __SWORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator!=(const __UWORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator!=(const __USWORD__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator!=(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator!=(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator!=(const __UBYTE__ &al, const vbINT32 &b);

  friend int operator<(const vbINT32 &a, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator<(const __LWORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator<(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __WORD__ &bl);
  friend int operator<(const __WORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator<(const __SWORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator<(const __UWORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator<(const __USWORD__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator<(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator<(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator<(const __UBYTE__ &al, const vbINT32 &b);

  friend int operator>(const vbINT32 &a, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator>(const __LWORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator>(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __WORD__ &bl);
  friend int operator>(const __WORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator>(const __SWORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator>(const __UWORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator>(const __USWORD__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator>(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator>(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator>(const __UBYTE__ &al, const vbINT32 &b);

  friend int operator<=(const vbINT32 &a, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator<=(const __LWORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator<=(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __WORD__ &bl);
  friend int operator<=(const __WORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator<=(const __SWORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator<=(const __UWORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator<=(const __USWORD__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator<=(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator<=(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator<=(const __UBYTE__ &al, const vbINT32 &b);

  friend int operator>=(const vbINT32 &a, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __LWORD__ &bl);
  friend int operator>=(const __LWORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __ULWORD__ &bl);
  friend int operator>=(const __ULWORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __WORD__ &bl);
  friend int operator>=(const __WORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __SWORD__ &bl);
  friend int operator>=(const __SWORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __UWORD__ &bl);
  friend int operator>=(const __UWORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __USWORD__ &bl);
  friend int operator>=(const __USWORD__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __SBYTE__ &bl);
  friend int operator>=(const __SBYTE__ &al, const vbINT32 &b);
  friend int operator>=(const vbINT32 &a, const __UBYTE__ &bl);
  friend int operator>=(const __UBYTE__ &al, const vbINT32 &b);
  
private:
  __SBYTE__ byte[4];
};
#endif // __USE_NATIVE_INT_TYPES__

#endif // __vbINT32_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
