// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbdfp64.h 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 02/04/1997 
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The VBD 64-bit file helpers are a collection of classes and
standalone functions used to support large files on multiple
target platforms. NOTE: None of the data structures and 
functions defined are intended to be used directly. They are
used by the vbDatabase64 class to call the correct native 
64-bit file API function for each supported platform. 
*/
// ----------------------------------------------------------- //  
#ifndef __VBD_FILE_POINTER_64_HPP__
#define __VBD_FILE_POINTER_64_HPP__

// Non-platform specific include files
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "vbdtypes.h"
#include "vbheader.h"
#include "vbhdr64.h"

// Platform specific include files
#if defined (__WIN32__)
#include <io.h>
#elif defined (__UNIX__)
// NOTE: Place specific UNIX variants above this directive.
#include <unistd.h> // UNIX standard function definitions
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

// Platform specific file pointer type
struct vbdFPTR64 {
#if defined (__WIN32__) && defined (__MSVC__)
  int fptr;
#elif defined (__WIN32__) && defined (__BCC32__)
#error VBD large file support for BCC32 is not implemented
#elif defined (__UNIX__) && defined (__LINUX__)
#error VBD large file support for Linux is not implemented
#elif defined (__UNIX__) && defined (__HPUX__)
  FILE *fptr;
#elif defined (__UNIX__) && defined (__SOLARIS__)
  FILE *fptr;
#else
#error You must define a target platform and/or compiler
#endif
};

vbdFPTR64 *vbdFPTR64Create(const char *fname);
vbdFPTR64 *vbdFPTR64Open(const char *fname, vbDatabaseAccessMode mode);
int vbdFPTR64Close(vbdFPTR64 *stream);
int vbdFPTR64Flush(vbdFPTR64 *stream);
int vbdFPTR64Read(vbdFPTR64 *stream, void *buf, __UWORD__ bytes);
int vbdFPTR64Write(vbdFPTR64 *stream, const void *buf, __UWORD__ bytes);
__LLWORD__ vbdFPTR64Seek(vbdFPTR64 *stream, __LLWORD__,
			 vbDatabaseSeekMode mode);
__LLWORD__ vbdFPTR64Tell(vbdFPTR64 *stream);
int vbdFPTR64Exists(const char *fname);
__LLWORD__ vbdFPTR64FileSize(const char *fname);

#endif // __VBD_FILE_POINTER_64_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
