// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbuint16.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbUINT16 class is used to represent 16 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 16-bit value into two separate byte
values and reordering the bytes lowest-order to highest-order.
An vbUINT16 type has a base 10 positive limit of 65,535.
*/
// ----------------------------------------------------------- //   
#ifndef __VBUINT16_HPP__
#define __VBUINT16_HPP__

#include "vbdtypes.h"

#if defined (__USE_NATIVE_INT_TYPES__)
typedef unsigned short vbUINT16;
#else
// Data structure for unsigned 16 bit integer values.
class vbUINT16
{
public:
  vbUINT16(__USWORD__ val = 0);
  vbUINT16(const vbUINT16& ob);
  vbUINT16& operator=(const vbUINT16& ob);
  vbUINT16& operator=(const __USWORD__ ob);

public:
  void UnPackBits(__USWORD__ val);
  __USWORD__ PackBits() const;

public:
  operator __USWORD__() const;
  
public: // Arithmetic operators that modify their operand
  vbUINT16 operator++(int);  // Postfix
  vbUINT16 operator--(int);  // Postfix
  vbUINT16 &operator++() { operator=(*this + 1); return *this; } // Prefix
  vbUINT16 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const vbUINT16 &i) { operator=(*this + i); }
  void operator-=(const vbUINT16 &i) { operator=(*this - i); }
  void operator*=(const vbUINT16 &i) { operator=(*this * i); }
  void operator/=(const vbUINT16 &i);

  void operator+=(const __LWORD__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __WORD__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __WORD__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__USWORD__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__USWORD__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__USWORD__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator==(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator==(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator==(const __WORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator==(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator==(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator==(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator==(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator==(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator==(const __UBYTE__ &as, const vbUINT16 &b);

  friend int operator!=(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator!=(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator!=(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator!=(const __WORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator!=(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator!=(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator!=(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator!=(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator!=(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator!=(const __UBYTE__ &as, const vbUINT16 &b);

  friend int operator<(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator<(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator<(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator<(const __WORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator<(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator<(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator<(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator<(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator<(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator<(const __UBYTE__ &as, const vbUINT16 &b);

  friend int operator>(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator>(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator>(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator>(const __WORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator>(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator>(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator>(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator>(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator>(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator>(const __UBYTE__ &as, const vbUINT16 &b);

  friend int operator<=(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator<=(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator<=(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator<=(const __WORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator<=(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator<=(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator<=(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator<=(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator<=(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator<=(const __UBYTE__ &as, const vbUINT16 &b);

  friend int operator>=(const vbUINT16 &a, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __LWORD__ &bs);
  friend int operator>=(const __LWORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __ULWORD__ &bs);
  friend int operator>=(const __ULWORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __WORD__ &bs);
  friend int operator>=(const __WORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __SWORD__ &bs);
  friend int operator>=(const __SWORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __UWORD__ &bs);
  friend int operator>=(const __UWORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __USWORD__ &bs);
  friend int operator>=(const __USWORD__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __SBYTE__ &bs);
  friend int operator>=(const __SBYTE__ &as, const vbUINT16 &b);
  friend int operator>=(const vbUINT16 &a, const __UBYTE__ &bs);
  friend int operator>=(const __UBYTE__ &as, const vbUINT16 &b);
  
private:
  __UBYTE__ byte[2];
};
#endif // __USE_NATIVE_INT_TYPES__

#endif // __VBUINT16_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
