// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer 
// File Creation Date: 02/04/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Program used to test the record locking primitives.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include "vbdbase.h"
#include "vbfloat.h"
#include "vbstat32.h"

const int name_length = 16;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (vbINT32)0, cid = (vbFLOAT64)0; }
  DatabaseObject(const char *s, long i, double d);

public:
  friend void *operator new(size_t n, char *s, int i, double d,
			    vbDatabase *f) {
    void *ptr = new DatabaseObject(s, i, d);
    f->Write(ptr, n, f->Alloc(n));
    return ptr;
  }
  
public: // Platform independent data members
  char name[name_length]; // Fixed string type
  vbINT32 oid;            // Integer type
  vbFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, long i, double d)
{
  for(int j = 0; j < name_length; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void Menu()
{
  cout << endl;
  cout << "(c, C)   Clear the record lock header" << endl;
  cout << "(h, H)   Help (prints this menu)" << endl;
  cout << "(p)      Toggle the record lock protect" << endl;
  cout << "(P)      Reset the record lock protect" << endl;   
  cout << "(q, Q)   Quit this program" << endl;
  cout << "(r)      Read lock the record" << endl;
  cout << "(R)      Relase the read lock" << endl;
  cout << "(s, S)   Display the record stats" << endl;
  cout << "(w)      Write lock the record" << endl;
  cout << "(W)      Relase the write lock" << endl;
  cout << endl;
}

void DisplayLockValues(vbRecordLockHeader &rlh)
{
  cout << "Record Lock Protect:     " << (int)rlh.record_lock_protect << endl;
  cout << "Record Read Lock Value:  " << (int)rlh.record_read_lock << endl;
  cout << "Record Write Lock Value: " << (int)rlh.record_write_lock << endl; 
}

int main()
{
  vbDatabase *f = new vbDatabase; 
  cout << "Creating new file..." << endl;
  const char *fname = "testfile.vbd";
  const int num_to_add = 500;
  
  if(!vbDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname);
    if(CheckError(f) != 0) return 1;
    cout << "Adding " << num_to_add << " objects..." << endl;
    for(long i = 0; i < num_to_add; i++) {
      new("Mouse", i, 2000.101, f) DatabaseObject;
      if(CheckError(f) != 0) return 1;
    }
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return 1;
  }

  FAU object_address = f->GetHighestVB() + f->VBHeaderSize();
  FAU block_address = f->GetHighestVB();
  FAU header_address = f->GetHighestVB() + sizeof(vbBlockHeader);
  
  char key;
  vbUINT32 lock_protect;
  Menu();
  int rv = 1;
  vbRecordLockHeader rh;

  while(rv) {
    if (!cin) { 
      ClearInputStream(cin); 
      if (!cin) {  
	cout << "Input stream error" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; 
    switch(key) {
      case '?' : Menu(); break;
      case 'c' : case 'C' : f->ResetRecordLock(block_address); break;
      case 'h' : case 'H' : Menu(); break;
      case 'q' : case 'Q' : rv = 0; break;
      case 's' : case 'S' : VBStats(f, object_address); break;
      case 'p' :  
	lock_protect = 1;
	f->Write(&lock_protect, sizeof(vbUINT32), header_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      case 'P' :
	lock_protect = (vbUINT32)0;
	f->Write(&lock_protect, sizeof(vbUINT32), header_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      case 'r' : 
	f->LockRecord(vbDBASE_READLOCK, block_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      case 'R' : 
	f->UnlockRecord(vbDBASE_READLOCK, block_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      case 'w' : 
	f->LockRecord(vbDBASE_WRITELOCK, block_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      case 'W' : 
	f->UnlockRecord(vbDBASE_WRITELOCK, block_address);
	CheckError(f);
	f->ReadRecordLockHdr(rh, block_address);
	DisplayLockValues(rh);
	break;
      default:
        cout << "Unrecognized command" << endl;
	break;
    }
  }

  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;
  delete f;
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
