// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbmutex.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Mutual exclusion class used to provide simple lock primitives
that can be used to control access to a shared resource. A mutex
is used to cause other threads to wait while the thread holding
the mutex executes code in a critical section.
*/
// ----------------------------------------------------------- //   
#include "vbmutex.h"

vbMutex::vbMutex(vbProcessType type)
{
  MutexInit(type);
}

vbMutex::~vbMutex()
{
  MutexDestroy();
}

int vbMutex::MutexInit(vbProcessType type)
// Initialize the mutex. Returns a non-zero value if the
// mutex cannot be initialized or if any errors occur.
{
  mutex_lock = 0;
  int rv = vbThreadMutexInit(&mutex, type);
  if(rv != 0) return rv;
  return 0;
}

int vbMutex::MutexDestroy()
// Destroy the mutex. Returns a non-zero value if the
// mutex cannot be destroyed or if any errors occur.
{
  int rv = vbThreadMutexDestroy(&mutex);
  if(rv != 0) return rv;
  mutex_lock = 0;
  return 0;
}

int vbMutex::MutexLock()
// Lock the mutex. If the mutex is already locked, the calling
// thread blocks until the mutex becomes available. Returns a
// non-zero value if the mutex cannot be locked or if any errors
// occur.
{
  int rv = vbThreadMutexLock(&mutex);
  if(rv != 0) return rv;
  mutex_lock++;
  return 0;
}

int vbMutex::MutexUnlock()
// Unlock the mutex. Returns a non-zero value if the
// mutex cannot be unlocked or if any errors occur.
{
  int rv = vbThreadMutexUnlock(&mutex);
  if(rv != 0) return rv;
  if(mutex_lock > 0) mutex_lock--;
  return 0;
}

int vbMutex::MutexTryLock()
// Test the mutex state before locking it. Returns a non-zero if
// any errors occur.
{
  int rv = vbThreadMutexTryLock(&mutex);
  if(rv != 0) return rv;
  mutex_lock++;
  return 0;
}

const char *vbMutex::MutexExceptionMessage()
// Returns a null terminated string that can
// be use to log or print a mutex exception.
{
  return vbThreadMutexExceptionMessage(&mutex);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
