// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer 
// File Creation Date: 02/04/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Test program used to test the vbDatabase::Reclaim() function
using the frist-fit or best-fit method of reclaiming deleted
and removed blocks. Define the __RECLAIM_BEST_FIT__ macro to
use the best-fit routine or the __RECLAIM_FIRST_FIT__ macro
to use the first-fit routine.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <time.h>
#include "vbdbase.h"
#include "vbstat32.h"

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

clock_t Start()
// Mark the starting time for the routine.
{
  return clock();
}

clock_t Stop()
// Mark the stop time for the routine. 
{
  return clock();
}

double ElapsedTime(clock_t begin, clock_t end)
// Calculate the elapsed time in milliseconds. 
{
  return (double)(end - begin) / CLOCKS_PER_SEC;
}

void DefragStats(vbDatabase *f)
{
  __ULWORD__ t, d, r;
  t = f->VBTotal();
  f->VBDeleted(&d, &r);
  
  cout << endl;
  cout << "Number of blocks alloacted: " << t << endl;
  cout << "Total blocks in use: " << (t - (d + r)) << endl;
  cout << "Total deleted/removed:  " << d << "/" << r << " ("
       << (d + r) << ")" << endl;
}

void TestReclaimMethod(vbDatabaseReclaimMethod reclaim_method)
{
  const int NumObjects = 100; // Number of objects to allocate
  const char *fname = "defrag.vbd";
  
  vbDatabase *f = new vbDatabase;

  cout << endl;
  cout << "Testing the best-fit/frist-fit allocation methods." << endl;
  
  if(reclaim_method == vbDBASE_RECLAIM_BESTFIT) {
  cout << endl;
  cout << "Using the best-fit method to reclaim deleted/removed blocks."
       << endl;
  }
  else { 
  cout << endl;
  cout << "Using the first-fit method to reclaim deleted/removed blocks."
       << endl;
  }

  if(!vbDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname);
    if(CheckError(f) != 0) return;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return;
  }

  PausePrg();
  VBDStats(f);
  PausePrg();

  FAU addr;

  FAU addr_list[NumObjects];
  char data = 'X';
  int i,j;

  cout << "Adding " << NumObjects << " objects to the file." << endl;
  cout << "Objects range from " << sizeof(data) << " to " << NumObjects
       << " bytes in length"
       << endl;
  cout << "Writing..." << endl;
  
  clock_t Begin = Start();
  for(i = 0; i < NumObjects; i++) {
    addr = f->Alloc(sizeof(data)+i, reclaim_method);
    addr_list[i] = addr; // Store the address of each node alloacted
    for(j = 0; j <= i; j++) {
      f->Write(&data, sizeof(data), addr+j, 0, 0);
    }
  }
  clock_t End = Stop();

  cout.precision(3);
  cout << "Comleted in " << ElapsedTime(Begin, End) << " seconds" << endl;
  DefragStats(f);
  PausePrg();
  
  cout << "Deleting all the blocks alloacted that were just allocated."
       << endl;
  cout << "Working..." << endl;
  
  Begin = Start();
  for(i = 0; i < NumObjects; i++) f->Delete(addr_list[i]);;
  End = Stop();
  
  cout.precision(3);
  cout << "Comleted in " << ElapsedTime(Begin, End) << " seconds" << endl;
  DefragStats(f);
  PausePrg();
  
  cout << "Fragmenting the file." << endl;
  cout << "Undeleting every other block that was just deleted."
       << endl;
  cout << "Working..." << endl;
  
  Begin = Start();
  for(i = 0; i < NumObjects; i++) {
    f->UnDelete(addr_list[i]);
    i++; // Skip to the next block
  }
  End = Stop();
  
  cout.precision(3);
  cout << "Comleted in " << ElapsedTime(Begin, End) << " seconds" << endl;
  DefragStats(f);
  PausePrg();
  
  cout << "Adding " << NumObjects << " objects to the file." << endl;
  cout << "All objects are " << sizeof(data) << " bytes in length."
       << endl;
  cout << "Writing..." << endl;

  Begin = Start();
  for(i = 0; i < NumObjects; i++) {
    f->Alloc(sizeof(data), reclaim_method);
    f->Write(&data, sizeof(data), vbCurrAddress, 0, 0);
  }
  End = Stop();
  
  cout.precision(3);
  cout << "Comleted in " << ElapsedTime(Begin, End) << " seconds" << endl;
  DefragStats(f);
  PausePrg();
  
  int offset = 1;
  cout << "Adding " << NumObjects << " objects to the file." << endl;
  cout << "Objects range from " << (sizeof(data) + offset) << " to "
       << (NumObjects + offset) << " bytes in length"
       << endl;
  cout << "Writing..." << endl;

  Begin = Start();
  for(i = 0; i < NumObjects; i++) {
    addr = f->Alloc((sizeof(data)+i)+offset, reclaim_method);
    for(j = 0; j <= i; j++)
      f->Write(&data, sizeof(data), (addr+j)+offset, 0, 0);
  }
  End = Stop();  

  cout.precision(3);
  cout << "Comleted in " << ElapsedTime(Begin, End) << " seconds" << endl;
  DefragStats(f);

  cout << endl;
  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return;
  delete f;
}

int main()
{
  TestReclaimMethod(vbDBASE_RECLAIM_BESTFIT);
  TestReclaimMethod(vbDBASE_RECLAIM_FIRSTFIT);
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
