//===================================================================
// residual.h
//
// Version 1.1
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  April 10, 1999
//===================================================================

#ifndef _RESIDUAL_HPP_
#define _RESIDUAL_HPP_

#include "numerics.h"

NUM_BEGIN

template<class Iter, class Value>
void resid(Iter first, Iter last, Value val)
//-------------------------------------------------------------------
// Replaces the elements in [first, last) with thier deviations from
// val.
//-------------------------------------------------------------------
{
    while(first != last){
        *first -= val;
        ++first;
    }
};

template<class Iter, class Value>
void aresid(Iter first, Iter last, Value val)
//-------------------------------------------------------------------
// Replaces the elements in [first, last) with thier absolute
// deviations from val.
//-------------------------------------------------------------------
{
    while(first != last){
        *first = absoluteValue(*first - val);
        ++first;
    }
};

template<class Iter, class Value>
void nresid(Iter first, Iter last, Value val, double n)
//-------------------------------------------------------------------
// Replaces the elements in [first, last) with thier deviations from
// val raised to the n-th power.
//-------------------------------------------------------------------
{
    if(n != 1.0){
        while(first != last){
            *first = pow(*first - val, n);
            ++first;
        }
    } else {
        resid(first, last, val);
    }
};

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
// Version 1.1 - 04/10/1999 - Added Numerics namespace.
//===================================================================
