
;============================================================================
;
; DRVDRIV.ASM
; Some low-level routines for access of disks via device-driver.
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================*/

IDEAL
P386
LOCALS @@

MODEL SMALL
CODESEG

PUBLIC _GetDPB
PUBLIC _CallDriver

INCLUDE "DPB.INC"	;Disk Parameter Block definition

PROC _GetDPB
; gets DPB of given disk
; prototype: int GetDPB( char cDisk, t_DPB far *ptDPB )
; return: 1 if successfull, 0 else
	ARG cDisk:BYTE, ptDPB:DWORD

	push	bp				;setup stack
	mov		bp,sp
	push	ds				;save ds
	push	es              ;save es
	push	bx              ;save bx
	push	si              ;save si
	push	di              ;save di

	push	ds              ;
	pop		es              ;es=ds
	mov		ah,32h			;DOS 'Get DPB'
	mov		dl,[cDisk]		;dl=disk letter
	or		dl,20h			;convert disk letter to disk number
	sub		dl,'a'-1		;this function counts from 1 (0=current disk)
	int		21h				;modifies ds (ds:bx->DPB)
	or		al,al			;al=0 if successful
	jz		@@gotdpb
	xor		ax,ax			;return 0 if error
@@done:
	pop		di				;restore di
	pop		si				;restore si
	pop		bx				;restore bx
	pop		es				;restore es
	pop		ds				;restore ds
	pop		bp				;restore stack
	ret

@@gotdpb:
	mov		si,bx			;ds:si->DPB
	mov		cx,SIZE sDPB
	les		di,[ptDPB]		;es:di->storage for DPB
	cld
	rep movsb				;copy DPB in my ds
	mov		ax,1			;return 1 for success
	jmp		@@done

ENDP _GetDPB

PROC _CallDriver
; calls a device-driver
; prototype: void CallDriver( void far *fpStrat, void far *fpIntr, void far *ptReq )
; return: none
	ARG fpStrat:DWORD, fpIntr:DWORD, ptReq:DWORD

	push	bp			;setup stack
	mov		bp,sp

	push	es			;save es (is es==ds in turboc?)
	push	bx			;save bx

	les		bx,[ptReq]	;es:bx->request header
	call	[fpStrat]	;far call of driver's strategy routine
	call	[fpIntr]	;far call of driver's interrupt routine

	pop		bx			;restore bx
	pop		es			;restore es

	pop		bp			;restore stack
	ret

ENDP _CallDriver

END ;of file 'DRVDRIV.ASM'

