/*/

  Q Compile Utility v1.00a

/*/

void fsplit(char *,char *,char *,char *);

#include <qlib.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>

#include <misc.h>
#include "parse.h"

void _system(char *cmd) {
//  printf("CMD = %s\n",cmd);
//  getch();
  if (system(cmd)) error("system() failed!");
}

char dosX=0;  //DOS extender
byte lite=0,map=0,bug=0,qdll=0,conly=0,std=0;
char fn[0x80],fn_name[0x80],fn_ext[0x80],fn_path[0x80];
char tn[0x400],rfn[0x80];
char fn1[0x80],fn2[0x80];  //output filename  (EXE or LE/QDL)
int ho;
char cmd[0x400];
char ct;       //compiler type (A=ASM C=C P=C++)
char comp=0;   //compiler choice
char *stubfn;

void usage(void) {
  printf("Usage : QCOMP [options] file[.ext] file(s)[...]\n");
  printf("  file - filename to compile\n");
  printf("  file(s) - files to add [OBJs and LIBs]\n");
  if (!comp) {   //must be using ...2exe.bat files
    printf("  Compiler Options:\n");
    printf("   /BC[++] - use Borland C/C++ to compile\n");
    printf("   /WC[++] - use Watcom C/C++ to compile\n");
    printf("   /MC[++] - use M$ Visual C/C++ to compile\n");
    printf("   /MASM - use MASM to compile        /NASM - use NASM to compile\n");
    printf("   /TASM - use TASM to compile        /WASM - use WASM to compile\n");
  }
  printf("  DOS Extender options:\n");
  printf("   /P - use PMODE/W DOS extender (default)\n");
  printf("   /W - use WDOSX DOS extender\n");
  printf("   /D - use DOS/4GW DOS extender\n");
  printf("   /S[=<stub>] - use other or no DOS extender\n");
  printf("  Other options:\n");
  printf("   /L - use PMWLITE to compress LE-EXE\n");
  printf("   /M - generate map file (*.map)\n");
  printf("   /Z - add Debug info\n");
  printf("   /X - Create a QDLL file (pure LE image)\n");
  printf("   /C - Compile only, no linking\n");
  printf("   /STD - Create stand alone app (no default LIBs/startup code)\n");
  exit(0);
}

void cleanup(void) {}

void main(void) {
  word a;
  char *p;
  int h;

  printf("Q Compile Utility  v1.00a  (by : Peter Quiring)\n");

  parse_args();

  for (a=0;a<arg_optsc;a++) {
    p=arg_opts[a][0];
    if (!stricmp(p,"S")) if (dosX) usage(); else {
      dosX='O';
      if (arg_opts[a][1]==NULL)
        stubfn=NULL;
      else
        stubfn=arg_opts[a][1];
      continue;
    }
    if (arg_opts[a][1]!=NULL) usage();
    if (!stricmp(p,"W")) if (dosX) usage(); else { dosX='W'; continue; }
    if (!stricmp(p,"P")) if (dosX) usage(); else { dosX='P'; continue; }
    if (!stricmp(p,"D")) if (dosX) usage(); else { dosX='D'; continue; }

    if (!stricmp(p,"L")) if (lite) usage(); else { lite=1; continue; }
    if (!stricmp(p,"M")) if (map) usage(); else { map=1; continue; }
    if (!stricmp(p,"Z")) if (bug) usage(); else { bug=1; continue; }
    if (!stricmp(p,"X")) if (qdll) usage(); else { qdll=1; continue; }
    if (!stricmp(p,"C")) if (conly) usage(); else { conly=1; continue; }
    if (!stricmp(p,"STD")) if (std) usage(); else { std=1; continue; }

    if (!stricmp(p,"MASM")) if (comp) usage(); else { ct='A'; comp='M'; continue; }
    if (!stricmp(p,"TASM")) if (comp) usage(); else { ct='A'; comp='T'; continue; }
    if (!stricmp(p,"NASM")) if (comp) usage(); else { ct='A'; comp='N'; continue; }
    if (!stricmp(p,"WASM")) if (comp) usage(); else { ct='A'; comp='W'; continue; }

    if (!stricmp(p,"BC")) if (comp) usage(); else { ct='C'; comp='B'; continue; }
    if (!stricmp(p,"WC")) if (comp) usage(); else { ct='C'; comp='W'; continue; }
    if (!stricmp(p,"MC")) if (comp) usage(); else { ct='C'; comp='M'; continue; }

    if (!stricmp(p,"BC++")) if (comp) usage(); else { ct='P'; comp='B'; continue; }
    if (!stricmp(p,"WC++")) if (comp) usage(); else { ct='P'; comp='W'; continue; }
    if (!stricmp(p,"MC++")) if (comp) usage(); else { ct='P'; comp='M'; continue; }

  }

  if (arg_namesc<1) usage();  //FIX : allow parse first then usage()

  if ((std) && (conly)) usage();  //does not make any sense

  if ((qdll)&&(dosX)) usage();    //dito

  if (qdll) dosX='L';  //QDLL

  if (!comp) usage();

  //setup defaults
  if (!dosX) dosX='P';  //PMODE/W

  //get name
  strcpy(fn,arg_names[0]);
  fsplit(fn,fn_path,fn_name,fn_ext);
  strcpy(tn,fn_path);  //Copy path into name
  strcat(tn,fn_name);
  strcpy(fn_name,tn);

  //Compile File
  switch (ct) {
    case 'A':
      switch (comp) {
        case 'M':  strcpy(cmd,"MASM2OBJ.BAT "); break;
        case 'T':  strcpy(cmd,"TASM2OBJ.BAT "); break;
        case 'N':  strcpy(cmd,"NASM2OBJ.BAT "); break;
        case 'W':  strcpy(cmd,"WASM2OBJ.BAT "); break;
      }
      break;
    case 'C':
      switch (comp) {
        case 'B':  strcpy(cmd,"BC2OBJ.BAT "); break;
        case 'W':  strcpy(cmd,"WC2OBJ.BAT "); break;
        case 'M':  strcpy(cmd,"MC2OBJ.BAT "); break;
      }
      break;
    case 'P':
      switch (comp) {
        case 'B':  strcpy(cmd,"BCPP2OBJ.BAT "); break;
        case 'W':  strcpy(cmd,"WCPP2OBJ.BAT "); break;
        case 'M':  strcpy(cmd,"MCPP2OBJ.BAT "); break;
      }
      break;
  }

  if (bug) strcat(cmd,"/z ");   //FIX : v1.00a : Was missing space
  strcat(cmd,fn_name);
  _system(cmd);

  strcpy(tn,fn_name);
  strcat(tn,".obj");
  h=open(tn,O_BINARY | O_RDONLY);
  if (h==-1) error("Compile unsuccessful");

  if (conly) {
    printf("Complete!\n");
    exit(0);
  }

  //Link EXE
  strcpy(cmd,"QLINK ");
  strcat(cmd,fn_name);   //EXE name
  strcat(cmd," ");
  strcat(cmd,fn_name);   //File #1
  for (a=1;a<arg_namesc;a++) {
    strcat(cmd," ");
    strcat(cmd,arg_names[a]);
  }

  switch (dosX) {
    case 'L':  strcat(cmd," /x"); break;
    case 'W':  strcat(cmd," /w"); break;
    case 'P':  strcat(cmd," /p"); break;
    case 'D':  strcat(cmd," /d"); break;
    case 'O':
      strcpy(tn," /s=");
      if (stubfn!=NULL) strcat(tn,stubfn);
      strcat(cmd,tn);
      break;
  }

  if (lite) strcat(cmd," /l");

  if (map) strcat(cmd," /m");

  if (bug) strcat(cmd," /z");

  if (std) strcat(cmd," /std");

  _system(cmd);

}
