G_TEXT equ 1
G_VGA equ 2
G_VESA equ 3
G_MODEX equ 4

.code

;Gets an image from video RAM
;Performs clipping to view port
gd_get proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_bpsl,sadd,dadd,esi,edi

  mov ecx,_v_bypp
  .if ecx > 1
    .if ecx == 2
      shl xl,1
      shl sadd,1
      shl dadd,1
      shl esi,1
      shl edi,1
    .elseif ecx == 4
      shl xl,2
      shl sadd,2
      shl dadd,2
      shl esi,2
      shl edi,2
    .else
      mov eax,xl
      mul ecx
      mov xl,eax
      mov eax,sadd
      mul ecx
      mov sadd,eax
      mov eax,dadd
      mul ecx
      mov dadd,eax
      mov eax,esi
      mul ecx
      mov esi,eax
      mov eax,edi
      mul ecx
      mov edi,eax
    .endif
  .endif
  add edi,buf
  add esi,_v_buffer
  add esi,saddr

  ;time to copy image
line:
  mov ecx,xl
  copyECX  ;destroys AL

  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,1
  ret
g_get endp

;Puts an image into temp buffer
;Performs clipping to view port
g_put proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi

  mov ecx,_v_bypp
  .if ecx > 1
    .if ecx == 2
      shl xl,1
      shl sadd,1
      shl dadd,1
      shl esi,1
      shl edi,1
    .elseif ecx == 4
      shl xl,2
      shl sadd,2
      shl dadd,2
      shl esi,2
      shl edi,2
    .else
      mov eax,xl
      mul ecx
      mov xl,eax
      mov eax,sadd
      mul ecx
      mov sadd,eax
      mov eax,dadd
      mul ecx
      mov dadd,eax
      mov eax,esi
      mul ecx
      mov esi,eax
      mov eax,edi
      mul ecx
      mov edi,eax
    .endif
  .endif
  add edi,_v_buffer
  add edi,saddr
  add esi,buf

  ;time to copy image
line:
  mov ecx,xl
  copyECX  ;destroys AL

  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,1
  ret
g_put endp

;Puts an image into temp buffer except color #0
g_put0 proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword
  local sadd:dword   ;src add
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi

  mov ecx,_v_bypp
  .if ecx > 1
    .if ecx == 2
;      shl xl,1
      shl sadd,1
      shl dadd,1
      shl esi,1
      shl edi,1
    .elseif ecx == 4
;      shl xl,2
      shl sadd,2
      shl dadd,2
      shl esi,2
      shl edi,2
    .else
;      mov eax,xl
;      mul ecx
;      mov xl,eax
      mov eax,sadd
      mul ecx
      mov sadd,eax
      mov eax,dadd
      mul ecx
      mov dadd,eax
      mov eax,esi
      mul ecx
      mov esi,eax
      mov eax,edi
      mul ecx
      mov edi,eax
    .endif
  .endif
  add edi,_v_buffer
  add edi,saddr
  add esi,buf

  ;time to copy image
  .if cl==1
    mov ebx,0ffh
  .elseif cl==2
    mov ebx,0ffffh
  .elseif cl==3
    mov ebx,0ffffffh
  .else
    mov ebx,-1
  .endif
  mov edx,ecx
line:
  mov eax,xl
pixel:
  test [esi],ebx
  .if !zero?
    mov ecx,edx
    rep movsb   ;OPT! : Can't opt
  .else
    add esi,edx
    add edi,edx
  .endif
  dec eax
  jnz pixel
  add esi,sadd
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,1
  ret
g_put0 endp

;Puts a bit-packed-mono image into temp buffer except color #0
g_putb0 proc,buf:dword,x1:dword,y1:dword,x2:dword,y2:dword,clr:dword
  local sadd:dword   ;src add
  local saddrot:byte ;src add (rotation optimization)
  local dadd:dword   ;dest add
  local saddr:dword  ;start addr
  local xl:dword     ;delta-x
  local yl:dword     ;delta-y

  pushad

  g_setup _v_xb,dadd,sadd,edi,esi

  mov ecx,_v_bypp
  .if ecx > 1
    .if ecx == 2
;      shl xl,1
      shl dadd,1
      shl edi,1
    .elseif ecx == 4
;      shl xl,2
      shl dadd,2
      shl edi,2
    .else
;      mov eax,xl
;      mul ecx
;      mov xl,eax
      mov eax,dadd
      mul ecx
      mov dadd,eax
      mov eax,edi
      mul ecx
      mov edi,eax
    .endif
  .endif
  add edi,_v_buffer
  add edi,saddr

  ;Convert sadd => bitpack format
  mov eax,sadd
  shr sadd,3
  and al,7
  mov saddrot,al

  ;Convert ESI => bitpack format
  mov ebx,esi
  and bl,7
  shr esi,3
  add esi,buf

  ; bh = 2 ^ bl
  mov bh,1
@@:
  .if bl
    dec bl
    shl bh,1
    jmp @b
  .endif

  mov edx,ecx
  ;time to copy image
line:
  mov eax,xl
pixel:
  test [esi],bh
  .if !zero?
    mov ecx,edx
    push eax
    mov eax,clr
more:
    stosb
    shr eax,8
    dec ecx
    jnz more
    pop eax
  .else
    add edi,edx
  .endif
  shl bh,1
  .if zero?
    inc bh
    inc esi
  .endif
  dec eax
  jnz pixel
  add esi,sadd
  mov bl,bh
  mov cl,saddrot
  rol bh,cl
  cmp bh,bl
  .if carry?
    inc esi
  .endif
  add edi,dadd
  dec yl
  jnz line

  popad
  xor eax,eax
  ret

niv: ;not in view
  popad
  mov eax,1
  ret
g_putb0 endp




g_copyblk proc,x1:dword,y1:dword,x2:dword,y2:dword
  local _add:dword
  local xl:dword,xlb:dword,yl:dword
  local _off:dword
;ModeX locals
  local _off2:dword,_add2:dword,_pc:byte,_xl2c:byte

  pushad

  mov eax,x1
  cmp eax,_v_win_x2
  jg niv

  mov ebx,x2
  cmp ebx,_v_win_x1
  jl niv

  mov ecx,y1
  cmp ecx,_v_win_y2
  jg niv

  mov edx,y2
  cmp edx,_v_win_y1
  jl niv

  .if eax < _v_win_x1
    mov eax,_v_win_x1
    mov x1,eax
  .elseif ebx > _v_win_x2
    mov eax,_v_win_x2
    mov x2,eax
  .elseif ecx < _v_win_y1
    mov eax,_v_win_y1
    mov y1,eax
  .elseif edx > _v_win_y2
    mov eax,_v_win_y2
    mov y2,eax
  .endif

  .if (mouse_con)
    cli
    mov m_paws,1
    call _print
    sti
  .endif

  mov eax,x2
  sub eax,x1
  inc eax
  mov xl,eax
  mul _v_bypp
  mov xlb,eax

  mov eax,y2
  sub eax,y1
  inc eax
  mov yl,eax

  mov eax,y1
  mul _v_xb
  mov ecx,eax
  mov eax,x1
  mul _v_bypp
  add ecx,eax
  mov _off,ecx  ;ECX used ...

  jmp [_copy2]

copy2_modex::   ;;mx_*
  and cl,3      ;  ... here
  mov al,1
  shl al,cl
  mov modex_plane_wr,al
  mov eax,_v_xb
  sub eax,xlb
  ;EAX = _add
  add eax,3
  and al,0ffh-3
  mov _add,eax
  shr eax,2
  mov _add2,eax
  mov eax,xl
  mov _xl2c,al
  and _xl2c,3
  shr eax,2
  mov ebx,eax   ;XL/4
  mov eax,_off
  shr eax,2
  mov _off2,eax
  mov _pc,4  ;Plane counter
  mov dx,vga_SC_INDEX 
  mov al,02h
  mov ah,modex_plane_wr
  out dx,ax     ; enable writes to 1st plane
mx_l2:
  mov esi,_v_buffer
  add esi,_off
  mov edi,_v_linear
  add edi,_off2

  .if _xl2c
    inc ebx
    sub _add,4
    dec _add2
  .endif
  test ebx,ebx   ;this can happen when xl=3 or less
  jz mx_z1

  mov eax,yl
mx_l1:
  mov ecx,ebx
@@:
  movsb
  add esi,3
  dec ecx
  jnz @b
  add esi,_add
  add edi,_add2
  dec eax
  jnz mx_l1

mx_z1:
  .if _xl2c
    dec ebx
    add _add,4
    inc _add2
    dec _xl2c
  .endif

  dec _pc
  jz done
  inc _off
  mov ah,modex_plane_wr
  shl ah,1
  .if ah==16
    mov ah,1
    inc _off2
  .endif
  mov modex_plane_wr,ah
  mov al,02h
  out dx,ax     ; enable writes to plane
  jmp mx_l2

copy2_vesa::    ;;v_*
;  mov eax,xl
;  cmp eax,_v_x
;  je v_noadd
  mov eax,_v_xb
  sub eax,xlb
  ;EAX = _add
  mov _add,eax
  mov esi,_v_buffer
  mov edi,_v_linear
  add esi,_off
  mov eax,_off
  mov edx,eax
  and edx,0ffffh
  shr eax,16
;  xor edx,edx
;  mov ebx,64*1024
;  div ebx
  ; al=bank # required
  ; edx=offset required (remainder)
  .if al!=vesa_current_bank
    callp vesa_setbank,al
  .endif
  add edi,edx

  mov ebx,yl
  mov eax,64*1024 ;when this reaches 0 then we must switch to next bank
  sub eax,edx
  mov edx,eax
  ;copy a scan line
@@:
  mov ecx,xlb
  .if edx<=ecx
    mov ecx,edx  ;use rest of bank
    copyECX
    mov edi,_v_linear
    mov ecx,xlb
    sub ecx,edx
    mov edx,64*1024
    sub edx,ecx
    call vesa_nextbank
    copyECX      ;copy rest of scan line
  .else
    sub edx,ecx
    copyECX      ;copy entire scan line
  .endif
  add esi,_add
  ;Add _add to EDI
  .if edx<=_add
    call vesa_nextbank
    mov edi,_v_linear
    mov eax,_add
    sub eax,edx
    add edi,eax
    mov edx,64*1024
    sub edx,eax
  .else
    sub edx,_add
    add edi,_add
  .endif
  dec ebx
  jnz @b
  jmp done

copy2_vesax::    ;;vx_*
;  mov eax,xl
;  cmp eax,_v_x
;  je v_noadd
  mov eax,_v_xb
  sub eax,xlb
  ;EAX = _add
  mov _add,eax
  mov esi,_v_buffer
  mov edi,_v_linear
  add esi,_off
  mov eax,_off
  mov edx,eax
  and edx,0ffffh
  shr eax,16
;  xor edx,edx
;  mov ebx,64*1024
;  div ebx
  ; al=bank # required
  ; edx=offset required (remainder)
  .if al!=vesa_current_bank
    callp vesa_setbank,al
  .endif
  add edi,edx

  mov ebx,yl
  mov eax,64*1024 ;when this reaches 0 then we must switch to next bank
  sub eax,edx
  mov edx,eax
  ;copy a scan line
@@:
  mov ecx,xlb
  .if edx<ecx
    push ecx
    mov ecx,edx  ;use rest of bank
    copyECX
    mov edi,_v_linear
    pop ecx
    sub ecx,edx
    mov edx,64*1024
    call vesa_nextbank
    sub edx,ecx
    copyECX
  .else
    sub edx,ecx
    copyECX
  .endif
  add esi,_add
  ;Add _add to EDI
  .if edx<_add
    call vesa_nextbank
    mov edi,_v_linear
    mov eax,_add
    sub eax,edx
    add edi,eax
    mov edx,64*1024
    sub edx,eax
  .else
    sub edx,_add
    add edi,_add
  .endif
  .if edx<_v_xbpsl
    callp vesa_nextbank
    mov edi,_v_linear
    mov eax,_v_xbpsl
    sub eax,edx
    mov edx,64*1024
    sub edx,eax
    add edi,eax
  .else
    sub edx,_v_xbpsl
    add edi,_v_xbpsl
  .endif
  dec ebx
  jnz @b
  jmp done

copy2_linearx::   ;;lx_*
  mov eax,xl
  cmp eax,_v_x
  je lx_noadd
  mov eax,_v_xb
  sub eax,xlb
  ;EAX = _add
  mov _add,eax
  add eax,_v_xbpsl
  mov _add2,eax
  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,_off
  add edi,_off

@@:
  mov ecx,xlb
  copyECX
   ;copy one line
  add esi,_add
  add edi,_add2
  dec yl
  jnz @b
  jmp done

lx_noadd:
  mov eax,_v_xb
  mul _v_y
  mov ecx,eax
  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,_off
  add edi,_off
@@:
  mov ecx,xlb
  dec yl
  jnz @b

copy2_linear::   ;;l_*
  mov eax,xl
  cmp eax,_v_x
  je l_noadd
  mov eax,_v_xb
  sub eax,xlb
  ;EAX = _add
  mov _add,eax
  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,_off
  add edi,_off
  mov edx,_add

@@:
  mov ecx,xlb
  copyECX
  add esi,edx
  add edi,edx
  dec yl
  jnz @b
  jmp done

l_noadd:
  mov eax,_v_xb
  mul yl
  mov ecx,eax
  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,_off
  add edi,_off
  copyECX

done:
  .if (mouse_con)
    cli
    callp erase,1
    mov m_paws,0
    sti
  .endif

niv:   ;not in view
  popad
  ret
g_copyblk endp




