.data
align 4
g_copy_type dd offset copy_modex,offset copy_vesa,offset copy_vesax
            dd offset copy_linear,offset copy_linearx

.code
;copys _v_buffer to video RAM
align 4
g_copy proc
  pushad

  g_copy_init

  mov eax,_v_acctype  ;access type
  add eax,offset g_copy_type
  jmp dptr[eax]

copy_modex::
  mov esi,_v_buffer
  mov ebx,modex_size
  mov edi,_v_linear
  mov ecx,ebx
  mov dx,vga_SC_INDEX 
  mov ax,0102h
  mov modex_plane_wr,1
  out dx,ax     ; enable writes to plane #0
@@:
  movsb
  add esi,3
  dec ecx
  jnz @b
  
  mov edi,_v_linear
  mov esi,_v_buffer
  inc esi
  mov ecx,ebx
  shl ah,1
  mov modex_plane_wr,2
  out dx,ax     ; enable writes to plane #1
@@:
  movsb
  add esi,3
  dec ecx
  jnz @b

  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,2
  mov ecx,ebx
  shl ah,1
  mov modex_plane_wr,4
  out dx,ax     ; enable writes to plane #2
@@:
  movsb
  add esi,3
  dec ecx
  jnz @b

  mov edi,_v_linear
  mov esi,_v_buffer
  add esi,3
  mov ecx,ebx
  shl ah,1
  mov modex_plane_wr,8
  out dx,ax     ; enable writes to plane #3
@@:
  movsb
  add esi,3
  dec ecx
  jnz @b
  jmp done

copy_vesa::
  callp vesa_setbank,0
  mov ecx,_v_xb
  mov ebx,_v_y
  mov edi,_v_linear
  mov esi,_v_buffer
  mov edx,64*1024 ;when this reaches 0 then we must switch to next bank
  ;copy a scan line
@@:
  .if edx<=ecx
    push ecx
    mov ecx,edx  ;use rest of bank
    copyECX
    mov edi,_v_linear
    pop ecx
    sub ecx,edx
    mov edx,64*1024
    call vesa_nextbank
    sub edx,ecx
    copyECX
  .else
    sub edx,ecx
    copyECX
  .endif
  mov ecx,_v_xb
  dec ebx
  jnz @b
  jmp done

copy_vesax::
  callp vesa_setbank,0
  mov ecx,_v_xb
  mov ebx,_v_y
  mov edi,_v_linear
  mov esi,_v_buffer
  mov edx,64*1024 ;when this reaches 0 then we must switch to next bank
  ;copy a scan line
@@:
  .if edx<=ecx
    push ecx
    mov ecx,edx  ;use rest of bank
    copyECX
    mov edi,_v_linear
    pop ecx
    sub ecx,edx
    mov edx,64*1024
    callp vesa_nextbank
    sub edx,ecx
    copyECX
  .else
    sub edx,ecx
    copyECX
  .endif
  mov ecx,_v_xb
  .if edx<=_v_xbpsl
    callp vesa_nextbank
    mov edi,_v_linear
    mov eax,_v_xbpsl
    sub eax,edx
    mov edx,64*1024
    sub edx,eax
    add edi,eax
  .else
    sub edx,_v_xbpsl
    add edi,_v_xbpsl
  .endif
  dec ebx
  jnz @b
  jmp done

copy_linearx::
  mov edx,_v_xb
  mov ebx,_v_y
  mov edi,_v_linear
  mov esi,_v_buffer
@@:
  mov ecx,edx
  copyECX  ;Destroys EAX
  add edi,_v_xbpsl
  dec ebx
  jnz @b
  jmp done

copy_linear::
  mov eax,_v_xb
  mul _v_y
  mov ecx,eax
  mov edi,_v_linear
  mov esi,_v_buffer
  copyECX

done:

  g_copy_uninit

  popad
  ret
g_copy endp
