include src\qlib.inc
include process.inc
include dos.inc
include alloc.inc
include string.inc
include dpmi.inc
include errno.inc
include stdio.inc

.code

amode equ [ebp+16]    ;;optional parameter to open()

open proc,strg:dword,acc:word,a:vararg
;string of file asciiz
;access mode (O_... see - fcntl.h)
;ret ax:handle
; NOTE : O_TEXT,O_BINARY are ignored!
  pushad
  .if (!(acc & O_BINARY)) && (!(acc & O_TEXT))
    mov ax,_fmode
    or acc,ax
  .endif
  .if acc & O_TEXT  ;BUG!
    callp printf,"QLIB Warning:O_TEXT not supported.  Using O_BINARY mode instead!\n"
  .endif
  mov edx,strg
  test acc,O_TRUNC
  jz ok2
  and acc,NOT O_EXCL    ;remove O_EXCL
ok1:
  mov ah,3ch  ;creat file
  xor ecx,ecx
;  test word ptr amode,S_IWRITE
;  jnz @f
;  or cl,1    ;set read only flag
;@@:
  int 21h
  jc f_err
  mov ebx,eax
  mov ah,3eh      ;close file so we can open with the right access
  int 21h         ; But this does not work is S_IWRITE is not used!
  jc f_err
ok2:
  mov al,bptr[acc]
;  and al,3   ;FIX : v2.11 b2 : must allow all of the "share" options
  mov ah,3dh  ;open file
  xor ecx,ecx
;  test word ptr amode,S_IWRITE
;  jnz @f
;  or cl,1   ;set read only flag
;@@:
  int 21h
  jnc ok3
  cmp ax,2    ;file not found
  jnz f_err
  .if !(acc & O_CREAT)
    jmp f_err
  .endif
  and acc,NOT O_EXCL
  jmp ok1
ok3:
  test acc,O_CREAT
  jz ok4
  test acc,O_EXCL
  jnz bad1
ok4:
  test acc,O_APPEND
  jz ok5
  mov ebx,eax  ;save for ...
  xor edx,edx
  mov ax,4202h
  int 21h
  mov eax,ebx
ok5:
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;...here EAX returned!
@@:
  popad
  ret
bad1:
  mov ebx,eax
  mov ah,3eh   ;close file
  int 21h
  mov eax,5
;  jmp f_err
f_err::  ;:: makes it global scope (but only in this OBJ)
  mov errno,ax
  popad
  mov eax,ERROR
  ret
open endp

close proc,hand:word
;ret- none
  pushad
  mov bx,hand
  mov ah,3eh
  int 021h
  jc f_err
  popad
  xor eax,eax
  ret
close endp

creat proc,strg:dword,attr:word
;creat file always in binary mode
;string of file asciiz
;attributes (0=normal)
;ret-ax - handle
  pushad
  mov ah,3ch
  xor ecx,ecx
  test attr,S_IWRITE
  jnz @f
  or cl,1   ;set Read only flag
@@:
  mov edx,strg
  int 021h
  jc f_err
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx
  popad
  ret
creat endp

_creat proc,strg:dword,attr:word
;creat file always in binary mode
;string of file asciiz
;attributes (0=normal)
;ret-ax - handle
  pushad
  mov ah,3ch
  mov cx,attr   ;FA_...
  mov edx,strg
  int 021h
  jc f_err
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx
  popad
  ret
_creat endp

read proc,hand:word,buf:dword,len:dword
  pushad
  mov ah,3fh
  mov bx,hand
  mov ecx,len
  mov edx,buf
  int 021h
  jc f_err
  mov [esp+7*4],eax
  popad
  ret
read endp

write proc,hand:word,buf:dword,len:dword
  pushad
  mov bx,hand
  mov ecx,len
  mov edx,buf
  mov ah,40h
  int 021h
  jc f_err
  mov [esp+7*4],eax
  popad
  ret
write endp

lseek proc,hand:word,pos:dword,typ:byte
  pushad
  mov ah,42h
  mov al,typ
  mov bx,hand
  mov edx,pos
  mov ecx,edx
  shr ecx,16    ;CX:DX
  int 21h       ;DX:AX
  jc f_err
  shl edx,16
  mov dx,ax
  mov [esp+7*4],edx  ;save EAX
  popad
  ret
lseek endp

tell proc,hand:word
  pushad
  mov ah,42h
  mov al,1  ;relative
  mov bx,hand
  xor edx,edx
  xor ecx,ecx
  int 21h  ;cx:dx
  jc f_err
  ;dx:ax=current file pos
  shl edx,16
  mov dx,ax
  mov [esp+7*4],edx
  popad
  ret
tell endp

eof_siz dd ?  ;no locals allowed

eof proc,hand:word
  ;return 1 if file pos=file size
  callp filelength,hand
  .if eax==ERROR
    ret
  .endif
  mov eof_siz,eax
  callp tell,hand
  .if eof_siz==eax
    mov eax,1
  .else
    mov eax,0
  .endif
  ret
eof endp

filelength proc,hand:word
  local fl_loc:dword
  local fl_siz:dword
  pushad
  invoke tell,hand
  .if eax==ERROR
    popad
    mov eax,ERROR
    ret
  .endif
  mov fl_loc,eax
  mov ah,42h
  mov al,2
  mov bx,hand
  xor edx,edx
  xor ecx,ecx
  int 21h
  jc f_err
  shl edx,16
  mov dx,ax
  mov fl_siz,edx
  mov ah,42h
  mov al,0
  mov bx,hand
  mov ecx,fl_loc
  mov edx,ecx
  shr ecx,16
  int 21h  ;CX:DX
  jc f_err
  mov eax,fl_siz
  mov [esp+7*4],eax
  popad
  ret
filelength endp

unlink proc,strg:dword
  pushad
  mov edx,strg
  mov ah,41h
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
unlink endp

chdir proc,strg:dword
  pushad
  mov edx,strg
  mov ah,3bh
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
chdir endp

mkdir proc,strg:dword
  pushad
  mov edx,strg
  mov ah,39h
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
mkdir endp

rmdir proc,strg:dword
  pushad
  mov edx,strg
  mov ah,3ah
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
rmdir endp

getdisk proc
  pushad
  mov ah,19h
  int 21h
  jc f_err
  movzx eax,al
  mov [esp+7*4],eax
  popad
  ret
getdisk endp

setdisk proc,drv:byte
  pushad
  mov ah,0eh
  mov dl,drv
  int 21h
  jc f_err
  movzx eax,al
  mov [esp+7*4],eax
  popad
  ret
setdisk endp

rename proc,old:dword,new:dword
  pushad
  mov ah,56h
  mov edi,new
  mov edx,old
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
rename endp

;Get current working dir.
getcwd proc,buf:dword
  pushad
  mov ah,47h
  mov esi,buf
  mov dl,0
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
getcwd endp

;Get Drive's current working dir.
getdcwd proc,drv:byte,buf:dword
  pushad
  mov ah,47h
  mov esi,buf
  mov dl,drv
  int 21h
  jc f_err
  popad
  xor eax,eax
  ret
getdcwd endp

findfirst proc,str1:dword,ffb:dword,attr:word
  pushad
  mov ah,4eh
  mov edx,str1
  mov cx,attr
  int 21h
  jc f_err
  mov esi,_dta
  mov edi,ffb
  mov ecx,sizeof ffblk
  copyECX  ;destroys AL
  popad
  xor eax,eax
  ret
findfirst endp

;FIX : v2.11 Beta #5 : the DTA needs to be refreshed in cause something
;                      destroys the ffb struct in there
findnext proc,ffb:dword
  pushad
  mov esi,ffb
  mov edi,_dta
  mov ecx,sizeof ffblk
  copyECX  ;destroys AL
  mov ah,4fh
  int 21h
  jc f_err
  mov esi,_dta
  mov edi,ffb
  mov ecx,sizeof ffblk
  copyECX  ;destroys AL
  popad
  xor eax,eax
  ret
findnext endp

_endseg

end
