.data
externdef  __r_cln:real8
externdef  __ZERO:real8
externdef  __EXP_MAX:real8
externdef  __ten:REAL8
externdef  __one:REAL8
externdef  __rnd_0:word
externdef  __rnd_up:word
externdef  __rnd_dw:word
externdef  __cw_def:word

.code
CHKF macro    ;sets errno based on value on top of FPU stack
  fxam
  fstsw ax
  fwait
  and ah,01000111b  ;mask C0,C1,C2,C3
  .if (ah == 001b) || (ah == 011b)
    ;+/-NAN
    mov errno,EDOM
  .elseif (ah == 101b) || (ah == 111b)
    ;+/-INF
    mov errno,ERANGE
  .endif
endm

;This macro may seem useless but it is not!
;This will remove any 'extreme' small values.
;This has to do with something between REAL8 and REAL10 precision
;It may be caused by an FPU bug?
CleanREAL8 macro
  fstp __r_cln
  fld __r_cln
  fwait
endm

fint macro @@QWORDPTR                   ;integerize float number
  ;Does not change @@QWORDPTR
  ;Return : __r_int = integerized #
  fldcw __rnd_0
  fld @@QWORDPTR                        ;load value to get integer part
  frndint                               ;round to integer
  fstp __r_int                          ;store (rounded) integer
  fldcw __cw_def
endm

_fint macro @@QWORDPTR                  ;integerize float number
  ;Changes @@QWORDPTR
  ;Return : @@QWORDPTR = integerized #
  fldcw __rnd_0
  fld @@QWORDPTR                        ;load value to get integer part
  frndint                               ;round to integer
  fstp @@QWORDPTR                       ;store (rounded) integer
  fldcw __cw_def
endm

frnd macro @@QWORDPTR, @@DIGITS         ;round off for FPU inaccurace
  ;Rounds 0.999999 to 1.0 as FPU regs can not hold some values "perfectly"
  ;NOTE : FPU Stack must be empty (FIX : v2.11 b2)
  ;Changes @@QWORDPTR
  ;Return : @@QWORDPTR = rounded #
  push eax
  push ebx
  push ecx
  push edx                              ;save regs

  ifdifi <@@DIGITS>,<edx>
    mov edx, @@DIGITS
  endif
  inc edx 
  mov __t_rndd1,edx
  fild __t_rndd1
  fstp __r_rnd
  fwait
  callp pow10,__r_rnd                   ;pow(10, digits+1)
  fstp __r_pow
  fint @@QWORDPTR                       ;integerize (return in __r_int)
  fld @@QWORDPTR                        ;load value
  fsub __r_int                          ;subtract whole part
  fmul __r_pow                          ;mul fractional part by power
  fstp __r_rnd                          ;store powered fractional part
  fint __r_rnd                          ;integerize powered fractional part
  fld __r_int
  fstp __r_rnd2                         ;cmp1
  fld __r_rnd
  fdiv __ten
  fstp __r_rnd
  fint __r_rnd                          ;cmp2
  fld __r_int
  fmul __ten
  fsub __r_rnd2
  fchs                                  ;change to positive
  ;If st(0) == 9 then we should add 0.xxx1 to @@QWORDPTR
  fistp __t_rndd1
  fwait
  .if __t_rndd1==9
    mov __t_rndd1,1
    fild __t_rndd1
    fdiv __r_pow
    fadd @@QWORDPTR
    fstp @@QWORDPTR
    fwait
  .endif

  pop edx
  pop ecx
  pop ebx
  pop eax
endm

fround macro @@QWORDPTR, @@DIGITS       ;round "dizimas periodicas"
  ;Rounds 0.0045 to 0.0050 if needed by printf() etc.
  ;NOTE : FPU Stack must be empty (FIX : v2.11 b2)
  ;Changes @@QWORDPTR
  ;Return : @@QWORDPTR = rounded #
  
  ifdifi <@@DIGITS>,<edx>
    mov edx, @@DIGITS
  endif
  inc edx 
  mov __t_rndd1,edx
  fild __t_rndd1
  fstp __r_rnd
  fwait
  callp pow10,__r_rnd                 ;pow(10, digits+1)
  mov __t_rndd1,5
  fild __t_rndd1
  fxch st(1)
  fdivp st(1),st
  fadd @@QWORDPTR
  fstp @@QWORDPTR
  fwait
endm

;Is fwait required on the 386 anymore?
_fwait macro
  ;;fwait   ;;my guess is no
endm

;for older code (_ftoa1_)
_fint macro @@QWORDPTR               ;integrerize float number
    fld     @@QWORDPTR              ;load value to get integer part
    frndint                         ;round to integrer
    fstsw   ax                      ;store flags
    fistp   dptr [__t_rint]           ;store (rounded) integrer
    fwait

    .if ah & 2  ;mask C1
      mov eax,dptr [__t_rint]
      dec eax
    .else
      mov eax,dptr [__t_rint]
    .endif
endm

